/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.webapp.mgt.loader;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.catalina.startup.ClassLoaderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.webapp.mgt.loader.CLEnvironment;
import org.wso2.carbon.webapp.mgt.loader.ClassloadingConfiguration;
import org.wso2.carbon.webapp.mgt.loader.SharedURLClassLoader;

public class SharedClassLoaderFactory {
    private static final Log log = LogFactory.getLog(SharedClassLoaderFactory.class);
    private static SharedClassLoaderFactory instance = new SharedClassLoaderFactory();
    private URLClassLoader sharedClassLoader;
    private Map<String, URLClassLoader> environmentClassLoaders = new HashMap<String, URLClassLoader>();

    private SharedClassLoaderFactory() {
    }

    public static SharedClassLoaderFactory getInstance() {
        return instance;
    }

    public void init(ClassloadingConfiguration classloadingConfig) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        this.sharedClassLoader = new SharedURLClassLoader(new URL[0], contextClassLoader);
        classloadingConfig.getExclusiveEnvironments().forEach((name, clEnvironment) -> this.createClassloader((String)name, (CLEnvironment)clEnvironment, contextClassLoader));
    }

    private void createClassloader(String name, CLEnvironment environment, ClassLoader parentClassLoader) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating shared class loader for " + name));
        }
        ArrayList<ClassLoaderFactory.Repository> repositories = new ArrayList<ClassLoaderFactory.Repository>();
        if (environment == null || environment.getDelegatedPackageArray() == null) {
            return;
        }
        for (String repositoryLocation : environment.getDelegatedPackageArray()) {
            if (this.environmentClassLoaders.containsKey(name)) continue;
            if (repositoryLocation.endsWith("*.jar")) {
                repositoryLocation = repositoryLocation.substring(0, repositoryLocation.length() - "*.jar".length());
                repositories.add(new ClassLoaderFactory.Repository(repositoryLocation, ClassLoaderFactory.RepositoryType.GLOB));
                continue;
            }
            if (repositoryLocation.endsWith(".jar")) {
                repositories.add(new ClassLoaderFactory.Repository(repositoryLocation, ClassLoaderFactory.RepositoryType.URL));
                continue;
            }
            if (repositoryLocation.endsWith("/*")) {
                repositoryLocation = repositoryLocation.substring(0, repositoryLocation.length() - 2);
                repositoryLocation = this.normalizeRepositoryLocation(repositoryLocation);
                repositories.add(new ClassLoaderFactory.Repository(repositoryLocation, ClassLoaderFactory.RepositoryType.DIR));
                continue;
            }
            if (repositoryLocation.endsWith("/")) {
                repositoryLocation = repositoryLocation.substring(0, repositoryLocation.length() - 1);
                repositoryLocation = this.normalizeRepositoryLocation(repositoryLocation);
                repositories.add(new ClassLoaderFactory.Repository(repositoryLocation, ClassLoaderFactory.RepositoryType.DIR));
                continue;
            }
            repositoryLocation = this.normalizeRepositoryLocation(repositoryLocation);
            repositories.add(new ClassLoaderFactory.Repository(repositoryLocation, ClassLoaderFactory.RepositoryType.DIR));
        }
        try {
            ClassLoader classloader = ClassLoaderFactory.createClassLoader(repositories, (ClassLoader)parentClassLoader);
            this.environmentClassLoaders.put(name, (URLClassLoader)classloader);
        }
        catch (Exception e) {
            log.error((Object)("Error while creating class loader for " + name), (Throwable)e);
        }
    }

    private String normalizeRepositoryLocation(String repositoryLocation) {
        String strip = "file:" + (File.separatorChar == '/' ? "" : "/");
        return repositoryLocation.replace(strip, "");
    }

    public URLClassLoader getSharedClassLoader() {
        return this.sharedClassLoader;
    }

    public URLClassLoader getEnvironmentClassLoader(String environmentName) {
        return this.environmentClassLoaders.get(environmentName);
    }
}

