/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.webapp.mgt.loader;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.webapp.mgt.loader.SharedClassLoaderFactory;
import org.wso2.carbon.webapp.mgt.loader.WebappClassloadingContext;

class SharedURLClassLoader
extends URLClassLoader {
    private static final Log log = LogFactory.getLog(SharedURLClassLoader.class);
    private WebappClassloadingContext webappCC;

    public SharedURLClassLoader(URL[] array, ClassLoader parent) {
        super(array, parent);
    }

    public void setWebappCC(WebappClassloadingContext classloadingContext) {
        this.webappCC = classloadingContext;
    }

    private URLClassLoader getSharedEnvironmentClassLoader(String environment) {
        return SharedClassLoaderFactory.getInstance().getEnvironmentClassLoader(environment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> c = this.findLoadedClass(name);
            if (c == null) {
                boolean delegatedPkg = this.webappCC.isDelegatedPackage(name);
                boolean excludedPkg = this.webappCC.isExcludedPackage(name);
                if (this.webappCC.isParentFirst() && delegatedPkg && !excludedPkg && (c = super.getParent().loadClass(name)) != null) {
                    return c;
                }
                c = this.findClassFromEnvironmentalClassLoaders(name, resolve);
                if (c != null) {
                    return c;
                }
                if (!this.webappCC.isParentFirst() && delegatedPkg && !excludedPkg && (c = super.getParent().loadClass(name)) != null) {
                    return c;
                }
            }
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
    }

    private Class<?> findClassFromEnvironmentalClassLoaders(String name, boolean resolve) {
        Class<?> clazz = null;
        if (this.webappCC.getEnvironments() == null) {
            return null;
        }
        for (String environment : this.webappCC.getEnvironments()) {
            URLClassLoader loader = this.getSharedEnvironmentClassLoader(environment);
            if (log.isDebugEnabled()) {
                log.debug((Object)("  Delegating to Environmental classloader " + loader));
            }
            if (loader == null) continue;
            try {
                clazz = loader.loadClass(name);
                if (clazz == null) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("  Loading class from " + loader + " Environmental classloader"));
                }
                if (resolve) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
            catch (ClassNotFoundException | NoClassDefFoundError throwable) {
                // empty catch block
            }
        }
        return clazz;
    }

    @Override
    public URL findResource(String name) {
        if (this.webappCC.getEnvironments() == null) {
            return null;
        }
        for (String environment : this.webappCC.getEnvironments()) {
            URLClassLoader exclusiveEnvironmentClassloader = this.getSharedEnvironmentClassLoader(environment);
            if (exclusiveEnvironmentClassloader == null) continue;
            return exclusiveEnvironmentClassloader.findResource(name);
        }
        return null;
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        if (this.webappCC.getEnvironments() == null) {
            return null;
        }
        for (String environment : this.webappCC.getEnvironments()) {
            Enumeration<URL> url;
            URLClassLoader exclusiveEnvironmentClassloader = this.getSharedEnvironmentClassLoader(environment);
            if (exclusiveEnvironmentClassloader == null || (url = exclusiveEnvironmentClassloader.findResources(name)) == null) continue;
            return url;
        }
        return null;
    }
}

