/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.webapp.mgt.loader;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Paths;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.apache.catalina.loader.WebappClassLoader;
import org.apache.catalina.loader.WebappClassLoaderBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.webapp.mgt.loader.CompoundEnumeration;
import org.wso2.carbon.webapp.mgt.loader.SharedClassLoaderFactory;
import org.wso2.carbon.webapp.mgt.loader.SharedURLClassLoader;
import org.wso2.carbon.webapp.mgt.loader.WebappClassloadingContext;

public class CarbonWebappClassLoader
extends WebappClassLoader {
    private static final Log log = LogFactory.getLog(CarbonWebappClassLoader.class);
    private WebappClassloadingContext webappCC;
    private static List<String> systemPackages;
    private static final String CLASS_FILE_SUFFIX = ".class";

    public CarbonWebappClassLoader(ClassLoader parent) {
        super((ClassLoader)SharedClassLoaderFactory.getInstance().getSharedClassLoader());
        String launchIniPath = Paths.get(CarbonUtils.getCarbonConfigDirPath(), "etc", "launch.ini").toString();
        this.readSystemPackagesList(launchIniPath);
    }

    public void setWebappCC(WebappClassloadingContext classloadingContext) {
        this.webappCC = classloadingContext;
        ((SharedURLClassLoader)this.parent).setWebappCC(classloadingContext);
    }

    public synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        int i;
        boolean tryLoadingFromJavaseLoader;
        if (log.isDebugEnabled()) {
            log.debug((Object)("loadClass(" + name + ", " + resolve + ")"));
        }
        this.checkStateForClassLoading(name);
        Class<?> clazz = this.findLoadedClass0(name);
        if (clazz != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"  Returning class from cache");
            }
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        clazz = this.findLoadedClass(name);
        if (clazz != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"  Returning class from cache");
            }
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        String resourceName = this.binaryNameToPath(name, false);
        ClassLoader javaseLoader = this.getJavaseClassLoader();
        try {
            URL url;
            if (this.securityManager != null) {
                WebappClassLoaderBase.PrivilegedJavaseGetResource dp = new WebappClassLoaderBase.PrivilegedJavaseGetResource((WebappClassLoaderBase)this, resourceName);
                url = (URL)AccessController.doPrivileged(dp);
            } else {
                url = javaseLoader.getResource(resourceName);
            }
            tryLoadingFromJavaseLoader = url != null;
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable((Throwable)t);
            tryLoadingFromJavaseLoader = true;
        }
        if (tryLoadingFromJavaseLoader) {
            try {
                clazz = javaseLoader.loadClass(name);
                if (clazz != null) {
                    if (resolve) {
                        this.resolveClass(clazz);
                    }
                    return clazz;
                }
            }
            catch (ClassNotFoundException t) {
                // empty catch block
            }
        }
        if (this.securityManager != null && (i = name.lastIndexOf(46)) >= 0) {
            try {
                this.securityManager.checkPackageAccess(name.substring(0, i));
            }
            catch (SecurityException se) {
                String error = sm.getString("webappClassLoader.restrictedPackage", new Object[]{name});
                log.info((Object)error, (Throwable)se);
                throw new ClassNotFoundException(error, se);
            }
        }
        if (this.webappCC.isParentFirst() && (clazz = this.findClassFromParent(name, resolve)) != null) {
            return clazz;
        }
        clazz = this.findLocalClass(name, resolve);
        if (clazz != null) {
            return clazz;
        }
        if (!this.webappCC.isParentFirst() && (clazz = this.findClassFromParent(name, resolve)) != null) {
            return clazz;
        }
        throw new ClassNotFoundException(name);
    }

    protected Class<?> findClassFromParent(String name, boolean resolve) throws ClassNotFoundException {
        ClassLoader loader;
        Class<?> clazz = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("  Delegating to parent classloader1 " + this.parent));
        }
        if ((loader = this.parent) == null) {
            loader = this.getJavaseClassLoader();
        }
        try {
            clazz = Class.forName(name, false, loader);
            if (clazz != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"  Loading class from parent");
                }
                if (resolve) {
                    this.resolveClass(clazz);
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return clazz;
    }

    protected Class<?> findLocalClass(String name, boolean resolve) throws ClassNotFoundException {
        Class clazz = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"  Searching local repositories");
        }
        try {
            clazz = this.findClass(name);
            if (clazz != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"  Loading class from local repository");
                }
                if (resolve) {
                    this.resolveClass(clazz);
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return clazz;
    }

    public InputStream getResourceAsStream(String name) {
        ClassLoader loader;
        InputStream stream = super.getResourceAsStream(name);
        if (stream != null) {
            return stream;
        }
        if (name.endsWith(CLASS_FILE_SUFFIX) && this.isSystemPackage(name) && (stream = (loader = this.getJavaseClassLoader()).getResourceAsStream(name)) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"  --> Returning stream from system classloader");
            }
            return stream;
        }
        return null;
    }

    private String binaryNameToPath(String binaryName, boolean withLeadingSlash) {
        StringBuilder path = new StringBuilder(7 + binaryName.length());
        if (withLeadingSlash) {
            path.append('/');
        }
        path.append(binaryName.replace('.', '/'));
        path.append(CLASS_FILE_SUFFIX);
        return path.toString();
    }

    private boolean isSystemPackage(String resourceName) {
        String packageName = (resourceName = resourceName.replace(CLASS_FILE_SUFFIX, "").replace("/", ".")).lastIndexOf(".") == -1 ? resourceName : resourceName.substring(0, resourceName.lastIndexOf("."));
        return systemPackages.contains(packageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readSystemPackagesList(String launchIniPath) {
        Properties properties = new Properties();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(launchIniPath);
            properties.load(fileInputStream);
            String rawSystemPackages = properties.getProperty("org.osgi.framework.system.packages");
            String[] systemPackagesArray = rawSystemPackages.split("[ ]?,[ ]?");
            systemPackages = Arrays.asList(systemPackagesArray);
        }
        catch (IOException e) {
            log.warn((Object)"Error reading system packages list from launch.ini", (Throwable)e);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration[] tmp = new Enumeration[2];
        if (this.parent != null && this.webappCC != null) {
            boolean delegatedRes = this.webappCC.isDelegatedResource(name);
            boolean excludedRes = this.webappCC.isExcludedResources(name);
            if (delegatedRes && !excludedRes) {
                tmp[0] = this.parent.getResources(name);
            }
        }
        tmp[1] = this.findResources(name);
        return new CompoundEnumeration<URL>(tmp);
    }
}

