/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.webapp.mgt.loader;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.catalina.startup.ClassLoaderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.webapp.mgt.loader.CLEnvironment;
import org.wso2.carbon.webapp.mgt.loader.ClassloadingConfiguration;
import org.wso2.carbon.webapp.mgt.loader.SharedURLClassLoader;

public class SharedClassLoaderFactory {
    private static final Log log = LogFactory.getLog(SharedClassLoaderFactory.class);
    private static SharedClassLoaderFactory instance = new SharedClassLoaderFactory();
    private URLClassLoader sharedClassLoader;
    private Map<String, URLClassLoader> environmentClassLoaders = new HashMap<String, URLClassLoader>();

    private SharedClassLoaderFactory() {
    }

    public static SharedClassLoaderFactory getInstance() {
        return instance;
    }

    public void init(ClassloadingConfiguration classloadingConfig) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        this.sharedClassLoader = new SharedURLClassLoader(new URL[0], contextClassLoader);
        classloadingConfig.getExclusiveEnvironments().forEach((name, clEnvironment) -> this.createClassloader((String)name, (CLEnvironment)clEnvironment, contextClassLoader));
    }

    private void createClassloader(String name, CLEnvironment environment, ClassLoader parentClassLoader) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating shared class loader for " + name));
        }
        ArrayList<ClassLoaderFactory.Repository> repositories = new ArrayList<ClassLoaderFactory.Repository>();
        if (environment == null || environment.getDelegatedPackageArray() == null) {
            return;
        }
        for (String repository : environment.getDelegatedPackageArray()) {
            if (this.environmentClassLoaders.containsKey(name)) continue;
            if (repository.endsWith("*.jar")) {
                repository = repository.substring(0, repository.length() - "*.jar".length());
                repositories.add(new ClassLoaderFactory.Repository(repository, ClassLoaderFactory.RepositoryType.GLOB));
                continue;
            }
            if (repository.endsWith(".jar")) {
                repositories.add(new ClassLoaderFactory.Repository(repository, ClassLoaderFactory.RepositoryType.URL));
                continue;
            }
            if (repository.endsWith("/*")) {
                repository = repository.substring(0, repository.length() - 2);
                repositories.add(new ClassLoaderFactory.Repository(repository, ClassLoaderFactory.RepositoryType.DIR));
                continue;
            }
            repositories.add(new ClassLoaderFactory.Repository(repository, ClassLoaderFactory.RepositoryType.DIR));
        }
        try {
            ClassLoader classloader = ClassLoaderFactory.createClassLoader(repositories, (ClassLoader)parentClassLoader);
            this.environmentClassLoaders.put(name, (URLClassLoader)classloader);
        }
        catch (Exception e) {
            log.error((Object)("Error while creating class loader for " + name), (Throwable)e);
        }
    }

    public URLClassLoader getSharedClassLoader() {
        return this.sharedClassLoader;
    }

    public URLClassLoader getEnvironmentClassLoader(String environmentName) {
        return this.environmentClassLoaders.get(environmentName);
    }
}

