/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.webapp.mgt.loader;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.carbon.core.util.Utils;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.webapp.mgt.loader.CLEnvironment;
import org.wso2.carbon.webapp.mgt.loader.ClassloadingConfiguration;
import org.wso2.carbon.webapp.mgt.loader.SharedClassLoaderFactory;
import org.wso2.carbon.webapp.mgt.loader.WebappClassloadingContext;
import org.wso2.carbon.webapp.mgt.utils.XMLUtils;

public class ClassloadingContextBuilder {
    private static final Log log = LogFactory.getLog(ClassloadingContextBuilder.class);

    public static synchronized ClassloadingConfiguration buildSystemConfig() throws Exception {
        ClassloadingConfiguration classloadingConfig = new ClassloadingConfiguration();
        String carbonConfigPath = CarbonUtils.getCarbonConfigDirPath();
        String envConfigPath = Paths.get(carbonConfigPath, "tomcat", "webapp-classloading-environments.xml").toString();
        String clConfigPath = Paths.get(carbonConfigPath, "tomcat", "webapp-classloading.xml").toString();
        File envConfigFile = new File(envConfigPath);
        if (!envConfigFile.exists()) {
            throw new FileNotFoundException(envConfigPath);
        }
        ClassloadingContextBuilder.populateEnvironments(classloadingConfig, envConfigFile);
        File clConfigFile = new File(clConfigPath);
        if (!clConfigFile.exists()) {
            throw new FileNotFoundException(clConfigPath);
        }
        ClassloadingContextBuilder.loadClassloadingPolicy(classloadingConfig, clConfigFile);
        SharedClassLoaderFactory.getInstance().init(classloadingConfig);
        return classloadingConfig;
    }

    public static WebappClassloadingContext buildClassloadingContext(String webappFilePath) throws Exception {
        String[] environments;
        ClassloadingConfiguration classloadingConfig = WebappClassloadingContext.getClassloadingConfig();
        WebappClassloadingContext webappClassloadingContext = new WebappClassloadingContext();
        URL appCLConfigFileURL = ClassloadingContextBuilder.getClassloadingConfigFileURL(webappFilePath);
        if (appCLConfigFileURL == null) {
            webappClassloadingContext.setParentFirst(classloadingConfig.isParentFirst());
            if (classloadingConfig.getEnvironments().length > 0) {
                ArrayList<String> delegatedPackageList = new ArrayList<String>();
                ArrayList<String> delegatedResourceList = new ArrayList<String>();
                for (String env : classloadingConfig.getEnvironments()) {
                    String[] packs = classloadingConfig.getDelegatedEnvironment(env).getDelegatedPackageArray();
                    if (packs == null || packs.length <= 0) continue;
                    for (String pkg : packs) {
                        delegatedPackageList.add(pkg);
                    }
                }
                for (String env : classloadingConfig.getEnvironments()) {
                    String[] res = classloadingConfig.getDelegatedEnvironment(env).getDelegatedResourcesArray();
                    if (res == null || res.length <= 0) continue;
                    for (String resource : res) {
                        delegatedResourceList.add(resource);
                    }
                }
                webappClassloadingContext.setDelegatedPackages(delegatedPackageList.toArray(new String[delegatedPackageList.size()]));
                webappClassloadingContext.setDelegatedResources(delegatedResourceList.toArray(new String[delegatedResourceList.size()]));
                if (delegatedPackageList.size() == 0) {
                    webappClassloadingContext.setDelegatedPackages(classloadingConfig.getDelegatedEnvironment("Carbon").getDelegatedPackageArray());
                }
                if (delegatedResourceList.size() == 0) {
                    webappClassloadingContext.setDelegatedResources(classloadingConfig.getDelegatedEnvironment("Carbon").getDelegatedResourcesArray());
                }
            } else {
                webappClassloadingContext.setDelegatedPackages(classloadingConfig.getDelegatedEnvironment("Carbon").getDelegatedPackageArray());
                webappClassloadingContext.setDelegatedResources(classloadingConfig.getDelegatedEnvironment("Carbon").getDelegatedResourcesArray());
            }
            webappClassloadingContext.setProvidedRepositories(new String[0]);
            return webappClassloadingContext;
        }
        Document doc = XMLUtils.buildDocumentFromInputStream(appCLConfigFileURL.openStream());
        Node parentFirstNode = doc.getElementsByTagName("ParentFirst").item(0);
        if (parentFirstNode != null) {
            boolean parentFirst = Boolean.parseBoolean(parentFirstNode.getTextContent());
            webappClassloadingContext.setParentFirst(parentFirst);
        } else {
            webappClassloadingContext.setParentFirst(classloadingConfig.isParentFirst());
        }
        Node envNode = doc.getElementsByTagName("Environments").item(0);
        if (envNode != null) {
            String envList = envNode.getTextContent();
            environments = ClassloadingContextBuilder.splitStrings(envList, ",");
            environments = ClassloadingContextBuilder.addSystemEnvironment(environments);
        } else {
            environments = classloadingConfig.getEnvironments();
        }
        webappClassloadingContext.setEnvironments(environments);
        ArrayList delegatedPkgList = new ArrayList();
        ArrayList delegatedResourceList = new ArrayList();
        ArrayList providedResources = new ArrayList();
        for (String env : environments) {
            if (classloadingConfig.getDelegatedEnvironment(env) != null) {
                Collections.addAll(delegatedPkgList, classloadingConfig.getDelegatedEnvironment(env).getDelegatedPackageArray());
                Collections.addAll(delegatedResourceList, classloadingConfig.getDelegatedEnvironment(env).getDelegatedResourcesArray());
                continue;
            }
            if (classloadingConfig.getExclusiveEnvironment(env) != null) {
                Collections.addAll(providedResources, classloadingConfig.getExclusiveEnvironment(env).getDelegatedPackageArray());
                continue;
            }
            throw new Exception("Undefined environment: " + env);
        }
        String[] defaultExtClasspath = ClassloadingContextBuilder.generateClasspath("${carbon.home}/lib/runtimes/ext/*.jar");
        Collections.addAll(providedResources, defaultExtClasspath);
        webappClassloadingContext.setDelegatedPackages(delegatedPkgList.toArray(new String[delegatedPkgList.size()]));
        webappClassloadingContext.setDelegatedResources(delegatedResourceList.toArray(new String[delegatedResourceList.size()]));
        webappClassloadingContext.setProvidedRepositories(providedResources.toArray(new String[providedResources.size()]));
        return webappClassloadingContext;
    }

    private static void populateEnvironments(ClassloadingConfiguration classloadingConfig, File envConfigFile) throws Exception {
        try {
            Document doc = XMLUtils.buildDocumentFromFile(envConfigFile);
            ClassloadingContextBuilder.populateDelegatedEnvironments(classloadingConfig, doc);
            ClassloadingContextBuilder.populateExclusiveEnvironments(classloadingConfig, doc);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new Exception("Failed to populate the ClassloadingConfiguration");
        }
    }

    private static void populateDelegatedEnvironments(ClassloadingConfiguration classloadingConfig, Document doc) {
        NodeList envNodeList = doc.getElementsByTagName("DelegatedEnvironment");
        for (int i = 0; i < envNodeList.getLength(); ++i) {
            Node envNode = envNodeList.item(i);
            if (envNode.getNodeType() != 1) continue;
            Element envElement = (Element)envNode;
            String name = envElement.getElementsByTagName("Name").item(0).getTextContent();
            String delegatedPkgs = envElement.getElementsByTagName("DelegatedPackages").item(0).getTextContent();
            String delegatedResources = envElement.getElementsByTagName("DelegatedResources").item(0).getTextContent();
            String[] delegatedPkgArray = ClassloadingContextBuilder.splitStrings(delegatedPkgs, ",");
            String[] delegatedResArray = ClassloadingContextBuilder.splitStrings(delegatedResources, ",");
            CLEnvironment environment = new CLEnvironment(delegatedPkgArray, delegatedResArray);
            classloadingConfig.addDelegatedEnvironment(name, environment);
        }
    }

    private static void populateExclusiveEnvironments(ClassloadingConfiguration classloadingConfig, Document doc) {
        NodeList envNodeList = doc.getElementsByTagName("ExclusiveEnvironment");
        for (int i = 0; i < envNodeList.getLength(); ++i) {
            Node envNode = envNodeList.item(i);
            if (envNode.getNodeType() != 1) continue;
            Element envElement = (Element)envNode;
            String name = envElement.getElementsByTagName("Name").item(0).getTextContent();
            String classpathStr = envElement.getElementsByTagName("Classpath").item(0).getTextContent();
            String[] classpath = ClassloadingContextBuilder.generateClasspath(classpathStr);
            CLEnvironment environment = new CLEnvironment(classpath, null);
            classloadingConfig.addExclusiveEnvironment(name, environment);
        }
    }

    private static void loadClassloadingPolicy(ClassloadingConfiguration classloadingConfig, File clConfigFile) throws Exception {
        try {
            Document doc = XMLUtils.buildDocumentFromFile(clConfigFile);
            String parentFirstStr = doc.getElementsByTagName("ParentFirst").item(0).getTextContent();
            boolean parentFirst = Boolean.parseBoolean(parentFirstStr);
            classloadingConfig.setParentFirstBehaviour(parentFirst);
            String envStr = doc.getElementsByTagName("Environments").item(0).getTextContent();
            String[] environments = ClassloadingContextBuilder.splitStrings(envStr, ",");
            classloadingConfig.setEnvironments(environments);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new Exception("Failed to populate the ClassloadingConfiguration");
        }
    }

    private static String[] splitStrings(String str, String separator) {
        if (str == null || str.trim().length() == 0) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(str, separator);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.length() == 0) continue;
            list.add(token);
        }
        return list.toArray(new String[list.size()]);
    }

    private static String[] generateClasspath(String classpathStr) {
        StringTokenizer tkn = new StringTokenizer(classpathStr, ";");
        ArrayList entryList = new ArrayList();
        while (tkn.hasMoreTokens()) {
            String token = tkn.nextToken().trim();
            if (token.isEmpty()) continue;
            if ((token = Utils.replaceSystemProperty((String)token)).endsWith("*.jar")) {
                File directory = new File(token = token.substring(0, token.length() - "*.jar".length()));
                if (!directory.isDirectory()) continue;
                ArrayList fileList = new ArrayList();
                ClassloadingContextBuilder.getFileList(directory, fileList);
                if (fileList.isEmpty()) continue;
                entryList.addAll(fileList);
                continue;
            }
            File file = new File(token);
            if (!file.exists()) continue;
            entryList.add(file.toURI().toString());
        }
        Collections.sort(entryList);
        if (log.isDebugEnabled()) {
            for (String s : entryList) {
                log.debug((Object)("Classpath Entry : " + s));
            }
        }
        return entryList.toArray(new String[entryList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static URL getClassloadingConfigFileURL(String webappFilePath) {
        File f = new File(webappFilePath);
        if (f.isDirectory()) {
            File configFile = new File(webappFilePath + File.separator + "META-INF/webapp-classloading.xml");
            if (configFile.exists()) {
                try {
                    return configFile.toURI().toURL();
                }
                catch (MalformedURLException malformedURLException) {}
            }
        } else {
            JarFile webappJarFile = null;
            try {
                webappJarFile = new JarFile(webappFilePath);
                JarEntry contextXmlFileEntry = webappJarFile.getJarEntry("META-INF/webapp-classloading.xml");
                if (contextXmlFileEntry != null) {
                    URL uRL = new URL("jar:file:" + URLEncoder.encode(webappFilePath, "UTF-8").replace("+", "%20") + "!/" + "META-INF/webapp-classloading.xml");
                    return uRL;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (webappJarFile != null) {
                    try {
                        webappJarFile.close();
                    }
                    catch (Throwable t) {
                        ExceptionUtils.handleThrowable((Throwable)t);
                    }
                }
            }
        }
        return null;
    }

    private static String[] addSystemEnvironment(String[] environments) {
        ArrayList<String> envList = new ArrayList<String>(environments.length);
        Collections.addAll(envList, environments);
        boolean found = false;
        for (String env : envList) {
            if (!"Tomcat".equals(env) && !"Carbon".equals(env) && !"Javaee".equals(env)) continue;
            found = true;
            break;
        }
        if (!found) {
            envList.add("Tomcat");
        }
        return envList.toArray(new String[envList.size()]);
    }

    private static void getFileList(File directory, List fileList) {
        if (directory.exists()) {
            for (String fileName : directory.list()) {
                File file = new File(directory, fileName);
                if (!file.exists()) continue;
                if (file.isFile() && fileName.endsWith(".jar")) {
                    fileList.add(file.toURI().toString());
                    continue;
                }
                if (!file.isDirectory()) continue;
                File nastedDir = new File(directory, fileName);
                ClassloadingContextBuilder.getFileList(nastedDir, fileList);
            }
        }
    }
}

