/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.webapp.mgt.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.catalina.Container;
import org.apache.catalina.Host;
import org.apache.catalina.core.StandardWrapper;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.tomcat.api.CarbonTomcatService;
import org.wso2.carbon.webapp.mgt.DataHolder;
import org.wso2.carbon.webapp.mgt.WebApplication;
import org.wso2.carbon.webapp.mgt.WebApplicationsHolder;

public class WebAppUtils {
    public static List<String> vhostNames = WebAppUtils.getVhostNames();
    public static List<String> appBases = WebAppUtils.getAppBases();

    public static String checkJaxApplication(WebApplication webApplication) {
        for (Container container : webApplication.getContext().findChildren()) {
            if (((StandardWrapper)container).getServletClass().equals("org.apache.cxf.transport.servlet.CXFServlet")) {
                return ((StandardWrapper)container).findMappings()[0];
            }
            if (!((StandardWrapper)container).getServletName().toLowerCase().contains("cxf") && !"JAXServlet".equals(((StandardWrapper)container).getServletName())) continue;
            return ((StandardWrapper)container).findMappings()[0];
        }
        return null;
    }

    public static boolean validateWebappFileName(String filename) {
        Pattern pattern = Pattern.compile(".*[\\]\\[!\"$%&'()*+,/:;<=>?@~{|}^`].*");
        Matcher matcher = pattern.matcher(filename);
        boolean isMatch = matcher.matches();
        return isMatch;
    }

    public static String getWebappDirPath(String webappFilePath) {
        return webappFilePath.substring(0, webappFilePath.lastIndexOf(File.separator));
    }

    public static String getMatchingHostName(String filePath) {
        Container[] virtualHosts;
        for (Container vHost : virtualHosts = WebAppUtils.findHostChildren()) {
            Host childHost = (Host)vHost;
            String appBase = childHost.getAppBase().replace("/", File.separator);
            if (appBase.endsWith(File.separator)) {
                if (!WebAppUtils.isEqualTo(filePath + File.separator, appBase)) continue;
                if (childHost.getName().equals(WebAppUtils.getDefaultHost())) {
                    return WebAppUtils.getServerConfigHostName();
                }
                return childHost.getName();
            }
            if (!WebAppUtils.isEqualTo(filePath + File.separator, appBase + File.separator)) continue;
            if (childHost.getName().equals(WebAppUtils.getDefaultHost())) {
                return WebAppUtils.getServerConfigHostName();
            }
            return childHost.getName();
        }
        return WebAppUtils.getServerConfigHostName();
    }

    private static boolean isEqualTo(String webAppFilePath, String baseName) {
        if (webAppFilePath.equals(baseName)) {
            return true;
        }
        String baseDir = baseName.substring(0, baseName.lastIndexOf(File.separator));
        baseDir = baseDir.substring(baseDir.lastIndexOf(File.separator) + 1, baseDir.length());
        return webAppFilePath.contains(File.separator + "repository" + File.separator) && webAppFilePath.contains(File.separator + baseDir + File.separator);
    }

    public static String getWebappKey(File webappFile) {
        String baseDir = WebAppUtils.getWebappDirPath(webappFile.getAbsolutePath());
        String hostName = WebAppUtils.getMatchingHostName(baseDir);
        return hostName + ":" + webappFile.getName();
    }

    private static List<String> getVhostNames() {
        Container[] childHosts;
        ArrayList<String> vHosts = new ArrayList<String>();
        for (Container vHost : childHosts = WebAppUtils.findHostChildren()) {
            Host host = (Host)vHost;
            if (host.getName().equals(WebAppUtils.getDefaultHost())) {
                vHosts.add(WebAppUtils.getServerConfigHostName());
                continue;
            }
            vHosts.add(host.getName());
        }
        return vHosts;
    }

    public static String getAppbase(String hostName) {
        Container[] childHosts;
        if (ServerConfiguration.getInstance().getFirstProperty("HostName") != null && ServerConfiguration.getInstance().getFirstProperty("HostName").equals(hostName)) {
            return WebAppUtils.getAppbase(WebAppUtils.getDefaultHost());
        }
        for (Container host : childHosts = WebAppUtils.findHostChildren()) {
            Host vHost = (Host)host;
            if (!vHost.getName().equals(hostName)) continue;
            return vHost.getAppBase().replace("/", File.separator);
        }
        return "";
    }

    public static Map<String, WebApplicationsHolder> getAllWebappHolders(ConfigurationContext configurationContext) {
        return (Map)configurationContext.getProperty("carbon.webapps.holderlist");
    }

    public static WebApplicationsHolder getWebappHolder(String webappFilePath, ConfigurationContext configurationContext) {
        String baseDir = WebAppUtils.getWebappDir(webappFilePath);
        Map webApplicationsHolderList = (Map)configurationContext.getProperty("carbon.webapps.holderlist");
        if (!appBases.contains(baseDir)) {
            return WebAppUtils.getDefaultWebappHolder(configurationContext);
        }
        return (WebApplicationsHolder)webApplicationsHolderList.get(baseDir);
    }

    public static String getWebappDir(String webappFilePath) {
        String baseDir = WebAppUtils.getWebappDirPath(webappFilePath);
        return baseDir.substring(baseDir.lastIndexOf(File.separator) + 1, baseDir.length());
    }

    public static String getWebappName(String webappFilePath) {
        return webappFilePath.substring(webappFilePath.lastIndexOf(File.separator) + 1, webappFilePath.length());
    }

    public static WebApplicationsHolder getDefaultWebappHolder(ConfigurationContext configurationContext) {
        return (WebApplicationsHolder)((Map)configurationContext.getProperty("carbon.webapps.holderlist")).get("webapps");
    }

    public static String getDefaultHost() {
        CarbonTomcatService carbonTomcatService = DataHolder.getCarbonTomcatService();
        return carbonTomcatService.getTomcat().getEngine().getDefaultHost();
    }

    public static String getServerConfigHostName() {
        String hostName = ServerConfiguration.getInstance().getFirstProperty("HostName");
        if (hostName == null) {
            return WebAppUtils.getDefaultHost();
        }
        return hostName;
    }

    private static Container[] findHostChildren() {
        CarbonTomcatService carbonTomcatService = DataHolder.getCarbonTomcatService();
        return carbonTomcatService.getTomcat().getEngine().findChildren();
    }

    private static List<String> getAppBases() {
        Container[] childHosts;
        ArrayList<String> baseDirs = new ArrayList<String>();
        for (Container host : childHosts = WebAppUtils.findHostChildren()) {
            Host vHost = (Host)host;
            String appBase = vHost.getAppBase().replace("/", File.separator);
            if (appBase.endsWith(File.separator)) {
                appBase = appBase.substring(0, appBase.lastIndexOf(File.separator));
            }
            baseDirs.add(appBase.substring(appBase.lastIndexOf(File.separator) + 1, appBase.length()));
        }
        return baseDirs;
    }
}

