/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.webapp.mgt;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.catalina.Session;
import org.apache.catalina.session.StandardManager;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.utils.CarbonUtils;

public class CarbonTomcatSessionManager
extends StandardManager {
    private static final List<String> allowedClasses = new ArrayList<String>();
    private int ownerTenantId;

    public CarbonTomcatSessionManager(int ownerTenantId) {
        this.ownerTenantId = ownerTenantId;
    }

    public CarbonTomcatSessionManager() {
    }

    public void setOwnerTenantId(int ownerTenantId) {
        CarbonUtils.checkSecurity();
        this.ownerTenantId = ownerTenantId;
    }

    public int getRejectedSessions() {
        this.checkAccess();
        return super.getRejectedSessions();
    }

    public long getExpiredSessions() {
        this.checkAccess();
        return super.getExpiredSessions();
    }

    public int getMaxInactiveInterval() {
        this.checkAccess();
        return super.getMaxInactiveInterval();
    }

    public Session findSession(String id) throws IOException {
        this.checkAccess();
        return super.findSession(id);
    }

    public Session[] findSessions() {
        this.checkAccess();
        return super.findSessions();
    }

    public int getMaxActive() {
        this.checkAccess();
        return super.getMaxActive();
    }

    public int getSessionAverageAliveTime() {
        this.checkAccess();
        return super.getSessionAverageAliveTime();
    }

    public int getSessionMaxAliveTime() {
        this.checkAccess();
        return super.getSessionMaxAliveTime();
    }

    public int getActiveSessions() {
        this.checkAccess();
        return super.getActiveSessions();
    }

    private void checkAccess() {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        String callingClass = trace[3].getClassName();
        if (allowedClasses.contains(callingClass)) {
            return;
        }
        callingClass = trace[4].getClassName();
        if (System.getProperty("java.vm.name").contains("IBM") && allowedClasses.contains(callingClass)) {
            return;
        }
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        if (tenantId != -1234 && tenantId != this.ownerTenantId) {
            throw new SecurityException("Illegal access attempt by  tenant[" + tenantId + "] to sessions owned by tenant[" + this.ownerTenantId + "]");
        }
    }

    static {
        allowedClasses.add("org.apache.catalina.session.ManagerBase");
        allowedClasses.add("org.apache.catalina.connector.Request");
    }
}

