/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.webapp.mgt;

import java.io.File;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonConstants;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.deployment.DeploymentSynchronizer;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.tomcat.ext.utils.URLMappingHolder;
import org.wso2.carbon.tomcat.ext.valves.CarbonTomcatValve;
import org.wso2.carbon.tomcat.ext.valves.CompositeValve;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.deployment.GhostArtifactRepository;
import org.wso2.carbon.utils.deployment.GhostDeployerUtils;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;
import org.wso2.carbon.webapp.mgt.DataHolder;
import org.wso2.carbon.webapp.mgt.TomcatUtil;
import org.wso2.carbon.webapp.mgt.WebApplication;
import org.wso2.carbon.webapp.mgt.WebApplicationsHolder;
import org.wso2.carbon.webapp.mgt.utils.GhostWebappDeployerUtils;
import org.wso2.carbon.webapp.mgt.utils.WebAppUtils;

public class GhostWebappDeployerValve
extends CarbonTomcatValve {
    private static final Log log = LogFactory.getLog(GhostWebappDeployerValve.class);
    private boolean isGhostOn = GhostDeployerUtils.isGhostOn();

    public void invoke(Request request, Response response, CompositeValve compositeValve) {
        if (!this.isGhostOn) {
            this.getNext().invoke(request, response, compositeValve);
            return;
        }
        String requestURI = request.getRequestURI();
        if (requestURI.startsWith(GhostWebappDeployerValve.getWebContextRoot() + "carbon") && !requestURI.contains("/webapp-list/webapp_info.jsp") || requestURI.contains("favicon.ico") || requestURI.contains("/fileupload/") || requestURI.startsWith("/services")) {
            this.getNext().invoke(request, response, compositeValve);
            return;
        }
        String requestedHostName = request.getServerName();
        String uriOfVirtualHost = URLMappingHolder.getInstance().getApplicationFromUrlMapping(requestedHostName);
        if (TomcatUtil.isVirtualHostRequest(requestedHostName).booleanValue() && uriOfVirtualHost == null) {
            uriOfVirtualHost = DataHolder.getHotUpdateService().getApplicationContextForHost(requestedHostName);
        }
        if (uriOfVirtualHost != null) {
            requestURI = uriOfVirtualHost;
        }
        ConfigurationContext currentCtx = requestURI.contains("/t/") ? this.getCurrentConfigurationCtxFromURI(requestURI) : DataHolder.getServerConfigContext();
        WebApplication deployedWebapp = this.getDeployedWebappFromThisURI(request.getContext().getPath(), request.getHost().getName(), currentCtx);
        if (deployedWebapp == null) {
            WebApplication transitWebapp;
            String ctxName = request.getContext().getPath();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Looking for webapp in transit map with CtxName: " + ctxName));
            }
            if ((transitWebapp = GhostWebappDeployerUtils.dispatchWebAppFromTransitGhosts(ctxName, currentCtx)) != null) {
                String isBeingUnloaded;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Webapp found in transit map : " + ctxName));
                }
                if ((isBeingUnloaded = (String)transitWebapp.getProperty("isBeingUnloaded")) != null && "true".equals(isBeingUnloaded)) {
                    GhostWebappDeployerUtils.waitForWebAppToLeaveTransit(transitWebapp.getContextName(), currentCtx);
                    this.handleWebapp(transitWebapp.getWebappFile().getName(), request.getHost().getName(), currentCtx);
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Waiting till webapp leaves transit : " + ctxName));
                    }
                    GhostWebappDeployerUtils.waitForWebAppToLeaveTransit(transitWebapp.getContextName(), currentCtx);
                    try {
                        TomcatUtil.remapRequest((HttpServletRequest)request);
                    }
                    catch (Exception e) {
                        log.error((Object)("Error when redirecting response to " + requestURI), (Throwable)e);
                    }
                }
            }
        } else if (GhostWebappDeployerUtils.isGhostWebApp(deployedWebapp)) {
            this.handleWebapp(deployedWebapp.getWebappFile().getName(), request.getHost().getName(), currentCtx);
            try {
                TomcatUtil.remapRequest((HttpServletRequest)request);
            }
            catch (Exception e) {
                log.error((Object)("Error when redirecting response to " + requestURI), (Throwable)e);
            }
        } else {
            GhostWebappDeployerUtils.updateLastUsedTime(deployedWebapp);
        }
        if (!requestURI.contains("/webapp-list/webapp_info.jsp")) {
            this.getNext().invoke(request, response, compositeValve);
            return;
        }
        String webappFileName = request.getParameter("webappFileName");
        this.handleWebapp(webappFileName, request.getHost().getName(), currentCtx);
        this.getNext().invoke(request, response, compositeValve);
    }

    private WebApplication getDeployedWebappFromThisURI(String requestURI, String hostName, ConfigurationContext cfgCtx) {
        WebApplication deployedWebapp = null;
        List<String> vhostNames = WebAppUtils.vhostNames;
        if (!vhostNames.contains(hostName)) {
            WebApplicationsHolder webappHolder = WebAppUtils.getDefaultWebappHolder(cfgCtx);
            for (WebApplication webApplication : webappHolder.getStartedWebapps().values()) {
                if (!requestURI.equals(webApplication.getContextName())) continue;
                deployedWebapp = webApplication;
                break;
            }
        } else {
            Map<String, WebApplicationsHolder> webApplicationsHolderList = this.getAllWebappHolders(cfgCtx);
            block1: for (WebApplicationsHolder webApplicationsHolder : webApplicationsHolderList.values()) {
                for (WebApplication webApplication : webApplicationsHolder.getStartedWebapps().values()) {
                    if (!requestURI.equals(webApplication.getContextName()) || !hostName.equals(webApplication.getHostName())) continue;
                    deployedWebapp = webApplication;
                    continue block1;
                }
            }
        }
        return deployedWebapp;
    }

    private Map<String, WebApplicationsHolder> getAllWebappHolders(ConfigurationContext cfgCtx) {
        return WebAppUtils.getAllWebappHolders(cfgCtx);
    }

    private void handleWebapp(String webappFileName, String hostName, ConfigurationContext cfgCtx) {
        if (webappFileName != null) {
            WebApplication ghostWebapp = null;
            List<String> vhostNames = WebAppUtils.vhostNames;
            if (!vhostNames.contains(hostName)) {
                WebApplicationsHolder webappHolder = WebAppUtils.getDefaultWebappHolder(cfgCtx);
                ghostWebapp = webappHolder.getStartedWebapps().get(webappFileName);
            } else {
                Map<String, WebApplicationsHolder> webApplicationsHolderList = this.getAllWebappHolders(cfgCtx);
                for (WebApplicationsHolder webApplicationsHolder : webApplicationsHolderList.values()) {
                    WebApplication currentWebapp = webApplicationsHolder.getStartedWebapps().get(webappFileName);
                    if (currentWebapp == null || !currentWebapp.getHostName().equals(hostName)) continue;
                    ghostWebapp = currentWebapp;
                    break;
                }
            }
            if (ghostWebapp != null) {
                PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
                String applicationName = carbonContext.getApplicationName();
                GhostWebappDeployerUtils.deployActualWebApp(ghostWebapp, cfgCtx);
                carbonContext.setApplicationName(applicationName);
            }
        }
    }

    private ConfigurationContext getCurrentConfigurationCtxFromURI(String uri) {
        return TenantAxisUtils.getTenantConfigurationContextFromUrl((String)uri, (ConfigurationContext)DataHolder.getServerConfigContext());
    }

    @Deprecated
    private synchronized void handleDepSynchUpdate(ConfigurationContext configurationContext, WebApplication webApplication, WebApplicationsHolder webappsHolder) {
        DeploymentSynchronizer depsync;
        String filePath;
        File fileToUpdate;
        String fileName;
        String repoPath;
        String webappType = (String)webApplication.getProperty("webappFilter");
        String deploymentDir = "webapps";
        if (webappType.equals("jaggeryWebapp")) {
            deploymentDir = "jaggeryapps";
        }
        if ((repoPath = configurationContext.getAxisConfiguration().getRepository().getPath()).contains(CarbonConstants.TENANTS_REPO) && GhostWebappDeployerUtils.isGhostWebApp(webApplication) && (fileName = (String)webApplication.getProperty("AppFileName")) != null && !(fileToUpdate = new File(filePath = repoPath + File.separator + deploymentDir + File.separator + fileName)).exists() && (depsync = DataHolder.getDeploymentSynchronizerService()) != null && CarbonUtils.isDepSyncEnabled()) {
            try {
                depsync.update(repoPath, filePath, 3);
                if (fileToUpdate.exists()) {
                    DeploymentFileData dfd = new DeploymentFileData(fileToUpdate);
                    GhostArtifactRepository ghostArtifactRepository = GhostDeployerUtils.getGhostArtifactRepository((AxisConfiguration)configurationContext.getAxisConfiguration());
                    if (ghostArtifactRepository != null && ghostArtifactRepository.getDeploymentFileData(filePath) == null) {
                        File deployedWebappFile = new File(webApplication.getWebappFile().getName());
                        if (webappsHolder.getStartedWebapps().containsKey(deployedWebappFile.getName())) {
                            webappsHolder.getStartedWebapps().remove(deployedWebappFile.getName());
                        }
                        webApplication.setWebappFile(dfd.getFile());
                        webappsHolder.getStartedWebapps().put(dfd.getFile().getName(), webApplication);
                    }
                }
            }
            catch (Throwable t) {
                log.error((Object)"Deployment synchronization update failed", t);
            }
        }
    }

    private String getCtxNameFromRequestURI(String requestURI) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Request URI to retrieve CtxName : " + requestURI));
        }
        String ctxName = requestURI;
        if (requestURI.startsWith("/t/")) {
            String tenantDomain = MultitenantUtils.getTenantDomainFromUrl((String)requestURI);
            if (requestURI.contains("webapps") || requestURI.contains("jaxwebapps") || requestURI.contains("jaggeryapps")) {
                String subCtxName = ctxName.substring(ctxName.indexOf(tenantDomain) + tenantDomain.length() + 1);
                if (subCtxName.contains("/")) {
                    subCtxName = subCtxName.substring(subCtxName.indexOf(47) + 1);
                }
                if (subCtxName.contains("/")) {
                    subCtxName = subCtxName.substring(subCtxName.indexOf(47));
                    ctxName = requestURI.substring(0, requestURI.lastIndexOf(subCtxName));
                } else {
                    ctxName = requestURI;
                }
            }
        } else {
            ctxName = requestURI.substring(1);
            ctxName = ctxName.contains("/") ? "/".concat(ctxName.substring(0, ctxName.indexOf(47))) : "/".concat(ctxName);
        }
        return ctxName;
    }

    private static String getWebContextRoot() {
        String context = CarbonUtils.getServerConfiguration().getFirstProperty("WebContextRoot");
        if (!context.endsWith("/")) {
            return context + "/";
        }
        return context;
    }
}

