/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.webapp.mgt;

import java.io.File;
import java.lang.management.ManagementPermission;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.util.JavaUtils;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.Manager;
import org.apache.catalina.core.StandardContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.persistence.metadata.ArtifactMetadataException;
import org.wso2.carbon.core.persistence.metadata.ArtifactMetadataManager;
import org.wso2.carbon.core.persistence.metadata.ArtifactType;
import org.wso2.carbon.core.persistence.metadata.DeploymentArtifactMetadataFactory;
import org.wso2.carbon.tomcat.api.CarbonTomcatService;
import org.wso2.carbon.tomcat.ext.utils.URLMappingHolder;
import org.wso2.carbon.webapp.mgt.CarbonTomcatSessionManager;
import org.wso2.carbon.webapp.mgt.CarbonTomcatSessionPersistentManager;
import org.wso2.carbon.webapp.mgt.DataHolder;
import org.wso2.carbon.webapp.mgt.TomcatUtil;
import org.wso2.carbon.webapp.mgt.WebApplication;
import org.wso2.carbon.webapp.mgt.WebApplicationsHolder;
import org.wso2.carbon.webapp.mgt.WebContextParameter;
import org.wso2.carbon.webapp.mgt.session.CarbonTomcatClusterableSessionManager;
import org.wso2.carbon.webapp.mgt.utils.WebAppUtils;

public class TomcatGenericWebappsDeployer {
    private static Log log = LogFactory.getLog(TomcatGenericWebappsDeployer.class);
    protected String webContextPrefix;
    protected int tenantId;
    protected String tenantDomain;
    protected ConfigurationContext configurationContext;
    protected Map<String, WebApplicationsHolder> webApplicationsHolderMap;
    protected Map<String, Manager> sessionManagerMap = new ConcurrentHashMap<String, Manager>();

    public TomcatGenericWebappsDeployer(String webContextPrefix, int tenantId, String tenantDomain, Map<String, WebApplicationsHolder> webApplicationsHolderMap, ConfigurationContext configurationContext) {
        SecurityManager secMan = System.getSecurityManager();
        if (secMan != null) {
            secMan.checkPermission(new ManagementPermission("control"));
        }
        this.tenantId = tenantId;
        this.tenantDomain = tenantDomain;
        this.webContextPrefix = webContextPrefix;
        this.webApplicationsHolderMap = webApplicationsHolderMap;
        this.configurationContext = configurationContext;
    }

    public void deploy(File webappFile, List<WebContextParameter> webContextParams, List<Object> applicationEventListeners) throws CarbonException {
        String webappName = webappFile.getName();
        if (webappName.startsWith("#") || webappName.endsWith("#.war") || webappName.endsWith("#")) {
            throw new CarbonException("Invalid filename. Webapp name can't start or ends with '#'");
        }
        PrivilegedCarbonContext privilegedCarbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        if (webappFile.isDirectory()) {
            privilegedCarbonContext.setApplicationName(webappName);
        } else if (webappName.contains(".war") || webappName.contains(".zip")) {
            privilegedCarbonContext.setApplicationName(webappName.substring(0, webappName.indexOf(".war")));
        }
        long lastModifiedTime = webappFile.lastModified();
        WebApplicationsHolder webApplicationsHolder = WebAppUtils.getWebappHolder(webappFile.getAbsolutePath(), this.configurationContext);
        WebApplication deployedWebapp = webApplicationsHolder.getStartedWebapps().get(webappFile.getName());
        WebApplication deployedUnpackedWebapp = null;
        if (deployedWebapp == null && (webappName.contains(".war") || webappName.contains(".zip"))) {
            String unpackDirName = webappName.endsWith(".war") ? webappName.replace(".war", "") : webappName;
            unpackDirName = webappName.endsWith(".zip") ? unpackDirName.replace(".zip", "") : unpackDirName;
            deployedUnpackedWebapp = webApplicationsHolder.getStartedWebapps().get(unpackDirName);
        }
        WebApplication undeployedWebapp = webApplicationsHolder.getStoppedWebapps().get(webappFile.getName());
        WebApplication faultyWebapp = webApplicationsHolder.getFaultyWebapps().get(webappFile.getName());
        WebApplication faultyUnpackedWebapp = null;
        if (deployedWebapp == null && (webappName.contains(".war") || webappName.contains(".zip"))) {
            String unpackDirName = webappName.endsWith(".war") ? webappName.replace(".war", "") : webappName;
            unpackDirName = webappName.endsWith(".zip") ? unpackDirName.replace(".zip", "") : unpackDirName;
            faultyUnpackedWebapp = webApplicationsHolder.getFaultyWebapps().get(unpackDirName);
        }
        if (deployedWebapp == null && faultyWebapp == null && undeployedWebapp == null && deployedUnpackedWebapp == null && faultyUnpackedWebapp == null) {
            this.handleHotDeployment(webappFile, webContextParams, applicationEventListeners);
        } else if (deployedWebapp != null && deployedWebapp.getLastModifiedTime() != lastModifiedTime) {
            this.handleHotUpdate(deployedWebapp, webContextParams, applicationEventListeners);
        } else if (faultyWebapp != null && faultyWebapp.getLastModifiedTime() != lastModifiedTime) {
            this.handleHotDeployment(webappFile, webContextParams, applicationEventListeners);
        } else if (deployedUnpackedWebapp != null && deployedUnpackedWebapp.getLastModifiedTime() != lastModifiedTime) {
            this.undeploy(deployedUnpackedWebapp.getWebappFile());
            deployedUnpackedWebapp.delete();
            this.handleWarWebappDeployment(webappFile, webContextParams, applicationEventListeners);
        } else if (faultyUnpackedWebapp != null && faultyUnpackedWebapp.getLastModifiedTime() != lastModifiedTime) {
            this.clearFaultyWebapp(faultyUnpackedWebapp.getWebappFile().getAbsolutePath());
            this.handleWarWebappDeployment(webappFile, webContextParams, applicationEventListeners);
        }
    }

    protected void handleHotDeployment(File webapp, List<WebContextParameter> webContextParams, List<Object> applicationEventListeners) throws CarbonException {
        String filename = webapp.getName();
        if (webapp.isDirectory()) {
            this.handleExplodedWebappDeployment(webapp, webContextParams, applicationEventListeners);
        } else if (filename.endsWith(".war")) {
            this.handleWarWebappDeployment(webapp, webContextParams, applicationEventListeners);
        } else if (filename.endsWith(".zip")) {
            this.handleZipWebappDeployment(webapp, webContextParams, applicationEventListeners);
        }
    }

    protected void handleWarWebappDeployment(File webappWAR, List<WebContextParameter> webContextParams, List<Object> applicationEventListeners) throws CarbonException {
        String filename = webappWAR.getName();
        String warContext = "";
        if (!filename.equals("ROOT.war")) {
            warContext = filename.substring(0, filename.indexOf(".war"));
        }
        if (!warContext.equals("") && this.webContextPrefix.length() == 0) {
            this.webContextPrefix = "/";
        } else if (warContext.equals("")) {
            this.webContextPrefix = "";
        }
        String contextPath = this.handleAppVersion(this.webContextPrefix + warContext);
        this.handleWebappDeployment(webappWAR, contextPath, webContextParams, applicationEventListeners);
    }

    protected void handleZipWebappDeployment(File webapp, List<WebContextParameter> webContextParams, List<Object> applicationEventListeners) throws CarbonException {
    }

    protected void handleExplodedWebappDeployment(File webappDir, List<WebContextParameter> webContextParams, List<Object> applicationEventListeners) throws CarbonException {
        String filename = webappDir.getName();
        String warContext = "";
        if (!filename.equals("ROOT")) {
            warContext = filename;
        }
        if (!warContext.equals("") && this.webContextPrefix.length() == 0) {
            this.webContextPrefix = "/";
        } else if (warContext.equals("")) {
            this.webContextPrefix = "";
        }
        String contextPath = this.handleAppVersion(this.webContextPrefix + warContext);
        this.handleWebappDeployment(webappDir, contextPath, webContextParams, applicationEventListeners);
    }

    protected void handleWebappDeployment(File webappFile, String contextStr, List<WebContextParameter> webContextParams, List<Object> applicationEventListeners) throws CarbonException {
        PrivilegedCarbonContext privilegedCarbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        String filename = webappFile.getName();
        try {
            Context context = DataHolder.getCarbonTomcatService().addWebApp(WebAppUtils.getHost(webappFile.getAbsolutePath()), contextStr, webappFile.getAbsolutePath());
            if (DataHolder.getHotUpdateService() != null) {
                List hostNames = DataHolder.getHotUpdateService().getMappigsPerWebapp(contextStr);
                for (String hostName : hostNames) {
                    CarbonTomcatService carbonTomcatService = DataHolder.getCarbonTomcatService();
                    Host host = DataHolder.getHotUpdateService().addHost(hostName);
                    URLMappingHolder.getInstance().putUrlMappingForApplication(hostName, contextStr);
                    Context contextForHost = DataHolder.getCarbonTomcatService().addWebApp(host, "/", webappFile.getAbsolutePath());
                    log.info((Object)("Deployed webapp on host: " + contextForHost));
                }
            }
            Manager manager = context.getManager();
            if (context.getDistributable() && DataHolder.getCarbonTomcatService().getTomcat().getService().getContainer().getCluster() != null) {
                Object sessionManager;
                if (manager instanceof CarbonTomcatClusterableSessionManager) {
                    sessionManager = manager;
                    ((CarbonTomcatClusterableSessionManager)manager).setOwnerTenantId(this.tenantId);
                } else if (manager instanceof org.wso2.carbon.core.session.CarbonTomcatClusterableSessionManager) {
                    sessionManager = manager;
                    ((org.wso2.carbon.core.session.CarbonTomcatClusterableSessionManager)manager).setOwnerTenantId(this.tenantId);
                } else {
                    sessionManager = new CarbonTomcatClusterableSessionManager(this.tenantId);
                    context.setManager(sessionManager);
                }
                Object alreadyinsertedSMMap = this.configurationContext.getProperty("CarbonTomcatSessionManagerMap");
                if (alreadyinsertedSMMap != null) {
                    ((Map)alreadyinsertedSMMap).put(context.getName(), sessionManager);
                } else {
                    this.sessionManagerMap.put(context.getName(), (Manager)sessionManager);
                    this.configurationContext.setProperty("CarbonTomcatSessionManagerMap", this.sessionManagerMap);
                }
            } else if (manager instanceof CarbonTomcatSessionManager) {
                ((CarbonTomcatSessionManager)manager).setOwnerTenantId(this.tenantId);
            } else if (manager instanceof CarbonTomcatSessionPersistentManager) {
                ((CarbonTomcatSessionPersistentManager)manager).setOwnerTenantId(this.tenantId);
                log.debug((Object)(manager.getInfo() + " enabled Tomcat HTTP Session Persistent mode using " + ((CarbonTomcatSessionPersistentManager)manager).getStore().getInfo()));
            } else {
                context.setManager((Manager)new CarbonTomcatSessionManager(this.tenantId));
            }
            WebApplication webapp = new WebApplication(this, context, webappFile);
            webapp.setServletContextParameters(webContextParams);
            String bamEnable = this.recievePersistedWebappMetaData(webappFile, "enable.statistics");
            if ((bamEnable == null || "".equals(bamEnable)) && ((bamEnable = context.findParameter("enable.statistics")) == null || "".equals(bamEnable))) {
                bamEnable = "false";
            }
            webapp.addParameter("enable.statistics", bamEnable);
            webapp.setState("Started");
            WebApplicationsHolder webApplicationsHolder = WebAppUtils.getWebappHolder(webapp.getWebappFile().getAbsolutePath(), this.configurationContext);
            webApplicationsHolder.getStartedWebapps().put(filename, webapp);
            webApplicationsHolder.getFaultyWebapps().remove(filename);
            this.registerApplicationEventListeners(applicationEventListeners, context);
            log.info((Object)("Deployed webapp: " + webapp));
        }
        catch (Throwable e) {
            StandardContext context = new StandardContext();
            context.setName(webappFile.getName());
            context.addParameter("faulty.webapp", "true");
            WebApplication webapp = new WebApplication(this, (Context)context, webappFile);
            String msg = "Error while deploying webapp: " + webapp;
            log.error((Object)msg, e);
            webapp.setFaultReason(new Exception(msg, e));
            WebApplicationsHolder webApplicationsHolder = WebAppUtils.getWebappHolder(webapp.getWebappFile().getAbsolutePath(), this.configurationContext);
            webApplicationsHolder.getFaultyWebapps().put(filename, webapp);
            webApplicationsHolder.getStartedWebapps().remove(filename);
            throw new CarbonException(msg, e);
        }
        finally {
            privilegedCarbonContext.setApplicationName(null);
        }
    }

    private void registerApplicationEventListeners(List<Object> applicationEventListeners, Context context) {
        Object[] originalEventListeners = context.getApplicationEventListeners();
        Object[] newEventListeners = new Object[originalEventListeners.length + applicationEventListeners.size()];
        if (originalEventListeners.length != 0) {
            System.arraycopy(originalEventListeners, 0, newEventListeners, 0, originalEventListeners.length);
            int i = originalEventListeners.length;
            for (Object eventListener : applicationEventListeners) {
                newEventListeners[i++] = eventListener;
            }
        } else {
            newEventListeners = applicationEventListeners.toArray(new Object[applicationEventListeners.size()]);
        }
        context.setApplicationEventListeners(newEventListeners);
    }

    protected void handleHotUpdate(WebApplication webApplication, List<WebContextParameter> webContextParams, List<Object> applicationEventListeners) throws CarbonException {
        File webappFile = webApplication.getWebappFile();
        if (webappFile.isDirectory()) {
            webApplication.reload();
            webApplication.setServletContextParameters(webContextParams);
            webApplication.setLastModifiedTime(webappFile.lastModified());
        } else {
            this.undeploy(webApplication);
            this.handleWarWebappDeployment(webappFile, webContextParams, applicationEventListeners);
        }
        log.info((Object)("Redeployed webapp: " + webApplication));
    }

    public void undeploy(File webappFile) throws CarbonException {
        WebApplicationsHolder webApplicationsHolder = WebAppUtils.getWebappHolder(webappFile.getAbsolutePath(), this.configurationContext);
        Map<String, WebApplication> deployedWebapps = webApplicationsHolder.getStartedWebapps();
        Map<String, WebApplication> stoppedWebapps = webApplicationsHolder.getStoppedWebapps();
        Map<String, WebApplication> faultyWebapps = webApplicationsHolder.getFaultyWebapps();
        String fileName = webappFile.getName();
        this.removeMetadata(webappFile.getAbsolutePath());
        if (deployedWebapps.containsKey(fileName)) {
            this.undeploy(deployedWebapps.get(fileName));
        }
        if (!fileName.endsWith(".war")) {
            String warFileName = fileName.concat(".war");
            if (deployedWebapps.containsKey(warFileName)) {
                this.undeploy(deployedWebapps.get(warFileName));
            }
        } else if (stoppedWebapps.containsKey(fileName)) {
            this.undeploy(stoppedWebapps.get(fileName));
        } else if (faultyWebapps.containsKey(fileName)) {
            this.undeploy(faultyWebapps.get(fileName));
        }
        this.clearFaultyWebapp(webappFile.getAbsolutePath());
    }

    public void lazyUnload(File webappFile) throws CarbonException {
        WebApplicationsHolder webApplicationsHolder = WebAppUtils.getWebappHolder(webappFile.getAbsolutePath(), this.configurationContext);
        PrivilegedCarbonContext privilegedCarbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        Map<String, WebApplication> deployedWebapps = webApplicationsHolder.getStartedWebapps();
        Map<String, WebApplication> stoppedWebapps = webApplicationsHolder.getStoppedWebapps();
        String fileName = webappFile.getName();
        if (deployedWebapps.containsKey(fileName)) {
            WebApplication deployWebapp = deployedWebapps.get(fileName);
            Context context = deployWebapp.getContext();
            privilegedCarbonContext.setApplicationName(TomcatUtil.getApplicationNameFromContext(context.getBaseName()));
            deployWebapp.lazyUnload();
        } else if (stoppedWebapps.containsKey(fileName)) {
            WebApplication stoppedWebapp = stoppedWebapps.get(fileName);
            Context context = stoppedWebapp.getContext();
            privilegedCarbonContext.setApplicationName(TomcatUtil.getApplicationNameFromContext(context.getBaseName()));
            stoppedWebapp.lazyUnload();
        }
        this.clearFaultyWebapp(webappFile.getAbsolutePath());
    }

    private void clearFaultyWebapp(String filePath) {
        String fileName;
        WebApplicationsHolder webApplicationsHolder = WebAppUtils.getWebappHolder(filePath, this.configurationContext);
        PrivilegedCarbonContext privilegedCarbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        Map<String, WebApplication> faultyWebapps = webApplicationsHolder.getFaultyWebapps();
        if (faultyWebapps.containsKey(fileName = WebAppUtils.getWebappName(filePath))) {
            WebApplication faultyWebapp = faultyWebapps.get(fileName);
            Context context = faultyWebapp.getContext();
            privilegedCarbonContext.setApplicationName(TomcatUtil.getApplicationNameFromContext(context.getBaseName()));
            faultyWebapps.remove(fileName);
            log.info((Object)("Removed faulty webapp " + faultyWebapp));
        }
    }

    protected String recievePersistedWebappMetaData(File webappFile, String propertyName) throws AxisFault, ArtifactMetadataException {
        AxisConfiguration axisConfig = this.configurationContext.getAxisConfiguration();
        String artifactDir = WebAppUtils.generateMetaFileDirName(webappFile.getAbsolutePath(), this.configurationContext);
        ArtifactType type = new ArtifactType("webapp", "artifactMetafiles" + File.separator + artifactDir);
        ArtifactMetadataManager manager = DeploymentArtifactMetadataFactory.getInstance((AxisConfiguration)axisConfig).getMetadataManager();
        return manager.loadParameter(webappFile.getName(), type, propertyName);
    }

    protected void setPersistedWebappMetaData(File webappFile, String propertyName, String value) throws AxisFault, ArtifactMetadataException {
        AxisConfiguration axisConfig = this.configurationContext.getAxisConfiguration();
        String artifactDir = WebAppUtils.generateMetaFileDirName(webappFile.getAbsolutePath(), this.configurationContext);
        ArtifactType type = new ArtifactType("webapp", "artifactMetafiles" + File.separator + artifactDir);
        ArtifactMetadataManager manager = DeploymentArtifactMetadataFactory.getInstance((AxisConfiguration)axisConfig).getMetadataManager();
        manager.setParameter(webappFile.getName(), type, propertyName, value, true);
    }

    private void removeMetadata(String artifactFilePath) throws CarbonException {
        try {
            WebApplicationsHolder webApplicationsHolder = WebAppUtils.getWebappHolder(artifactFilePath, this.configurationContext);
            Map<String, WebApplication> deployedWebapps = webApplicationsHolder.getStartedWebapps();
            Map<String, WebApplication> stoppedWebapps = webApplicationsHolder.getStoppedWebapps();
            String keepMetadataHistory = null;
            String artifactFileName = WebAppUtils.getWebappName(artifactFilePath);
            if (deployedWebapps.containsKey(artifactFileName)) {
                keepMetadataHistory = deployedWebapps.get(artifactFileName).findParameter("keepWebappMetadataHistory");
            }
            if (keepMetadataHistory == null && stoppedWebapps.containsKey(artifactFileName)) {
                keepMetadataHistory = stoppedWebapps.get(artifactFileName).findParameter("keepWebappMetadataHistory");
            }
            if (!JavaUtils.isFalse(keepMetadataHistory)) {
                return;
            }
            AxisConfiguration axisConfig = this.configurationContext.getAxisConfiguration();
            String artifactDir = WebAppUtils.generateMetaFileDirName(artifactFilePath, this.configurationContext);
            ArtifactType type = new ArtifactType("webapp", "artifactMetafiles" + File.separator + artifactDir);
            ArtifactMetadataManager manager = DeploymentArtifactMetadataFactory.getInstance((AxisConfiguration)axisConfig).getMetadataManager();
            manager.deleteMetafile(artifactFileName, type);
        }
        catch (AxisFault e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new CarbonException((Throwable)e);
        }
    }

    private void undeploy(WebApplication webapp) throws CarbonException {
        WebApplicationsHolder webApplicationsHolder = WebAppUtils.getWebappHolder(webapp.getWebappFile().getAbsolutePath(), this.configurationContext);
        PrivilegedCarbonContext privilegedCarbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        Context context = webapp.getContext();
        privilegedCarbonContext.setApplicationName(TomcatUtil.getApplicationNameFromContext(context.getBaseName()));
        webApplicationsHolder.undeployWebapp(webapp);
        log.info((Object)("Undeployed webapp: " + webapp));
    }

    protected String handleAppVersion(String warContext) {
        String path = warContext;
        int versionIndex = path.indexOf("##");
        String version = null;
        if (versionIndex > -1) {
            version = path.substring(versionIndex + 2);
            path = path.substring(0, versionIndex);
        }
        if (path.contains("#")) {
            path = path.replaceAll("#", "/");
        }
        if (version != null) {
            return path + "##" + version;
        }
        return path;
    }

    private boolean isUnpackedDirExists(String warPath) {
        File dir = new File(warPath.replace(".war", ""));
        return dir.exists() && dir.isDirectory();
    }
}

