/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.webapp.mgt.session;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.axis2.clustering.ClusteringAgent;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.ClusteringMessage;
import org.apache.catalina.Session;
import org.apache.catalina.ha.ClusterManager;
import org.apache.catalina.ha.ClusterMessage;
import org.apache.catalina.ha.session.ClusterManagerBase;
import org.apache.catalina.ha.session.DeltaManager;
import org.apache.catalina.ha.session.DeltaSession;
import org.apache.catalina.ha.session.SessionMessage;
import org.apache.catalina.tribes.Member;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.webapp.mgt.DataHolder;
import org.wso2.carbon.webapp.mgt.session.CarbonSessionReplicationMessage;
import org.wso2.carbon.webapp.mgt.session.CarbonTomcatSessionMessage;

public class CarbonTomcatClusterableSessionManager
extends DeltaManager {
    private static final List<String> allowedClasses = new ArrayList<String>();
    private static final Log log = LogFactory.getLog(CarbonTomcatClusterableSessionManager.class);
    private Map<String, CarbonTomcatSessionMessage> messageMap = new HashMap<String, CarbonTomcatSessionMessage>();
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.ha.session");
    private boolean expireSessionsOnShutdown = false;
    private boolean notifySessionListenersOnReplication = true;
    private boolean notifyContainerListenersOnReplication = true;
    private volatile boolean stateTransfered = false;
    private int stateTransferTimeout = 60;
    private boolean sendAllSessions = true;
    private int sendAllSessionsSize = 1000;
    private int sendAllSessionsWaitTime = 2000;
    private ArrayList<CarbonTomcatSessionMessage> receivedMessageQueue = new ArrayList();
    private boolean receiverQueue = false;
    private boolean stateTimestampDrop = true;
    private long stateTransferCreateSendTime;
    private int ownerTenantId;

    public CarbonTomcatClusterableSessionManager() {
    }

    public CarbonTomcatClusterableSessionManager(int ownerTenantId) {
        this.ownerTenantId = ownerTenantId;
    }

    public void setOwnerTenantId(int ownerTenantId) {
        this.ownerTenantId = ownerTenantId;
    }

    public int getRejectedSessions() {
        return super.getRejectedSessions();
    }

    public long getExpiredSessions() {
        return super.getExpiredSessions();
    }

    public int getMaxInactiveInterval() {
        return super.getMaxInactiveInterval();
    }

    public Session findSession(String id) throws IOException {
        return super.findSession(id);
    }

    public Session[] findSessions() {
        return super.findSessions();
    }

    public int getMaxActive() {
        return super.getMaxActive();
    }

    public int getSessionAverageAliveTime() {
        return super.getSessionAverageAliveTime();
    }

    public int getSessionMaxAliveTime() {
        return super.getSessionMaxAliveTime();
    }

    public int getActiveSessions() {
        return super.getActiveSessions();
    }

    public CarbonSessionReplicationMessage getSessionReplicationMessage(String sessionId, boolean expires) {
        CarbonSessionReplicationMessage message = new CarbonSessionReplicationMessage();
        message.setSessionClusterMessage(super.requestCompleted(sessionId, expires));
        message.setTenantId(this.ownerTenantId);
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replicateSessions(Session session) {
        block4: {
            PrivilegedCarbonContext currentContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            currentContext.startTenantFlow();
            ClusteringAgent clusteringAgent = DataHolder.getServerConfigContext().getAxisConfiguration().getClusteringAgent();
            try {
                if (session == null || clusteringAgent == null) break block4;
                try {
                    clusteringAgent.sendMessage((ClusteringMessage)this.getSessionReplicationMessage(session.getIdInternal(), false), true);
                }
                catch (ClusteringFault clusteringFault) {
                    log.error((Object)"Error while replicating webapp session", (Throwable)clusteringFault);
                }
            }
            catch (Throwable throwable) {
                currentContext.endTenantFlow();
                throw throwable;
            }
        }
        currentContext.endTenantFlow();
    }

    public void clusterMessageReceived(ClusterMessage msg) {
        if (log.isDebugEnabled()) {
            log.debug((Object)((SessionMessage)msg).getEventTypeString());
        }
        super.messageDataReceived(msg);
    }

    protected void sessionExpired(String id) {
        CarbonTomcatSessionMessage msg = new CarbonTomcatSessionMessage(this.getName(), 2, null, id, id + "-EXPIRED-MSG", this.ownerTenantId);
        msg.setTimestamp(System.currentTimeMillis());
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("deltaManager.createMessage.expire", new Object[]{this.getName(), id}));
        }
        try {
            ClusteringAgent clusteringAgent = DataHolder.getServerConfigContext().getAxisConfiguration().getClusteringAgent();
            if (clusteringAgent != null) {
                clusteringAgent.sendMessage((ClusteringMessage)msg, true);
            }
        }
        catch (ClusteringFault clusteringFault) {
            log.error((Object)"Clustering Fault :", (Throwable)clusteringFault);
        }
    }

    protected void handleGET_ALL_SESSIONS(SessionMessage msg, Member sender) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("deltaManager.receiveMessage.unloadingBegin", new Object[]{this.getName()}));
        }
        Session[] currentSessions = this.findSessions();
        long findSessionTimestamp = System.currentTimeMillis();
        if (this.isSendAllSessions()) {
            this.sendSessions(sender, currentSessions, findSessionTimestamp);
        } else {
            for (int i = 0; i < currentSessions.length; i += this.getSendAllSessionsSize()) {
                int len = i + this.getSendAllSessionsSize() > currentSessions.length ? currentSessions.length - i : this.getSendAllSessionsSize();
                Session[] sendSessions = new Session[len];
                System.arraycopy(currentSessions, i, sendSessions, 0, len);
                this.sendSessions(sender, sendSessions, findSessionTimestamp);
                if (this.getSendAllSessionsWaitTime() <= 0) continue;
                try {
                    Thread.sleep(this.getSendAllSessionsWaitTime());
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        CarbonTomcatSessionMessage newmsg = new CarbonTomcatSessionMessage(this.name, 14, null, "SESSION-STATE-TRANSFERED", "SESSION-STATE-TRANSFERED" + this.getName(), this.ownerTenantId);
        newmsg.setTimestamp(findSessionTimestamp);
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("deltaManager.createMessage.allSessionTransfered", new Object[]{this.getName()}));
        }
        try {
            ClusteringAgent clusteringAgent = DataHolder.getServerConfigContext().getAxisConfiguration().getClusteringAgent();
            if (clusteringAgent != null) {
                clusteringAgent.sendMessage((ClusteringMessage)newmsg, true);
            }
        }
        catch (ClusteringFault clusteringFault) {
            log.error((Object)"Clustering Fault :", (Throwable)clusteringFault);
        }
    }

    protected void sendSessions(Member sender, Session[] currentSessions, long sendTimestamp) throws IOException {
        byte[] data = this.serializeSessions(currentSessions);
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("deltaManager.receiveMessage.unloadingAfter", new Object[]{this.getName()}));
        }
        CarbonTomcatSessionMessage newmsg = new CarbonTomcatSessionMessage(this.name, 12, data, "SESSION-STATE", "SESSION-STATE-" + this.getName(), this.ownerTenantId);
        newmsg.setTimestamp(sendTimestamp);
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("deltaManager.createMessage.allSessionData", new Object[]{this.getName()}));
        }
        try {
            ClusteringAgent clusteringAgent = DataHolder.getServerConfigContext().getAxisConfiguration().getClusteringAgent();
            if (clusteringAgent != null) {
                clusteringAgent.sendMessage((ClusteringMessage)newmsg, true);
            }
        }
        catch (ClusteringFault clusteringFault) {
            log.error((Object)"Clustering Fault :", (Throwable)clusteringFault);
        }
    }

    protected void sendCreateSession(String sessionId, DeltaSession session) {
        CarbonTomcatSessionMessage msg = new CarbonTomcatSessionMessage(this.getName(), 1, null, sessionId, sessionId + "-" + System.currentTimeMillis(), this.ownerTenantId);
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("deltaManager.sendMessage.newSession", new Object[]{this.name, sessionId}));
        }
        msg.setTimestamp(session.getCreationTime());
        try {
            ClusteringAgent clusteringAgent = DataHolder.getServerConfigContext().getAxisConfiguration().getClusteringAgent();
            if (clusteringAgent != null) {
                clusteringAgent.sendMessage((ClusteringMessage)msg, true);
            }
        }
        catch (ClusteringFault clusteringFault) {
            log.error((Object)"Clustering Fault :", (Throwable)clusteringFault);
        }
    }

    public void changeSessionId(Session session, boolean notify) {
        String orgSessionID = session.getId();
        super.changeSessionId(session);
        if (notify) {
            String newSessionID = session.getId();
            try {
                byte[] data = this.serializeSessionId(newSessionID);
                CarbonTomcatSessionMessage msg = new CarbonTomcatSessionMessage(this.getName(), 15, data, orgSessionID, orgSessionID + "-" + System.currentTimeMillis(), this.ownerTenantId);
                msg.setTimestamp(System.currentTimeMillis());
                ClusteringAgent clusteringAgent = DataHolder.getServerConfigContext().getAxisConfiguration().getClusteringAgent();
                if (clusteringAgent != null) {
                    clusteringAgent.sendMessage((ClusteringMessage)msg, true);
                }
            }
            catch (IOException e) {
                log.error((Object)sm.getString("deltaManager.unableSerializeSessionID", new Object[]{newSessionID}), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void getAllClusterSessions() {
        CarbonTomcatSessionMessage msg = new CarbonTomcatSessionMessage(this.getName(), 4, null, "GET-ALL", "GET-ALL-" + this.getName(), this.ownerTenantId);
        ArrayList<CarbonTomcatSessionMessage> arrayList = this.receivedMessageQueue;
        synchronized (arrayList) {
            this.receiverQueue = true;
        }
        ClusteringAgent clusteringAgent = DataHolder.getServerConfigContext().getAxisConfiguration().getClusteringAgent();
        if (clusteringAgent != null) {
            try {
                clusteringAgent.sendMessage((ClusteringMessage)msg, true);
            }
            catch (ClusteringFault clusteringFault) {
                log.error((Object)("Error while sending message : " + (Object)((Object)msg) + " to clustering agent : " + clusteringAgent.toString()), (Throwable)clusteringFault);
            }
        }
    }

    public ClusterManager cloneFromTemplate() {
        CarbonTomcatClusterableSessionManager result = new CarbonTomcatClusterableSessionManager();
        this.clone((ClusterManagerBase)result);
        result.expireSessionsOnShutdown = this.expireSessionsOnShutdown;
        result.notifySessionListenersOnReplication = this.notifySessionListenersOnReplication;
        result.notifyContainerListenersOnReplication = this.notifyContainerListenersOnReplication;
        result.stateTransferTimeout = this.stateTransferTimeout;
        result.sendAllSessions = this.sendAllSessions;
        result.sendAllSessionsSize = this.sendAllSessionsSize;
        result.sendAllSessionsWaitTime = this.sendAllSessionsWaitTime;
        result.receiverQueue = this.receiverQueue;
        result.stateTimestampDrop = this.stateTimestampDrop;
        result.stateTransferCreateSendTime = this.stateTransferCreateSendTime;
        return result;
    }

    public Map<String, CarbonTomcatSessionMessage> getQueuedSessionMsgMap() {
        return this.messageMap;
    }

    static {
        allowedClasses.add("org.apache.catalina.session.ManagerBase");
        allowedClasses.add("org.apache.catalina.connector.Request");
    }
}

