/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.webapp.mgt.sso;

import java.security.KeyStore;
import java.security.cert.X509Certificate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Response;
import org.opensaml.saml2.core.Subject;
import org.opensaml.security.SAMLSignatureProfileValidator;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.signature.SignatureValidator;
import org.opensaml.xml.validation.ValidationException;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.util.KeyStoreManager;
import org.wso2.carbon.identity.sso.agent.SSOAgentException;
import org.wso2.carbon.identity.sso.agent.bean.SSOAgentConfig;
import org.wso2.carbon.identity.sso.agent.util.SAMLSignatureValidator;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;
import org.wso2.carbon.webapp.mgt.DataHolder;
import org.wso2.carbon.webapp.mgt.sso.SSOCarbonX509Credential;

public class SAMLSignatureValidatorImpl
implements SAMLSignatureValidator {
    private static Log log = LogFactory.getLog(SAMLSignatureValidatorImpl.class);

    public void validateSignature(Response response, Assertion assertion, SSOAgentConfig ssoAgentConfig) throws SSOAgentException {
        SignatureValidator validator;
        SAMLSignatureProfileValidator signatureProfileValidator;
        if (ssoAgentConfig.getSAML2().isResponseSigned().booleanValue()) {
            if (response.getSignature() == null) {
                throw new SSOAgentException("SAML2 Response signing is enabled, but signature element not found in SAML2 Response element");
            }
            try {
                log.info((Object)"Invoking SAMLSignatureProfileValidator for Response");
                signatureProfileValidator = new SAMLSignatureProfileValidator();
                signatureProfileValidator.validate(response.getSignature());
                validator = this.getSignatureValidator(assertion);
                validator.validate(response.getSignature());
            }
            catch (ValidationException e) {
                throw new SSOAgentException("Signature validation failed for SAML2 Response", (Throwable)e);
            }
        }
        if (ssoAgentConfig.getSAML2().isAssertionSigned().booleanValue()) {
            if (assertion.getSignature() == null) {
                throw new SSOAgentException("SAML2 Assertion signing is enabled, but signature element not found in SAML2 Assertion element");
            }
            try {
                log.info((Object)"Invoking SAMLSignatureProfileValidator for Assersion");
                signatureProfileValidator = new SAMLSignatureProfileValidator();
                signatureProfileValidator.validate(assertion.getSignature());
                validator = this.getSignatureValidator(assertion);
                validator.validate(assertion.getSignature());
            }
            catch (ValidationException e) {
                throw new SSOAgentException("Signature validation failed for SAML2 Assertion");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SignatureValidator getSignatureValidator(Assertion assertion) throws SSOAgentException {
        X509Certificate certificate;
        Subject subject = assertion.getSubject();
        String fqUserName = subject.getNameID().getValue();
        String tenantDomain = MultitenantUtils.getTenantDomain((String)fqUserName);
        try {
            int tenantId = DataHolder.getRealmService().getTenantManager().getTenantId(tenantDomain);
            if (tenantId != -1234) {
                try {
                    PrivilegedCarbonContext.startTenantFlow();
                    PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
                    carbonContext.setTenantDomain(tenantDomain, true);
                    DataHolder.getTenantRegistryLoader().loadTenantRegistry(tenantId);
                }
                catch (RegistryException e) {
                    log.error((Object)("Unable to load tenant registry for tenant :: " + tenantDomain), (Throwable)e);
                }
                finally {
                    PrivilegedCarbonContext.endTenantFlow();
                }
            }
            certificate = this.getX509CredentialImplForTenant(tenantId, tenantDomain).getEntityCertificate();
        }
        catch (UserStoreException e) {
            throw new SSOAgentException("unable to get tenant ID for domain : " + tenantDomain, (Throwable)e);
        }
        return new SignatureValidator((Credential)new SSOCarbonX509Credential(certificate));
    }

    private SSOCarbonX509Credential getX509CredentialImplForTenant(int tenantID, String domainName) throws SSOAgentException {
        SSOCarbonX509Credential credentialImpl;
        KeyStoreManager keyStoreManager = KeyStoreManager.getInstance((int)tenantID);
        try {
            X509Certificate x509Certificate;
            if (tenantID != -1234) {
                KeyStore keystore = keyStoreManager.getKeyStore(SAMLSignatureValidatorImpl.generateKSNameFromDomainName(domainName));
                x509Certificate = (X509Certificate)keystore.getCertificate(domainName);
            } else {
                x509Certificate = keyStoreManager.getDefaultPrimaryCertificate();
            }
            credentialImpl = new SSOCarbonX509Credential(x509Certificate);
        }
        catch (Exception e) {
            String errorMsg = "Error instantiating an X509CredentialImpl object for the public cert.";
            throw new SSOAgentException(errorMsg, (Throwable)e);
        }
        return credentialImpl;
    }

    private static String generateKSNameFromDomainName(String tenantDomain) {
        String ksName = tenantDomain.trim().replace(".", "-");
        return ksName + ".jks";
    }
}

