/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.webapp.mgt;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.tomcat.ext.utils.URLMappingHolder;
import org.wso2.carbon.tomcat.ext.valves.CarbonTomcatValve;
import org.wso2.carbon.tomcat.ext.valves.CompositeValve;
import org.wso2.carbon.user.core.tenant.TenantManager;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;
import org.wso2.carbon.webapp.mgt.DataHolder;
import org.wso2.carbon.webapp.mgt.TomcatUtil;

public class TenantLazyLoaderValve
extends CarbonTomcatValve {
    private static final Log log = LogFactory.getLog(TenantLazyLoaderValve.class);

    public void invoke(Request request, Response response, CompositeValve compositeValve) {
        String domain;
        String requestURI = request.getRequestURI();
        String requestedHostName = request.getServerName();
        String uriOfVirtualHost = URLMappingHolder.getInstance().getApplicationFromUrlMapping(requestedHostName);
        if (TomcatUtil.isVirtualHostRequest(requestedHostName).booleanValue() && uriOfVirtualHost == null) {
            uriOfVirtualHost = DataHolder.getHotUpdateService().getApplicationContextForHost(requestedHostName);
        }
        if (uriOfVirtualHost != null) {
            requestURI = uriOfVirtualHost;
        }
        if ((domain = MultitenantUtils.getTenantDomainFromRequestURL((String)requestURI)) == null || domain.trim().length() == 0) {
            this.getNext().invoke(request, response, compositeValve);
            return;
        }
        if (!(requestURI.contains("/webapps/") || requestURI.contains("/jaggeryapps/") || requestURI.contains("/jaxwebapps/"))) {
            this.getNext().invoke(request, response, compositeValve);
            return;
        }
        try {
            TenantManager tenantManager = DataHolder.getRealmService().getTenantManager();
            int tenantId = tenantManager.getTenantId(domain);
            if (tenantId == -1) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Tenant does not exist: " + domain));
                }
                this.getNext().invoke(request, response, compositeValve);
                return;
            }
        }
        catch (Exception e) {
            log.error((Object)"Error occurred while checking tenant existence", (Throwable)e);
            this.getNext().invoke(request, response, compositeValve);
            return;
        }
        ConfigurationContext serverConfigCtx = DataHolder.getServerConfigContext();
        if (serverConfigCtx != null) {
            if (TenantAxisUtils.getLastAccessed((String)domain, (ConfigurationContext)serverConfigCtx) == -1L) {
                try {
                    PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
                    String applicationName = carbonContext.getApplicationName();
                    this.setTenantAccessed(domain, serverConfigCtx);
                    if (requestURI.contains("/webapps/") || requestURI.contains("/jaxwebapps/") || requestURI.contains("/jaggeryapps/")) {
                        TomcatUtil.remapRequest((HttpServletRequest)request);
                        carbonContext.setApplicationName(applicationName);
                    } else {
                        request.getRequestDispatcher(requestURI).forward((ServletRequest)request, (ServletResponse)response);
                    }
                }
                catch (Exception e) {
                    String msg = "Cannot redirect tenant request to " + requestURI + " for tenant " + domain;
                    log.error((Object)msg, (Throwable)e);
                    throw new RuntimeException(msg, e);
                }
            }
            this.setTenantAccessed(domain, serverConfigCtx);
            this.getNext().invoke(request, response, compositeValve);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTenantAccessed(String domain, ConfigurationContext serverConfigCtx) {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(TenantLazyLoaderValve.class.getClassLoader());
            TenantAxisUtils.setTenantAccessed((String)domain, (ConfigurationContext)serverConfigCtx);
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }
}

