/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.webapp.mgt.loader;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.apache.catalina.loader.WebappClassLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.webapp.mgt.loader.CompoundEnumeration;
import org.wso2.carbon.webapp.mgt.loader.WebappClassloadingContext;

public class CarbonWebappClassLoader
extends WebappClassLoader {
    private static final Log log = LogFactory.getLog(CarbonWebappClassLoader.class);
    private WebappClassloadingContext webappCC;
    private static List<String> systemPackages;

    public CarbonWebappClassLoader(ClassLoader parent) {
        super(parent);
        String launchIniPath = Paths.get(CarbonUtils.getCarbonConfigDirPath(), "etc", "launch.ini").toString();
        this.readSystemPackagesList(launchIniPath);
    }

    public void setWebappCC(WebappClassloadingContext classloadingContext) {
        this.webappCC = classloadingContext;
    }

    public synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        int i;
        Class<?> clazz;
        if (log.isDebugEnabled()) {
            log.debug((Object)("loadClass(" + name + ", " + resolve + ")"));
        }
        if (!this.started) {
            try {
                throw new IllegalStateException();
            }
            catch (IllegalStateException e) {
                log.info((Object)sm.getString("webappClassLoader.stopped", new Object[]{name}), (Throwable)e);
            }
        }
        if ((clazz = this.findLoadedClass0(name)) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"  Returning class from cache");
            }
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        clazz = this.findLoadedClass(name);
        if (clazz != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"  Returning class from cache");
            }
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        try {
            clazz = this.j2seClassLoader.loadClass(name);
            if (clazz != null) {
                if (resolve) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (this.securityManager != null && (i = name.lastIndexOf(46)) >= 0) {
            try {
                this.securityManager.checkPackageAccess(name.substring(0, i));
            }
            catch (SecurityException se) {
                String error = "Security Violation, attempt to use Restricted Class: " + name;
                log.info((Object)error, (Throwable)se);
                throw new ClassNotFoundException(error, se);
            }
        }
        boolean delegatedPkg = this.webappCC.isDelegatedPackage(name);
        boolean excludedPkg = this.webappCC.isExcludedPackage(name);
        if (this.webappCC.isParentFirst() && delegatedPkg && !excludedPkg && (clazz = this.findClassFromParent(name, resolve)) != null) {
            return clazz;
        }
        clazz = this.findLocalClass(name, resolve);
        if (clazz != null) {
            return clazz;
        }
        if (!this.webappCC.isParentFirst() && delegatedPkg && !excludedPkg && (clazz = this.findClassFromParent(name, resolve)) != null) {
            return clazz;
        }
        throw new ClassNotFoundException(name);
    }

    protected Class<?> findClassFromParent(String name, boolean resolve) throws ClassNotFoundException {
        ClassLoader loader;
        Class<?> clazz = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("  Delegating to parent classloader1 " + this.parent));
        }
        if ((loader = this.parent) == null) {
            loader = this.j2seClassLoader;
        }
        try {
            clazz = Class.forName(name, false, loader);
            if (clazz != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"  Loading class from parent");
                }
                if (resolve) {
                    this.resolveClass(clazz);
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return clazz;
    }

    protected Class<?> findLocalClass(String name, boolean resolve) throws ClassNotFoundException {
        Class clazz = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"  Searching local repositories");
        }
        try {
            clazz = this.findClass(name);
            if (clazz != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"  Loading class from local repository");
                }
                if (resolve) {
                    this.resolveClass(clazz);
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return clazz;
    }

    public InputStream getResourceAsStream(String name) {
        ClassLoader loader;
        InputStream stream = super.getResourceAsStream(name);
        if (stream != null) {
            return stream;
        }
        if (name.endsWith(".class") && this.isSystemPackage(name) && (stream = (loader = this.j2seClassLoader).getResourceAsStream(name)) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"  --> Returning stream from system classloader");
            }
            return stream;
        }
        return null;
    }

    private boolean isSystemPackage(String resourceName) {
        String packageName = (resourceName = resourceName.replace(".class", "").replace("/", ".")).lastIndexOf(".") == -1 ? resourceName : resourceName.substring(0, resourceName.lastIndexOf("."));
        return systemPackages.contains(packageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readSystemPackagesList(String launchIniPath) {
        Properties properties = new Properties();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(launchIniPath);
            properties.load(fileInputStream);
            String rawSystemPackages = properties.getProperty("org.osgi.framework.system.packages");
            String[] systemPackagesArray = rawSystemPackages.split("[ ]?,[ ]?");
            systemPackages = Arrays.asList(systemPackagesArray);
        }
        catch (IOException e) {
            log.warn((Object)"Error reading system packages list from launch.ini", (Throwable)e);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration[] tmp = new Enumeration[2];
        if (this.parent != null && this.webappCC != null) {
            boolean delegatedRes = this.webappCC.isDelegatedResource(name);
            boolean excludedRes = this.webappCC.isExcludedResources(name);
            if (delegatedRes && !excludedRes) {
                tmp[0] = this.parent.getResources(name);
            }
        }
        tmp[1] = this.findResources(name);
        return new CompoundEnumeration<URL>(tmp);
    }
}

