/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.webapp.mgt.session;

import java.util.Map;
import java.util.Set;
import org.apache.axis2.clustering.ClusteringCommand;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.ClusteringMessage;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.catalina.ha.ClusterMessage;
import org.apache.catalina.ha.session.SessionMessage;
import org.apache.catalina.tribes.Member;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.webapp.mgt.DataHolder;
import org.wso2.carbon.webapp.mgt.session.CarbonTomcatClusterableSessionManager;

public class CarbonTomcatSessionMessage
extends ClusteringMessage
implements SessionMessage {
    private static final Log log = LogFactory.getLog(CarbonTomcatSessionMessage.class);
    private static final long serialVersionUID = 1L;
    private int mEvtType = -1;
    private byte[] mSession;
    private String mSessionID;
    private String mContextName;
    private long serializationTimestamp;
    private boolean timestampSet = false;
    private String uniqueId;
    protected transient Member address;
    private int tenantId;

    public CarbonTomcatSessionMessage() {
    }

    public CarbonTomcatSessionMessage(String contextName, int eventtype, byte[] session, String sessionID, String uniqueID, int tenantId) {
        this(contextName, eventtype, session, sessionID);
        this.uniqueId = uniqueID;
        this.tenantId = tenantId;
    }

    private CarbonTomcatSessionMessage(String contextName, int eventtype, byte[] session, String sessionID) {
        this.mEvtType = eventtype;
        this.mSession = session;
        this.mSessionID = sessionID;
        this.mContextName = contextName;
        this.uniqueId = sessionID;
    }

    @Deprecated
    public CarbonTomcatSessionMessage(String contextName, int eventtype, byte[] session, String sessionID, String uniqueID) {
        this(contextName, eventtype, session, sessionID);
        this.uniqueId = uniqueID;
    }

    public int getEventType() {
        return this.mEvtType;
    }

    public byte[] getSession() {
        return this.mSession;
    }

    public String getSessionID() {
        return this.mSessionID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimestamp(long time) {
        CarbonTomcatSessionMessage carbonTomcatSessionMessage = this;
        synchronized (carbonTomcatSessionMessage) {
            if (!this.timestampSet) {
                this.serializationTimestamp = time;
                this.timestampSet = true;
            }
        }
    }

    public long getTimestamp() {
        return this.serializationTimestamp;
    }

    public String getEventTypeString() {
        switch (this.mEvtType) {
            case 1: {
                return "SESSION-MODIFIED";
            }
            case 2: {
                return "SESSION-EXPIRED";
            }
            case 3: {
                return "SESSION-ACCESSED";
            }
            case 4: {
                return "SESSION-GET-ALL";
            }
            case 13: {
                return "SESSION-DELTA";
            }
            case 12: {
                return "ALL-SESSION-DATA";
            }
            case 14: {
                return "SESSION-STATE-TRANSFERED";
            }
            case 15: {
                return "SESSION-ID-CHANGED";
            }
            case 16: {
                return "NO-CONTEXT-MANAGER";
            }
        }
        return "UNKNOWN-EVENT-TYPE";
    }

    public String getContextName() {
        return this.mContextName;
    }

    public Member getAddress() {
        return this.address;
    }

    public void setAddress(Member member) {
        this.address = member;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    public String toString() {
        return this.getEventTypeString() + "#" + this.getContextName() + "#" + this.getSessionID();
    }

    public ClusteringCommand getResponse() {
        return new CarbonTomcatSessionMessage();
    }

    public void setTenantId(int tenantId) {
        this.tenantId = tenantId;
    }

    public void execute(ConfigurationContext mainConfigContext) throws ClusteringFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Received CarbonTomcatSessionMessage");
        }
        try {
            CarbonTomcatClusterableSessionManager manager;
            String context;
            String tenantDomain = DataHolder.getRealmService().getTenantManager().getDomain(this.tenantId);
            ConfigurationContext configContext = null;
            if (this.tenantId == -1234 || this.tenantId == -1) {
                configContext = mainConfigContext;
            } else if (TenantAxisUtils.getTenantConfigurationContexts((ConfigurationContext)mainConfigContext).get(tenantDomain) != null) {
                configContext = (ConfigurationContext)TenantAxisUtils.getTenantConfigurationContexts((ConfigurationContext)mainConfigContext).get(tenantDomain);
            }
            if (configContext == null) {
                return;
            }
            Map sessionManagerMap = (Map)configContext.getProperty("CarbonTomcatSessionManagerMap");
            if (sessionManagerMap != null && !sessionManagerMap.isEmpty() && this.getContextName() != null && (context = this.getWebappContext(this.getContextName(), sessionManagerMap.keySet())) != null && (manager = (CarbonTomcatClusterableSessionManager)((Object)sessionManagerMap.get(context))) != null) {
                manager.clusterMessageReceived((ClusterMessage)this);
            }
        }
        catch (UserStoreException e) {
            throw new ClusteringFault(e.getMessage(), (Exception)((Object)e));
        }
    }

    private String getWebappContext(String path, Set<String> contextSet) {
        for (String key : contextSet) {
            if (!path.contains(key) || !path.endsWith(key)) continue;
            return key;
        }
        return null;
    }
}

