/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.webapp.mgt.sso;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.Principal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.authenticator.SingleSignOn;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.identity.sso.agent.SSOAgentException;
import org.wso2.carbon.identity.sso.agent.SSOAgentRequestResolver;
import org.wso2.carbon.identity.sso.agent.bean.LoggedInSessionBean;
import org.wso2.carbon.identity.sso.agent.bean.SSOAgentConfig;
import org.wso2.carbon.identity.sso.agent.saml.SAML2SSOManager;
import org.wso2.carbon.identity.sso.agent.saml.SSOAgentCarbonX509Credential;
import org.wso2.carbon.identity.sso.agent.saml.SSOAgentX509Credential;
import org.wso2.carbon.identity.sso.agent.util.SSOAgentUtils;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;
import org.wso2.carbon.webapp.mgt.sso.RelayState;
import org.wso2.carbon.webapp.mgt.sso.SSOUtils;
import org.wso2.carbon.webapp.mgt.sso.WebappSSOConstants;

public class SAMLSSOValve
extends SingleSignOn {
    private static Log log = LogFactory.getLog(SAMLSSOValve.class);
    private static final String MEDIA_TYPE_TEXT_HTML = "text/html";
    private static final String ENABLE_SAML2_SSO_WITH_TENANT = "enable.saml2.sso.with.tenant";
    private Properties ssoSPConfigProperties = new Properties();

    public SAMLSSOValve() throws IOException {
        log.info((Object)"Initializing SAMLSSOValve..");
        if (SSOUtils.isSSOSPConfigExists()) {
            try (FileInputStream fileInputStream = new FileInputStream(WebappSSOConstants.SSO_SP_CONFIG_PATH);){
                this.ssoSPConfigProperties.load(fileInputStream);
                log.info((Object)"Successfully loaded SSO SP Config.");
            }
        } else {
            throw new FileNotFoundException("Unable to find SSO SP config properties file in" + WebappSSOConstants.SSO_SP_CONFIG_PATH);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Invoking SAMLSSOValve. Request URI : " + request.getRequestURI()));
        }
        if (!Boolean.parseBoolean(request.getContext().findParameter("enable.saml2.sso"))) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Saml2 SSO not enabled in webapp " + request.getContext().getName()));
            }
            this.getNext().invoke(request, response);
            return;
        }
        SSOAgentConfig ssoAgentConfig = (SSOAgentConfig)request.getSessionInternal().getNote("SSOAgentConfig");
        if (ssoAgentConfig == null) {
            try {
                ssoAgentConfig = new SSOAgentConfig();
                ssoAgentConfig.initConfig(this.ssoSPConfigProperties);
                String tenantDomain = MultitenantUtils.getTenantDomain((HttpServletRequest)request);
                int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
                SSOAgentCarbonX509Credential ssoAgentX509Credential = new SSOAgentCarbonX509Credential(tenantId, tenantDomain);
                ssoAgentConfig.getSAML2().setSSOAgentX509Credential((SSOAgentX509Credential)ssoAgentX509Credential);
                ssoAgentConfig.getSAML2().setSPEntityId(SSOUtils.generateIssuerID(request.getContextPath()));
                ssoAgentConfig.getSAML2().setACSURL(SSOUtils.generateConsumerUrl(request.getContextPath(), this.ssoSPConfigProperties));
                ssoAgentConfig.verifyConfig();
                String ssoTenantDomain = request.getContext().findParameter(ENABLE_SAML2_SSO_WITH_TENANT);
                if (ssoTenantDomain != null && !ssoTenantDomain.isEmpty()) {
                    ssoAgentConfig.getQueryParams().put("tenantDomain", new String[]{ssoTenantDomain});
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Creating SSOAgentConfig, IssuerId=" + ssoAgentConfig.getSAML2().getSPEntityId() + ", CurrentTenant=" + tenantDomain + ", SSOTenant=" + ssoTenantDomain));
                }
                request.getSessionInternal().setNote("SSOAgentConfig", (Object)ssoAgentConfig);
            }
            catch (Exception e) {
                log.error((Object)"Error on initializing SAML2SSOManager", (Throwable)e);
                return;
            }
        }
        try {
            LoggedInSessionBean.SAML2SSO sessionBean;
            String principalName;
            LoggedInSessionBean loggedInSessionBean;
            SSOAgentRequestResolver resolver = new SSOAgentRequestResolver((HttpServletRequest)request, (HttpServletResponse)response, ssoAgentConfig);
            if (resolver.isURLToSkip()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Request matched a skip URL. Skipping..");
                }
                this.getNext().invoke(request, response);
                return;
            }
            if (resolver.isSLORequest()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Processing Single Log Out Request");
                }
                SAML2SSOManager samlSSOManager = new SAML2SSOManager(ssoAgentConfig);
                samlSSOManager.doSLO((HttpServletRequest)request);
            } else if (resolver.isSAML2SSOResponse()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Processing SSO Response.");
                }
                SAML2SSOManager samlSSOManager = new SAML2SSOManager(ssoAgentConfig);
                try {
                    String redirectPath = this.readAndForgetRedirectPathAfterSLO(request);
                    samlSSOManager.processResponse((HttpServletRequest)request, (HttpServletResponse)response);
                    String relayStateId = ssoAgentConfig.getSAML2().getRelayState();
                    if (relayStateId != null && request.getSession(Boolean.FALSE.booleanValue()) != null) {
                        RelayState relayState = (RelayState)request.getSession(Boolean.FALSE.booleanValue()).getAttribute(relayStateId);
                        if (relayState == null) {
                            response.sendRedirect(this.ssoSPConfigProperties.getProperty(WebappSSOConstants.APP_SERVER_URL) + request.getContextPath());
                            return;
                        }
                        request.getSession(Boolean.FALSE.booleanValue()).removeAttribute(relayStateId);
                        String requestedURI = relayState.getRequestedURL();
                        if (relayState.getRequestQueryString() != null) {
                            requestedURI = requestedURI.concat("?").concat(relayState.getRequestQueryString());
                        }
                        if (relayState.getRequestParameters() != null) {
                            request.getSession(Boolean.FALSE.booleanValue()).setAttribute("REQUEST_PARAM_MAP", relayState.getRequestParameters());
                        }
                        response.sendRedirect(requestedURI);
                        return;
                    }
                    if (request.getRequestURI().endsWith(this.ssoSPConfigProperties.getProperty(WebappSSOConstants.CONSUMER_URL_POSTFIX)) && Boolean.parseBoolean(this.ssoSPConfigProperties.getProperty("handleConsumerURLAfterSLO"))) {
                        response.sendRedirect(redirectPath);
                        return;
                    }
                }
                catch (SSOAgentException e) {
                    this.handleException((HttpServletRequest)request, e);
                }
            } else {
                if (resolver.isSLOURL()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Processing Single Log Out URL");
                    }
                    SAML2SSOManager samlSSOManager = new SAML2SSOManager(ssoAgentConfig);
                    if (!resolver.isHttpPostBinding()) {
                        ssoAgentConfig.getSAML2().setPassiveAuthn(Boolean.valueOf(false));
                        response.sendRedirect(samlSSOManager.buildRedirectRequest((HttpServletRequest)request, true));
                        return;
                    }
                    if (request.getSession(false).getAttribute("org.wso2.carbon.identity.sso.agent.LoggedInSessionBean") != null) {
                        ssoAgentConfig.getSAML2().setPassiveAuthn(Boolean.valueOf(false));
                        String htmlPayload = samlSSOManager.buildPostRequest((HttpServletRequest)request, (HttpServletResponse)response, true);
                        response.addHeader("Content-Type", MEDIA_TYPE_TEXT_HTML);
                        SSOAgentUtils.sendPostResponse((HttpServletRequest)request, (HttpServletResponse)response, (String)htmlPayload);
                        return;
                    }
                    log.warn((Object)"Attempt to logout from a already logout session.");
                    response.sendRedirect(request.getContext().getPath());
                    return;
                }
                if (resolver.isSAML2SSOURL() || ssoAgentConfig.isSAML2SSOLoginEnabled().booleanValue() && (request.getSession(false) == null || request.getSession(false).getAttribute("org.wso2.carbon.identity.sso.agent.LoggedInSessionBean") == null)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Processing SSO URL");
                    }
                    SAML2SSOManager samlSSOManager = new SAML2SSOManager(ssoAgentConfig);
                    String relayStateId = SSOAgentUtils.createID();
                    RelayState relayState = new RelayState();
                    relayState.setRequestedURL(request.getRequestURI());
                    relayState.setRequestQueryString(request.getQueryString());
                    relayState.setRequestParameters(request.getParameterMap());
                    ssoAgentConfig.getSAML2().setRelayState(relayStateId);
                    request.getSession(Boolean.FALSE.booleanValue()).setAttribute(relayStateId, (Object)relayState);
                    if (resolver.isHttpPostBinding()) {
                        ssoAgentConfig.getSAML2().setPassiveAuthn(Boolean.valueOf(false));
                        String htmlPayload = samlSSOManager.buildPostRequest((HttpServletRequest)request, (HttpServletResponse)response, false);
                        response.addHeader("Content-Type", MEDIA_TYPE_TEXT_HTML);
                        SSOAgentUtils.sendPostResponse((HttpServletRequest)request, (HttpServletResponse)response, (String)htmlPayload);
                        return;
                    }
                    ssoAgentConfig.getSAML2().setPassiveAuthn(Boolean.valueOf(false));
                    response.sendRedirect(samlSSOManager.buildRedirectRequest((HttpServletRequest)request, false));
                    return;
                }
            }
            if (request.getSession(false) != null && (loggedInSessionBean = (LoggedInSessionBean)request.getSession(false).getAttribute("org.wso2.carbon.identity.sso.agent.LoggedInSessionBean")) != null && (principalName = (sessionBean = loggedInSessionBean.getSAML2SSO()).getSubjectId()) != null) {
                String roles;
                List<String> rolesList = null;
                Map attrMap = sessionBean.getSubjectAttributes();
                if (attrMap != null && !attrMap.isEmpty() && (roles = (String)attrMap.get("http://wso2.org/claims/role")) != null && !roles.isEmpty()) {
                    String[] rolesArr = roles.split(",");
                    rolesList = Arrays.asList(rolesArr);
                }
                request.setUserPrincipal((Principal)new GenericPrincipal(principalName, null, rolesList));
            }
        }
        catch (SSOAgentException e) {
            log.error((Object)"An error has occurred", (Throwable)e);
            throw e;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"End of SAMLSSOValve invoke.");
        }
        this.getNext().invoke(request, response);
    }

    public void backgroundProcess() {
        super.backgroundProcess();
    }

    protected void handleException(HttpServletRequest request, SSOAgentException e) throws SSOAgentException {
        if (request.getSession(false) != null) {
            request.getSession(false).removeAttribute("org.wso2.carbon.identity.sso.agent.LoggedInSessionBean");
        }
        throw e;
    }

    private String readAndForgetRedirectPathAfterSLO(Request request) {
        String redirectPath = null;
        if (request.getSession(false) != null) {
            redirectPath = (String)request.getSession(false).getAttribute("redirectPathAfterSLO");
            request.getSession(false).removeAttribute("redirectPathAfterSLO");
        }
        if (redirectPath == null) {
            redirectPath = request.getContext().findParameter("redirectPathAfterSLO");
        }
        if (redirectPath == null) {
            redirectPath = this.ssoSPConfigProperties.getProperty("redirectPathAfterSLO");
        }
        redirectPath = redirectPath != null && !redirectPath.isEmpty() ? request.getContext().getPath().concat(redirectPath) : request.getContext().getPath();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Redirect path = " + redirectPath));
        }
        return redirectPath;
    }
}

