/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.webapp.mgt.sso;

import java.io.File;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.webapp.mgt.sso.WebappSSOConstants;

public class SSOUtils {
    private static Log log = LogFactory.getLog(SSOUtils.class);

    public static boolean isSSOSPConfigExists() {
        File configFile = new File(WebappSSOConstants.SSO_SP_CONFIG_PATH);
        return configFile.exists();
    }

    public static String generateIssuerID(String contextPath) {
        String issuerId = contextPath.replaceFirst("/webapps", "").replace("/", "_");
        if (issuerId.startsWith("_")) {
            issuerId = issuerId.substring(1);
        }
        return issuerId;
    }

    public static String generateConsumerUrl(String contextPath, Properties ssoSPConfigProperties) {
        return ssoSPConfigProperties.getProperty(WebappSSOConstants.APP_SERVER_URL) + contextPath + ssoSPConfigProperties.getProperty(WebappSSOConstants.CONSUMER_URL_POSTFIX);
    }

    public static String getSAMLSSOURLforApp(String requestURI, Properties ssoSPConfigProperties) {
        return ssoSPConfigProperties.getProperty(WebappSSOConstants.APP_SERVER_URL) + requestURI + ssoSPConfigProperties.getProperty("SAMLSSOUrl");
    }
}

