/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.webapp.mgt.ui;

import java.rmi.RemoteException;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.webapp.mgt.stub.WebappAdminStub;
import org.wso2.carbon.webapp.mgt.stub.types.carbon.VhostHolder;
import org.wso2.carbon.webapp.mgt.stub.types.carbon.WebappUploadData;

public class WebappAdminClient {
    public static final String BUNDLE = "org.wso2.carbon.webapp.mgt.ui.i18n.Resources";
    public static final int MILLISECONDS_PER_MINUTE = 60000;
    private static final Log log = LogFactory.getLog(WebappAdminClient.class);
    private ResourceBundle bundle;
    public WebappAdminStub stub;

    public WebappAdminClient(String cookie, String backendServerURL, ConfigurationContext configCtx, Locale locale) throws AxisFault {
        String serviceURL = backendServerURL + "WebappAdmin";
        this.bundle = ResourceBundle.getBundle(BUNDLE, locale);
        this.stub = new WebappAdminStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
        option.setProperty("enableMTOM", (Object)"true");
    }

    public void uploadWebapp(WebappUploadData[] webappUploadDataList) throws AxisFault {
        try {
            this.stub.uploadWebapp(webappUploadDataList);
        }
        catch (RemoteException e) {
            this.handleException("cannot.upload.webapps", e);
        }
    }

    public VhostHolder getVhostHolder() throws RemoteException {
        return this.stub.getVhostHolder();
    }

    private void handleException(String msgKey, Exception e) throws AxisFault {
        String msg = this.bundle.getString(msgKey);
        log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }
}

