/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.um.ws.api;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.transport.http.HttpTransportProperties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.um.ws.api.WSRealmUtil;
import org.wso2.carbon.um.ws.api.stub.ClaimValue;
import org.wso2.carbon.um.ws.api.stub.PermissionDTO;
import org.wso2.carbon.um.ws.api.stub.RemoteUserStoreManagerServiceStub;
import org.wso2.carbon.user.api.ClaimManager;
import org.wso2.carbon.user.api.Properties;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.api.Tenant;
import org.wso2.carbon.user.core.Permission;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.claim.Claim;

public class WSUserStoreManager
implements UserStoreManager {
    private static final Log log = LogFactory.getLog(WSUserStoreManager.class);
    private RemoteUserStoreManagerServiceStub stub = null;
    private static final String UNSUPPORTED_PASSWORD_MESSAGE = "Unsupported type of password";
    private static final String SERVICE_NAME = "RemoteUserStoreManagerService";

    public WSUserStoreManager(String serverUrl, String cookie, ConfigurationContext configCtxt) throws UserStoreException {
        try {
            this.stub = new RemoteUserStoreManagerServiceStub(configCtxt, serverUrl + SERVICE_NAME);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault e) {
            this.handleException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public WSUserStoreManager(String userName, String password, String serverUrl, ConfigurationContext configCtxt) throws UserStoreException {
        try {
            if (serverUrl != null && !serverUrl.endsWith("/")) {
                serverUrl = serverUrl + "/";
            }
            this.stub = new RemoteUserStoreManagerServiceStub(configCtxt, serverUrl + SERVICE_NAME);
            HttpTransportProperties.Authenticator authenticator = new HttpTransportProperties.Authenticator();
            authenticator.setUsername(userName);
            authenticator.setPassword(password);
            authenticator.setPreemptiveAuthentication(true);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("_NTLM_DIGEST_BASIC_AUTHENTICATION_", (Object)authenticator);
        }
        catch (AxisFault e) {
            this.handleException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public void addUser(String userName, Object credential, String[] roleList, Map<String, String> claims, String profileName, boolean requirePasswordChange) throws UserStoreException {
        try {
            if (!(credential instanceof String)) {
                throw new UserStoreException(UNSUPPORTED_PASSWORD_MESSAGE);
            }
            String password = (String)credential;
            ClaimValue[] claimValues = WSRealmUtil.convertMapToClaimValue(claims);
            this.stub.addUser(userName, password, roleList, claimValues, profileName, requirePasswordChange);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public void addRole(String roleName, String[] userList, Permission[] permissions) throws UserStoreException {
        try {
            this.stub.addRole(roleName, userList, this.convertPermission(permissions));
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public void addUser(String userName, Object credential, String[] roleList, Map<String, String> claims, String profileName) throws UserStoreException {
        if (!(credential instanceof String)) {
            throw new UserStoreException(UNSUPPORTED_PASSWORD_MESSAGE);
        }
        try {
            this.stub.addUser(userName, (String)credential, roleList, WSRealmUtil.convertMapToClaimValue(claims), profileName, false);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public boolean authenticate(String userName, Object credential) throws UserStoreException {
        if (!(credential instanceof String)) {
            throw new UserStoreException(UNSUPPORTED_PASSWORD_MESSAGE);
        }
        try {
            return this.stub.authenticate(userName, (String)credential);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return false;
        }
    }

    public void deleteRole(String roleName) throws UserStoreException {
        try {
            this.stub.deleteRole(roleName);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public void deleteUser(String userName) throws UserStoreException {
        try {
            this.stub.deleteUser(userName);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public void deleteUserClaimValue(String userName, String claimURI, String profileName) throws UserStoreException {
        try {
            this.stub.deleteUserClaimValue(userName, claimURI, profileName);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public void deleteUserClaimValues(String userName, String[] claims, String profileName) throws UserStoreException {
        try {
            this.stub.deleteUserClaimValues(userName, claims, profileName);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public String[] getAllProfileNames() throws UserStoreException {
        try {
            return this.stub.getAllProfileNames();
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return new String[0];
        }
    }

    public String[] getHybridRoles() throws UserStoreException {
        try {
            return this.stub.getHybridRoles();
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return new String[0];
        }
    }

    public String[] getAllSecondaryRoles() throws UserStoreException {
        return new String[0];
    }

    public Date getPasswordExpirationTime(String username) throws UserStoreException {
        try {
            long time = this.stub.getPasswordExpirationTime(username);
            if (time != -1L) {
                return new Date(time);
            }
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
        return null;
    }

    public String[] getProfileNames(String userName) throws UserStoreException {
        try {
            return this.stub.getProfileNames(userName);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return new String[0];
        }
    }

    public String[] getRoleListOfUser(String userName) throws UserStoreException {
        try {
            return this.stub.getRoleListOfUser(userName);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return new String[0];
        }
    }

    public String[] getRoleNames() throws UserStoreException {
        try {
            return this.stub.getRoleNames();
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return new String[0];
        }
    }

    public String[] getRoleNames(boolean b) throws UserStoreException {
        return new String[0];
    }

    public int getTenantId() throws UserStoreException {
        try {
            return this.stub.getTenantId();
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return -1;
        }
    }

    public int getTenantId(String username) throws UserStoreException {
        try {
            return this.stub.getTenantIdofUser(username);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return -1;
        }
    }

    public String getUserClaimValue(String userName, String claim, String profileName) throws UserStoreException {
        try {
            return this.stub.getUserClaimValue(userName, claim, profileName);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return profileName;
        }
    }

    public Claim[] getUserClaimValues(String userName, String profileName) throws UserStoreException {
        try {
            return WSRealmUtil.convertToClaims(this.stub.getUserClaimValues(userName, profileName));
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return new Claim[0];
        }
    }

    public Map<String, String> getUserClaimValues(String userName, String[] claims, String profileName) throws UserStoreException {
        try {
            return WSRealmUtil.convertClaimValuesToMap(this.stub.getUserClaimValuesForClaims(userName, claims, profileName));
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return new TreeMap<String, String>();
        }
    }

    public int getUserId(String username) throws UserStoreException {
        try {
            return this.stub.getUserId(username);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return -1;
        }
    }

    public String[] getUserListOfRole(String roleName) throws UserStoreException {
        try {
            return this.stub.getUserListOfRole(roleName);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return new String[0];
        }
    }

    public boolean isExistingRole(String roleName, boolean isSharedRole) throws UserStoreException {
        try {
            return this.stub.isExistingRole(roleName);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return false;
        }
    }

    public boolean isExistingUser(String userName) throws UserStoreException {
        try {
            return this.stub.isExistingUser(userName);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return false;
        }
    }

    public boolean isReadOnly() throws UserStoreException {
        try {
            return this.stub.isReadOnly();
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return false;
        }
    }

    public String[] listUsers(String filter, int maxItemLimit) throws UserStoreException {
        try {
            return this.stub.listUsers(filter, maxItemLimit);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return new String[0];
        }
    }

    public void setUserClaimValue(String userName, String claimURI, String claimValue, String profileName) throws UserStoreException {
        try {
            this.stub.setUserClaimValue(userName, claimURI, claimValue, profileName);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public void setUserClaimValues(String userName, Map<String, String> claims, String profileName) throws UserStoreException {
        try {
            this.stub.setUserClaimValues(userName, WSRealmUtil.convertMapToClaimValue(claims), profileName);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public void addUserClaimValue(String userName, String claimURI, String claimValue, String profileName) throws UserStoreException {
        try {
            this.stub.addUserClaimValue(userName, claimURI, claimValue, profileName);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public void addUserClaimValues(String userName, Map<String, String> claims, String profileName) throws UserStoreException {
        try {
            this.stub.addUserClaimValues(userName, WSRealmUtil.convertMapToClaimValue(claims), profileName);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public void updateCredential(String userName, Object newCredential, Object oldCredential) throws UserStoreException {
        if (!(newCredential instanceof String) || !(oldCredential instanceof String)) {
            throw new UserStoreException(UNSUPPORTED_PASSWORD_MESSAGE);
        }
        try {
            this.stub.updateCredential(userName, (String)newCredential, (String)oldCredential);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public void updateCredentialByAdmin(String userName, Object newCredential) throws UserStoreException {
        if (!(newCredential instanceof String)) {
            throw new UserStoreException(UNSUPPORTED_PASSWORD_MESSAGE);
        }
        try {
            this.stub.updateCredentialByAdmin(userName, (String)newCredential);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public void updateRoleListOfUser(String userName, String[] deletedRoles, String[] newRoles) throws UserStoreException {
        try {
            this.stub.updateRoleListOfUser(userName, deletedRoles, newRoles);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public void updateUserListOfRole(String roleName, String[] deletedUsers, String[] newUsers) throws UserStoreException {
        try {
            this.stub.updateUserListOfRole(roleName, deletedUsers, newUsers);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public void updateRoleName(String roleName, String newRoleName) throws UserStoreException {
        try {
            this.stub.updateRoleName(roleName, newRoleName);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public boolean isMultipleProfilesAllowed() {
        return true;
    }

    private PermissionDTO[] convertPermission(Permission[] permissions) {
        if (permissions == null) {
            return new PermissionDTO[0];
        }
        PermissionDTO[] perms = new PermissionDTO[permissions.length];
        for (int i = 0; i < permissions.length; ++i) {
            perms[i] = new PermissionDTO();
            perms[i].setAction(permissions[i].getAction());
            perms[i].setResourceId(permissions[i].getResourceId());
        }
        return perms;
    }

    private String[] handleException(String msg, Exception e) throws UserStoreException {
        log.error((Object)e.getMessage(), (Throwable)e);
        throw new UserStoreException(msg, (Throwable)e);
    }

    public Map<String, String> getProperties(org.wso2.carbon.user.core.tenant.Tenant tenant) throws UserStoreException {
        return new HashMap<String, String>();
    }

    public void addRole(String roleName, String[] userList, org.wso2.carbon.user.api.Permission[] permissions, boolean isSharedRole) throws UserStoreException {
        this.addRole(roleName, userList, this.getUseCorePermission(permissions));
    }

    private Permission[] getUseCorePermission(org.wso2.carbon.user.api.Permission[] permissions) {
        if (permissions != null && permissions.length > 0) {
            Permission[] perm = new Permission[permissions.length];
            for (int i = 0; i < permissions.length; ++i) {
                perm[i] = new Permission(permissions[i].getResourceId(), permissions[i].getAction());
            }
            return perm;
        }
        return new Permission[0];
    }

    public Map<String, String> getProperties(Tenant tenant) throws UserStoreException {
        if (tenant instanceof org.wso2.carbon.user.core.tenant.Tenant) {
            return this.getProperties((org.wso2.carbon.user.core.tenant.Tenant)org.wso2.carbon.user.core.tenant.Tenant.class.cast(tenant));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"tenant is not an instance of Tenant.");
        }
        return new HashMap<String, String>();
    }

    public void addRememberMe(String userName, String token) throws org.wso2.carbon.user.api.UserStoreException {
    }

    public boolean isValidRememberMeToken(String userName, String token) throws org.wso2.carbon.user.api.UserStoreException {
        return false;
    }

    public ClaimManager getClaimManager() throws org.wso2.carbon.user.api.UserStoreException {
        return null;
    }

    public boolean isSCIMEnabled() throws org.wso2.carbon.user.api.UserStoreException {
        return false;
    }

    public boolean isBulkImportSupported() throws UserStoreException {
        return false;
    }

    public String[] getUserList(String claim, String claimValue, String profileName) throws UserStoreException {
        try {
            return this.stub.getUserList(claim, claimValue, profileName);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return new String[0];
        }
    }

    public UserStoreManager getSecondaryUserStoreManager() {
        return null;
    }

    public void setSecondaryUserStoreManager(UserStoreManager userStoreManager) {
    }

    public UserStoreManager getSecondaryUserStoreManager(String s) {
        return null;
    }

    public void addSecondaryUserStoreManager(String s, UserStoreManager userStoreManager) {
    }

    public RealmConfiguration getRealmConfiguration() {
        return null;
    }

    public Properties getDefaultUserStoreProperties() {
        return null;
    }

    public void addRole(String roleName, String[] userList, org.wso2.carbon.user.api.Permission[] permissions) throws org.wso2.carbon.user.api.UserStoreException {
        this.addRole(roleName, userList, permissions, false);
    }

    public boolean isExistingRole(String roleName) throws UserStoreException {
        return this.isExistingRole(roleName, false);
    }

    public boolean isSharedGroupEnabled() {
        return false;
    }
}

