/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.um.ws.api;

import java.util.TimerTask;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.wso2.carbon.authenticator.proxy.AuthenticationAdminClient;
import org.wso2.carbon.core.util.AnonymousSessionUtil;
import org.wso2.carbon.um.ws.api.internal.UserMgtWSAPIDSComponent;
import org.wso2.carbon.um.ws.api.stub.RemoteTenantManagerServiceStub;
import org.wso2.carbon.um.ws.api.stub.Tenant;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.tenant.TenantManager;

public class WSRealmTenantManager
implements TenantManager {
    private static final Log log = LogFactory.getLog(AnonymousSessionUtil.class);
    private static final String SERVICE_NAME = "RemoteTenantManagerService";
    private static final String AXIS_FAULT_MESSAGE = "Axis fault occured  ";
    private static final String SERVER_LOGIN_ERROR = "WSRealmTenantManager cannot login to server";
    private RemoteTenantManagerServiceStub stub;
    private String userName = null;
    private String password = null;
    private String url = null;

    public WSRealmTenantManager(String userName, String password, String url) throws Exception {
        this.userName = userName;
        this.password = password;
        this.url = url;
        this.stub = this.getStub();
    }

    public void activateTenant(int tenantId) throws org.wso2.carbon.user.core.UserStoreException {
        try {
            this.getStub().activateTenant(tenantId);
        }
        catch (Exception e) {
            this.handleException("", e);
        }
    }

    public int addTenant(org.wso2.carbon.user.core.tenant.Tenant tenant) throws org.wso2.carbon.user.core.UserStoreException {
        try {
            return this.getStub().addTenant(this.tenantToADBTenant(tenant));
        }
        catch (Exception e) {
            this.handleException("", e);
            return -1;
        }
    }

    public void deactivateTenant(int tenantId) throws org.wso2.carbon.user.core.UserStoreException {
        try {
            this.getStub().deactivateTenant(tenantId);
        }
        catch (Exception e) {
            this.handleException("", e);
        }
    }

    public void deleteTenant(int tenantId) throws org.wso2.carbon.user.core.UserStoreException {
        try {
            this.getStub().deleteTenant(tenantId);
        }
        catch (Exception e) {
            this.handleException("", e);
        }
    }

    public void deleteTenant(int tenantId, boolean removeFromPersistentStorage) throws org.wso2.carbon.user.core.UserStoreException {
    }

    public org.wso2.carbon.user.core.tenant.Tenant[] getAllTenants() throws org.wso2.carbon.user.core.UserStoreException {
        try {
            Tenant[] tenats = this.stub.getAllTenants();
            if (tenats != null) {
                org.wso2.carbon.user.core.tenant.Tenant[] ts = new org.wso2.carbon.user.core.tenant.Tenant[tenats.length];
                for (int i = 0; i < tenats.length; ++i) {
                    ts[i] = this.ADBTenantToTenant(tenats[i]);
                }
                return ts;
            }
        }
        catch (Exception e) {
            this.handleException("", e);
        }
        return new org.wso2.carbon.user.core.tenant.Tenant[0];
    }

    public org.wso2.carbon.user.api.Tenant[] getAllTenantsForTenantDomainStr(String s) throws UserStoreException {
        return new org.wso2.carbon.user.api.Tenant[0];
    }

    public String getDomain(int tenantId) throws org.wso2.carbon.user.core.UserStoreException {
        try {
            return this.getStub().getDomain(tenantId);
        }
        catch (Exception e) {
            this.handleException("", e);
            return null;
        }
    }

    public String getSuperTenantDomain() throws org.wso2.carbon.user.core.UserStoreException {
        try {
            return this.getStub().getSuperTenantDomain();
        }
        catch (Exception e) {
            this.handleException("", e);
            return null;
        }
    }

    public int addTenant(org.wso2.carbon.user.api.Tenant tenant) throws UserStoreException {
        if (tenant instanceof org.wso2.carbon.user.core.tenant.Tenant) {
            return this.addTenant((org.wso2.carbon.user.core.tenant.Tenant)tenant);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"tenant is not an instance of Tenant. So addTenant operation is skipped");
        }
        return -1;
    }

    public void updateTenant(org.wso2.carbon.user.api.Tenant tenant) throws UserStoreException {
        if (tenant instanceof org.wso2.carbon.user.core.tenant.Tenant) {
            this.updateTenant((org.wso2.carbon.user.core.tenant.Tenant)tenant);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"tenant is not an instance of Tenant. So updateTenant operation is skipped");
        }
    }

    public org.wso2.carbon.user.core.tenant.Tenant getTenant(int tenantId) throws org.wso2.carbon.user.core.UserStoreException {
        try {
            return this.ADBTenantToTenant(this.getStub().getTenant(tenantId));
        }
        catch (Exception e) {
            this.handleException("", e);
            return null;
        }
    }

    public int getTenantId(String domain) throws org.wso2.carbon.user.core.UserStoreException {
        try {
            return this.getStub().getTenantId(domain);
        }
        catch (Exception e) {
            this.handleException("", e);
            return 0;
        }
    }

    public boolean isTenantActive(int tenantId) throws org.wso2.carbon.user.core.UserStoreException {
        try {
            return this.getStub().isTenantActive(tenantId);
        }
        catch (Exception e) {
            this.handleException("", e);
            return false;
        }
    }

    public void setBundleContext(BundleContext bundleContext) {
    }

    public void updateTenant(org.wso2.carbon.user.core.tenant.Tenant tenant) throws org.wso2.carbon.user.core.UserStoreException {
        try {
            this.getStub().updateTenant(this.tenantToADBTenant(tenant));
        }
        catch (Exception e) {
            this.handleException("", e);
        }
    }

    private String[] handleException(String msg, Exception e) throws org.wso2.carbon.user.core.UserStoreException {
        log.error((Object)msg, (Throwable)e);
        throw new org.wso2.carbon.user.core.UserStoreException(msg, (Throwable)e);
    }

    private org.wso2.carbon.user.core.tenant.Tenant ADBTenantToTenant(Tenant stubTenant) {
        org.wso2.carbon.user.core.tenant.Tenant tenant = new org.wso2.carbon.user.core.tenant.Tenant();
        tenant.setActive(stubTenant.getActive());
        tenant.setAdminName(stubTenant.getAdminName());
        tenant.setAdminPassword(stubTenant.getAdminPassword());
        tenant.setDomain(stubTenant.getDomain());
        tenant.setEmail(stubTenant.getEmail());
        tenant.setId(stubTenant.getId());
        return tenant;
    }

    private Tenant tenantToADBTenant(org.wso2.carbon.user.core.tenant.Tenant tenant) {
        Tenant stubTenant = new Tenant();
        stubTenant.setActive(tenant.isActive());
        stubTenant.setAdminName(tenant.getAdminName());
        stubTenant.setAdminPassword(tenant.getAdminPassword());
        stubTenant.setDomain(tenant.getDomain());
        stubTenant.setEmail(tenant.getEmail());
        stubTenant.setId(tenant.getId());
        return stubTenant;
    }

    private RemoteTenantManagerServiceStub getStub() throws org.wso2.carbon.user.core.UserStoreException {
        if (this.stub == null) {
            try {
                this.stub = new RemoteTenantManagerServiceStub(UserMgtWSAPIDSComponent.getCcServiceInstance().getClientConfigContext(), this.url + SERVICE_NAME);
                ServiceClient client = this.stub._getServiceClient();
                Options option = client.getOptions();
                option.setManageSession(true);
                LoginSender sender = new LoginSender();
                String sessionCookie = sender.login();
                if (sessionCookie == null) {
                    throw new org.wso2.carbon.user.core.UserStoreException(SERVER_LOGIN_ERROR);
                }
                option.setProperty("Cookie", (Object)sessionCookie);
            }
            catch (AxisFault axisFault) {
                throw new org.wso2.carbon.user.core.UserStoreException("Axis error occurred while creating service client stub", (Throwable)axisFault);
            }
        }
        return this.stub;
    }

    public void initializeExistingPartitions() {
    }

    private class LoginSender
    extends TimerTask {
        private static final String ERROR_MESSAGE = "Logging in to Tenant Manager";
        private static final String DEFAULT_LOCALHOST = "127.0.0.1";

        private LoginSender() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                RemoteTenantManagerServiceStub remoteTenantManagerServiceStub = WSRealmTenantManager.this.stub;
                synchronized (remoteTenantManagerServiceStub) {
                    String sessionCookie = this.login();
                    ServiceClient client = WSRealmTenantManager.this.stub._getServiceClient();
                    Options option = client.getOptions();
                    option.setManageSession(true);
                    option.setProperty("Cookie", (Object)sessionCookie);
                }
            }
            catch (org.wso2.carbon.user.core.UserStoreException e) {
                log.error((Object)ERROR_MESSAGE, (Throwable)e);
            }
        }

        public String login() throws org.wso2.carbon.user.core.UserStoreException {
            try {
                RemoteTenantManagerServiceStub remoteTenantManagerServiceStub = WSRealmTenantManager.this.stub;
                synchronized (remoteTenantManagerServiceStub) {
                    AuthenticationAdminClient client = new AuthenticationAdminClient(UserMgtWSAPIDSComponent.getCcServiceInstance().getClientConfigContext(), WSRealmTenantManager.this.url, null, null, false);
                    boolean isLogin = client.login(WSRealmTenantManager.this.userName, WSRealmTenantManager.this.password, DEFAULT_LOCALHOST);
                    if (isLogin) {
                        return client.getAdminCookie();
                    }
                    throw new org.wso2.carbon.user.core.UserStoreException(ERROR_MESSAGE);
                }
            }
            catch (Exception e) {
                throw new org.wso2.carbon.user.core.UserStoreException(ERROR_MESSAGE, (Throwable)e);
            }
        }
    }
}

