/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.um.ws.api;

import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.um.ws.api.WSRealmUtil;
import org.wso2.carbon.um.ws.api.stub.RemoteProfileConfigurationManagerServiceStub;
import org.wso2.carbon.user.api.ProfileConfiguration;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.profile.ProfileConfigurationManager;

public class WSProfileConfigurationManager
implements ProfileConfigurationManager {
    private static final Log log = LogFactory.getLog(WSProfileConfigurationManager.class);
    private RemoteProfileConfigurationManagerServiceStub stub = null;
    private static final String SERVICE_NAME = "RemoteProfileConfigurationManagerService";
    private static final String CONNECTION_ERROR_MESSAGE = "Error while establishing web service connection ";

    public WSProfileConfigurationManager(String serverUrl, String cookie, ConfigurationContext configCtxt) throws org.wso2.carbon.user.core.UserStoreException {
        try {
            this.stub = new RemoteProfileConfigurationManagerServiceStub(configCtxt, serverUrl + SERVICE_NAME);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault e) {
            throw new org.wso2.carbon.user.core.UserStoreException("Axis error occurred while creating service client stub", (Throwable)e);
        }
    }

    public void addProfileConfig(org.wso2.carbon.user.core.profile.ProfileConfiguration profileConfig) throws org.wso2.carbon.user.core.UserStoreException {
        try {
            this.stub.addProfileConfig(WSRealmUtil.convertToADBProfileConfiguration(profileConfig));
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public void deleteProfileConfig(org.wso2.carbon.user.core.profile.ProfileConfiguration profileConfig) throws org.wso2.carbon.user.core.UserStoreException {
        try {
            this.stub.deleteProfileConfig(WSRealmUtil.convertToADBProfileConfiguration(profileConfig));
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public void updateProfileConfig(org.wso2.carbon.user.core.profile.ProfileConfiguration profileConfig) throws org.wso2.carbon.user.core.UserStoreException {
        try {
            this.stub.updateProfileConfig(WSRealmUtil.convertToADBProfileConfiguration(profileConfig));
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public org.wso2.carbon.user.core.profile.ProfileConfiguration[] getAllProfiles() throws org.wso2.carbon.user.core.UserStoreException {
        try {
            return WSRealmUtil.convertToProfileConfigurations(this.stub.getAllProfiles());
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return new org.wso2.carbon.user.core.profile.ProfileConfiguration[0];
        }
    }

    public org.wso2.carbon.user.core.profile.ProfileConfiguration getProfileConfig(String profileName) throws org.wso2.carbon.user.core.UserStoreException {
        try {
            return WSRealmUtil.convertToProfileConfiguration(this.stub.getProfileConfig(profileName));
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return null;
        }
    }

    public void addProfileConfig(ProfileConfiguration profileConfiguration) throws UserStoreException {
        if (profileConfiguration instanceof org.wso2.carbon.user.core.profile.ProfileConfiguration) {
            this.addProfileConfig((org.wso2.carbon.user.core.profile.ProfileConfiguration)profileConfiguration);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"profileConfiguration is not an instance of ProfileConfiguration. So addProfileConfig operation is skipped");
        }
    }

    public void updateProfileConfig(ProfileConfiguration profileConfiguration) throws UserStoreException {
        if (profileConfiguration instanceof org.wso2.carbon.user.core.profile.ProfileConfiguration) {
            this.updateProfileConfig((org.wso2.carbon.user.core.profile.ProfileConfiguration)profileConfiguration);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"profileConfiguration is not an instance of ProfileConfiguration. So updateProfileConfig operation is skipped");
        }
    }

    public void deleteProfileConfig(ProfileConfiguration profileConfiguration) throws UserStoreException {
        if (profileConfiguration instanceof org.wso2.carbon.user.core.profile.ProfileConfiguration) {
            this.deleteProfileConfig((org.wso2.carbon.user.core.profile.ProfileConfiguration)profileConfiguration);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"profileConfiguration is not an instance of ProfileConfiguration. So deleteProfileConfig operation is skipped");
        }
    }

    private String[] handleException(String msg, Exception e) throws org.wso2.carbon.user.core.UserStoreException {
        log.error((Object)e.getMessage(), (Throwable)e);
        throw new org.wso2.carbon.user.core.UserStoreException(msg, (Throwable)e);
    }
}

