/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.um.ws.api;

import java.rmi.RemoteException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.um.ws.api.WSRealmUtil;
import org.wso2.carbon.um.ws.api.stub.ClaimMapping;
import org.wso2.carbon.um.ws.api.stub.RemoteClaimManagerServiceStub;
import org.wso2.carbon.um.ws.api.stub.RemoteClaimManagerServiceUserStoreExceptionException;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.claim.Claim;
import org.wso2.carbon.user.core.claim.ClaimManager;

public class WSClaimManager
implements ClaimManager {
    private static final Log log = LogFactory.getLog(WSClaimManager.class);
    private RemoteClaimManagerServiceStub stub = null;
    private static final String SERVICE_NAME = "RemoteClaimManagerService";
    private static final String CONNECTION_ERROR_MESSAGE = "Error while establishing web service connection ";

    public WSClaimManager(String serverUrl, String cookie, ConfigurationContext configCtxt) throws org.wso2.carbon.user.core.UserStoreException {
        try {
            this.stub = new RemoteClaimManagerServiceStub(configCtxt, serverUrl + SERVICE_NAME);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault e) {
            throw new org.wso2.carbon.user.core.UserStoreException("Axis error occurred while creating service client stub", (Throwable)e);
        }
    }

    public void addNewClaimMapping(org.wso2.carbon.user.api.ClaimMapping mapping) throws org.wso2.carbon.user.core.UserStoreException {
        try {
            ClaimMapping claimMapping = WSRealmUtil.convertToADBClaimMapping(mapping);
            this.stub.addNewClaimMapping(claimMapping);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public void deleteClaimMapping(org.wso2.carbon.user.api.ClaimMapping mapping) throws org.wso2.carbon.user.core.UserStoreException {
        try {
            ClaimMapping claimMapping = WSRealmUtil.convertToADBClaimMapping(mapping);
            this.stub.deleteClaimMapping(claimMapping);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public String[] getAllClaimUris() throws org.wso2.carbon.user.core.UserStoreException {
        try {
            return this.stub.getAllClaimUris();
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return new String[0];
        }
    }

    public String getAttributeName(String claimURI) throws org.wso2.carbon.user.core.UserStoreException {
        try {
            return this.stub.getAttributeName(claimURI);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return null;
        }
    }

    public Claim getClaim(String claimURI) throws org.wso2.carbon.user.core.UserStoreException {
        try {
            return WSRealmUtil.convertToClaim(this.stub.getClaim(claimURI));
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return null;
        }
    }

    public org.wso2.carbon.user.api.ClaimMapping getClaimMapping(String claimURI) throws org.wso2.carbon.user.core.UserStoreException {
        try {
            return WSRealmUtil.convertToClaimMapping(this.stub.getClaimMapping(claimURI));
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return null;
        }
    }

    public void updateClaimMapping(org.wso2.carbon.user.api.ClaimMapping mapping) throws org.wso2.carbon.user.core.UserStoreException {
        try {
            this.stub.updateClaimMapping(WSRealmUtil.convertToADBClaimMapping(mapping));
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    private String[] handleException(String msg, Exception e) throws org.wso2.carbon.user.core.UserStoreException {
        log.error((Object)e.getMessage(), (Throwable)e);
        throw new org.wso2.carbon.user.core.UserStoreException(msg, (Throwable)e);
    }

    public String getAttributeName(String domainName, String claimURI) throws UserStoreException {
        try {
            return this.stub.getAttributeNameFromDomain(domainName, claimURI);
        }
        catch (RemoteException e) {
            this.handleException(e.getMessage(), e);
        }
        catch (RemoteClaimManagerServiceUserStoreExceptionException e) {
            this.handleException(e.getMessage(), e);
        }
        return null;
    }

    public org.wso2.carbon.user.api.ClaimMapping[] getAllSupportClaimMappingsByDefault() throws UserStoreException {
        try {
            return WSRealmUtil.convertToClaimMappings(this.stub.getAllSupportClaimMappingsByDefault());
        }
        catch (RemoteException e) {
            this.handleException(e.getMessage(), e);
        }
        catch (RemoteClaimManagerServiceUserStoreExceptionException e) {
            this.handleException(e.getMessage(), e);
        }
        return new org.wso2.carbon.user.api.ClaimMapping[0];
    }

    public org.wso2.carbon.user.api.ClaimMapping[] getAllClaimMappings() throws UserStoreException {
        try {
            return WSRealmUtil.convertToClaimMappings(this.stub.getAllClaimMappings(null));
        }
        catch (RemoteException e) {
            this.handleException(e.getMessage(), e);
        }
        catch (RemoteClaimManagerServiceUserStoreExceptionException e) {
            this.handleException(e.getMessage(), e);
        }
        return new org.wso2.carbon.user.api.ClaimMapping[0];
    }

    public org.wso2.carbon.user.api.ClaimMapping[] getAllClaimMappings(String dialectURI) throws UserStoreException {
        try {
            return WSRealmUtil.convertToClaimMappings(this.stub.getAllClaimMappings(null));
        }
        catch (RemoteException e) {
            this.handleException(e.getMessage(), e);
        }
        catch (RemoteClaimManagerServiceUserStoreExceptionException e) {
            this.handleException(e.getMessage(), e);
        }
        return new org.wso2.carbon.user.api.ClaimMapping[0];
    }

    public org.wso2.carbon.user.api.ClaimMapping[] getAllRequiredClaimMappings() throws UserStoreException {
        try {
            return WSRealmUtil.convertToClaimMappings(this.stub.getAllRequiredClaimMappings());
        }
        catch (RemoteException e) {
            this.handleException(e.getMessage(), e);
        }
        catch (RemoteClaimManagerServiceUserStoreExceptionException e) {
            this.handleException(e.getMessage(), e);
        }
        return new org.wso2.carbon.user.api.ClaimMapping[0];
    }
}

