/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.um.ws.service.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.um.ws.service.internal.UMRemoteServicesDataHolder;
import org.wso2.carbon.user.core.service.RealmService;

@Component(name="remote.um.service.component", immediate=true)
public class UMRemoteServicesDSComponent {
    private static final Log log = LogFactory.getLog(UMRemoteServicesDSComponent.class);
    private static final String ACTIVATION_MESSAGE = "Remote User Mgt bundle is activated ";
    private static final String UNSETTING_MESSAGE = "Unsetting the Realm service ";

    public static RegistryService getRegistryService() {
        return UMRemoteServicesDataHolder.getInstance().getRegistryService();
    }

    @Reference(name="registry.service", service=RegistryService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService registryService) {
        UMRemoteServicesDataHolder.getInstance().setRegistryService(registryService);
    }

    public static RealmService getRealmService() {
        return UMRemoteServicesDataHolder.getInstance().getRealmService();
    }

    @Reference(name="user.realmservice.default", service=RealmService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the Realm Service");
        }
        UMRemoteServicesDataHolder.getInstance().setRealmService(realmService);
    }

    @Activate
    protected void activate(ComponentContext ctxt) {
        log.debug((Object)ACTIVATION_MESSAGE);
    }

    @Deactivate
    protected void deactivate(ComponentContext ctxt) {
    }

    protected void unsetRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)UNSETTING_MESSAGE);
        }
        UMRemoteServicesDataHolder.getInstance().setRealmService(null);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        UMRemoteServicesDataHolder.getInstance().setRegistryService(null);
    }
}

