/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.application.mgt.synapse.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.application.deployer.service.ApplicationManagerService;
import org.wso2.carbon.mediation.initializer.services.SynapseConfigurationService;
import org.wso2.carbon.registry.core.service.RegistryService;

@Component(name="application.mgt.synapse.dscomponent", immediate=true)
public class SynapseAppServiceComponent {
    private static Log log = LogFactory.getLog(SynapseAppServiceComponent.class);
    private static RegistryService registryServiceInstance;
    private static SynapseConfigurationService scService;
    private static ApplicationManagerService applicationManager;

    @Activate
    protected void activate(ComponentContext ctxt) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Activated SynapseAppServiceComponent");
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext ctxt) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Deactivated SynapseAppServiceComponent");
        }
    }

    @Reference(name="registry.service", service=RegistryService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService registryService) {
        registryServiceInstance = registryService;
    }

    protected void unsetRegistryService(RegistryService registryService) {
        registryServiceInstance = null;
    }

    @Reference(name="synapse.config.service", service=SynapseConfigurationService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetSynapseConfigurationService")
    protected void setSynapseConfigurationService(SynapseConfigurationService synapseConfigurationService) {
        scService = synapseConfigurationService;
    }

    protected void unsetSynapseConfigurationService(SynapseConfigurationService synapseConfigurationService) {
        scService = null;
    }

    @Reference(name="application.manager", service=ApplicationManagerService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetAppManager")
    protected void setAppManager(ApplicationManagerService appManager) {
        applicationManager = appManager;
    }

    protected void unsetAppManager(ApplicationManagerService appManager) {
        applicationManager = null;
    }

    public static ApplicationManagerService getAppManager() throws Exception {
        if (applicationManager == null) {
            String msg = "Before activating Synapse App management service bundle, an instance of ApplicationManager should be in existance";
            log.error((Object)msg);
            throw new Exception(msg);
        }
        return applicationManager;
    }

    public static RegistryService getRegistryService() throws Exception {
        if (registryServiceInstance == null) {
            String msg = "Before activating Synapse App management service bundle, an instance of RegistryService should be in existance";
            log.error((Object)msg);
            throw new Exception(msg);
        }
        return registryServiceInstance;
    }

    public static SynapseConfigurationService getScService() throws Exception {
        if (scService == null) {
            String msg = "Before activating Synapse App management service bundle, an instance of SynapseConfigurationService should be in existance";
            log.error((Object)msg);
            throw new Exception(msg);
        }
        return scService;
    }
}

