/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.cloud.gateway.service;

import java.net.SocketException;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.transport.TransportSender;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.cloud.gateway.common.CGException;
import org.wso2.carbon.cloud.gateway.common.CGProxyToolsURLs;
import org.wso2.carbon.cloud.gateway.common.CGServiceDependencyBean;
import org.wso2.carbon.cloud.gateway.common.CGServiceMetaDataBean;
import org.wso2.carbon.cloud.gateway.common.CGThriftServerBean;
import org.wso2.carbon.cloud.gateway.common.CGUtils;
import org.wso2.carbon.cloud.gateway.transport.CGTransportSender;
import org.wso2.carbon.mediation.initializer.AbstractServiceBusAdmin;
import org.wso2.carbon.proxyadmin.Entry;
import org.wso2.carbon.proxyadmin.ProxyAdminException;
import org.wso2.carbon.proxyadmin.ProxyData;
import org.wso2.carbon.proxyadmin.service.ProxyServiceAdmin;
import org.wso2.carbon.registry.api.RegistryException;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.jdbc.utils.Transaction;
import org.wso2.carbon.service.mgt.ServiceAdmin;
import org.wso2.carbon.service.mgt.ServiceMetaData;

public class CGAdminService
extends AbstractServiceBusAdmin {
    private static final Log log = LogFactory.getLog(CGAdminService.class);

    public void deployProxy(CGServiceMetaDataBean metaData) throws CGException {
        if (metaData == null) {
            this.handleException("CG Service meta data is null");
        }
        try {
            ProxyData proxyData = this.createProxyData(metaData);
            new ProxyServiceAdmin().addProxy(proxyData);
            if (this.getAxisConfig().getTransportOut("cg") == null) {
                this.enableCGTransportSender(this.getAxisConfig());
            }
        }
        catch (Exception e) {
            this.handleException("Could not deploy the CG service '" + metaData.getServiceName() + "'. " + e.getMessage(), e);
        }
    }

    public void unDeployProxy(String serviceName) throws CGException {
        if (serviceName == null) {
            this.handleException("CG service(proxy service) name is null");
        }
        try {
            new ProxyServiceAdmin().deleteProxyService(serviceName);
            this.deleteWSDLResources(serviceName);
        }
        catch (ProxyAdminException e) {
            this.handleException("Could not delete the CG service '" + serviceName + "'. " + e.getMessage(), e);
        }
    }

    public CGThriftServerBean getThriftServerConnectionBean() throws CGException {
        CGThriftServerBean bean;
        try {
            String hostName = CGUtils.getCGThriftServerHostName();
            int port = CGUtils.getCGThriftServerPort();
            int timeOut = CGUtils.getIntProperty("cg-thrift-timeout", 900000);
            if (!CGUtils.isServerAlive(hostName, port)) {
                this.handleException("Thrift server is not running on the host '" + hostName + "' in port '" + port + "'");
            }
            bean = new CGThriftServerBean();
            bean.setHostName(hostName);
            bean.setPort(port);
            bean.setTimeOut(timeOut);
        }
        catch (SocketException e) {
            throw new CGException(e);
        }
        return bean;
    }

    public void updateProxy(String serviceName, int eventType) throws CGException {
        ProxyServiceAdmin proxyAdmin = new ProxyServiceAdmin();
        try {
            if (eventType == 0) {
                proxyAdmin.deleteProxyService(serviceName);
            } else if (eventType == 3) {
                proxyAdmin.startProxyService(serviceName);
            } else if (eventType == 2) {
                proxyAdmin.stopProxyService(serviceName);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("The event SERVICE_DEPLOY is supported for the service '" + serviceName + "'"));
            }
        }
        catch (ProxyAdminException e) {
            this.handleException("Could not update service proxy service '" + serviceName + "'", e);
        }
    }

    public CGProxyToolsURLs getPublishedProxyToolsURLs(String serviceName, String domainName) throws CGException {
        try {
            CGProxyToolsURLs tools = new CGProxyToolsURLs();
            ServiceMetaData data = new ServiceAdmin().getServiceData(serviceName);
            tools.setTryItURL(data.getTryitURL());
            tools.setWsdl11URL(data.getWsdlURLs()[0]);
            tools.setWsdl2URL(data.getWsdlURLs()[1]);
            tools.setEprArray(data.getEprs());
            return tools;
        }
        catch (Exception e) {
            this.handleException("Could not read the proxy service URL for the service '" + serviceName + "', for the domain '" + domainName + "'", e);
            return null;
        }
    }

    private ProxyData createProxyData(CGServiceMetaDataBean proxyMetaData) throws CGException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating the proxy data with following metadata");
            log.debug((Object)("Service Name : " + proxyMetaData.getServiceName()));
            log.debug((Object)("CGTransport endpoint : " + proxyMetaData.getEndpoint()));
            log.debug((Object)("Has In Out operations? : " + proxyMetaData.isHasInOutMEP()));
            log.debug((Object)("Enable MTOM? : " + proxyMetaData.isMTOMEnabled()));
            log.debug((Object)("Has WS-Sec enabled ? : " + proxyMetaData.isWsSecEnabled()));
            log.debug((Object)("Has WS-RM enabled ? : " + proxyMetaData.isWsRmEnabled()));
            if (proxyMetaData.isWsSecEnabled()) {
                log.debug((Object)("WS-Sec policy : \n" + proxyMetaData.getSecPolicy()));
            }
            if (proxyMetaData.isWsRmEnabled()) {
                log.debug((Object)("WS-RM policy : \n" + proxyMetaData.getRmPolicy()));
            }
            log.debug((Object)("WSDL location : " + proxyMetaData.getWsdlLocation()));
            log.debug((Object)("WSDL : \n" + proxyMetaData.getInLineWSDL()));
            if (proxyMetaData.getServiceDependencies() != null && proxyMetaData.getServiceDependencies().length > 0) {
                for (CGServiceDependencyBean dependencyBean : proxyMetaData.getServiceDependencies()) {
                    log.debug((Object)("Dependency Key : " + dependencyBean.getKey()));
                    log.debug((Object)("Dependency Content : \n" + dependencyBean.getContent()));
                }
            }
        }
        ProxyData proxy = new ProxyData();
        proxy.setName(proxyMetaData.getServiceName());
        if (proxyMetaData.getInLineWSDL() != null) {
            String persistedWsdlPath = this.persistWSDL(proxyMetaData.getServiceName(), proxyMetaData.getInLineWSDL(), proxyMetaData.getServiceDependencies());
            proxy.setWsdlKey(persistedWsdlPath);
            if (!ArrayUtils.isEmpty((Object[])proxyMetaData.getServiceDependencies())) {
                CGServiceDependencyBean[] dependencies = proxyMetaData.getServiceDependencies();
                Entry[] resourceEntries = new Entry[proxyMetaData.getServiceDependencies().length];
                for (int i = 0; i < resourceEntries.length; ++i) {
                    resourceEntries[i] = new Entry(dependencies[i].getKey(), this.composeServiceResourcesPath(proxyMetaData.getServiceName()) + dependencies[i].getKey());
                }
                proxy.setWsdlResources(resourceEntries);
            }
        }
        String inSeq = "<inSequence xmlns=\"http://ws.apache.org/ns/synapse\"><class name=\"org.wso2.carbon.cloud.gateway.CGMEPHandlingMediator\"/><property name=\"transportNonBlocking\" scope=\"axis2\" action=\"remove\"/><property name=\"preserveProcessedHeaders\" value=\"true\"/>";
        if (proxyMetaData.isHasInOutMEP()) {
            proxy.setOutSeqXML("<outSequence xmlns=\"http://ws.apache.org/ns/synapse\"><send/></outSequence>");
        } else {
            inSeq = inSeq + "<property name=\"OUT_ONLY\" scope=\"axis2\" action=\"set\" value=\"true\"/>";
        }
        inSeq = inSeq + "</inSequence>";
        proxy.setInSeqXML(inSeq);
        proxy.setFaultSeqXML("<faultSequence xmlns=\"http://ws.apache.org/ns/synapse\"><log level=\"full\"/><drop/></faultSequence>");
        String endpointXML = "<endpoint xmlns=\"http://ws.apache.org/ns/synapse\"><address uri=\"" + proxyMetaData.getEndpoint() + "\"><suspendOnFailure><errorCodes>400207</errorCodes><initialDuration>1000</initialDuration><progressionFactor>2</progressionFactor><maximumDuration>64000</maximumDuration></suspendOnFailure></address></endpoint>";
        proxy.setEndpointXML(endpointXML);
        return proxy;
    }

    private void handleException(String msg) throws CGException {
        log.error((Object)msg);
        throw new CGException(msg);
    }

    private void handleException(String msg, Throwable t) throws CGException {
        log.error((Object)msg, t);
        throw new CGException(msg, t);
    }

    private void enableCGTransportSender(AxisConfiguration axisConfig) throws Exception {
        CGTransportSender sender = new CGTransportSender();
        TransportOutDescription transportOut = new TransportOutDescription("cg");
        transportOut.setSender((TransportSender)sender);
        axisConfig.addTransportOut(transportOut);
        transportOut.getSender().init(this.getConfigContext(), transportOut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String persistWSDL(String serviceName, String wsdl, CGServiceDependencyBean[] dependencies) throws CGException {
        boolean isTransactionAlreadyStarted = Transaction.isStarted();
        boolean isTransactionSuccess = true;
        Registry registry = this.getGovernanceUserRegistry();
        String serviceResourcesPath = this.composeServiceResourcesPath(serviceName);
        String wsdlPath = serviceResourcesPath + serviceName + ".wsdl";
        try {
            if (!isTransactionAlreadyStarted) {
                registry.beginTransaction();
            }
            if (registry.resourceExists(serviceResourcesPath)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Replacing the Wsdl for the service: " + serviceName));
                }
                registry.delete(serviceResourcesPath);
            }
            Resource resource = registry.newResource();
            resource.setContent((Object)wsdl);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding wsdl to registry. Service name: " + serviceName));
            }
            registry.put(wsdlPath, (org.wso2.carbon.registry.api.Resource)resource);
            if (!ArrayUtils.isEmpty((Object[])dependencies)) {
                for (CGServiceDependencyBean dependency : dependencies) {
                    Resource dependencyResource = registry.newResource();
                    dependencyResource.setContent((Object)dependency.getContent());
                    registry.put(serviceResourcesPath + dependency.getKey(), (org.wso2.carbon.registry.api.Resource)dependencyResource);
                }
            }
        }
        catch (RegistryException e) {
            isTransactionSuccess = false;
            this.handleException("Error occurred while saving the wsdl into registry", e);
        }
        finally {
            if (!isTransactionAlreadyStarted) {
                try {
                    if (isTransactionSuccess) {
                        registry.commitTransaction();
                    } else {
                        registry.rollbackTransaction();
                    }
                }
                catch (RegistryException re) {
                    this.handleException("Error occurred while trying to rollback or commit the transaction", re);
                }
            }
        }
        return wsdlPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteWSDLResources(String serviceName) throws CGException {
        boolean isTransactionAlreadyStarted = Transaction.isStarted();
        boolean isTransactionSuccess = true;
        Registry registry = this.getGovernanceUserRegistry();
        String resourcePath = this.composeServiceResourcesPath(serviceName);
        try {
            if (!isTransactionAlreadyStarted) {
                registry.beginTransaction();
            }
            if (registry.resourceExists(resourcePath)) {
                registry.delete(resourcePath);
            }
        }
        catch (RegistryException e) {
            isTransactionSuccess = false;
            this.handleException("Error occurred while deleting the wsdl from registry", e);
        }
        finally {
            if (!isTransactionAlreadyStarted) {
                try {
                    if (isTransactionSuccess) {
                        registry.commitTransaction();
                    } else {
                        registry.rollbackTransaction();
                    }
                }
                catch (RegistryException re) {
                    this.handleException("Error occurred while trying to rollback or commit the transaction", re);
                }
            }
        }
    }

    public String composeServiceResourcesPath(String serviceName) {
        return "/trunk/services/wsdls" + "/" + serviceName + "/";
    }
}

