/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.cloud.gateway.transport;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.transport.OutTransportInfo;
import org.apache.axis2.transport.base.AbstractTransportSender;
import org.apache.axis2.transport.base.BaseUtils;
import org.apache.axis2.transport.base.threads.WorkerPool;
import org.apache.axis2.transport.base.threads.WorkerPoolFactory;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.cloud.gateway.common.CGUtils;
import org.wso2.carbon.cloud.gateway.common.thrift.gen.Message;
import org.wso2.carbon.cloud.gateway.transport.server.CGThriftServerHandler;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.relay.BinaryRelayBuilder;
import org.wso2.carbon.relay.ExpandingMessageFormatter;

public class CGTransportSender
extends AbstractTransportSender {
    private long semaphoreTimeOut;
    private ScheduledExecutorService deadMsgCleanupScheduler;
    private WorkerPool workerPool;
    private BinaryRelayBuilder builder;
    private ExpandingMessageFormatter formatter;
    private static Log log = LogFactory.getLog(CGTransportSender.class);

    public void init(ConfigurationContext cfgCtx, TransportOutDescription transportOut) throws AxisFault {
        super.init(cfgCtx, transportOut);
        this.builder = new BinaryRelayBuilder();
        this.formatter = new ExpandingMessageFormatter();
        this.semaphoreTimeOut = CGUtils.getLongProperty("cg-so-timeout", 86400L);
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        String groupName = "CGTransportSender-tenant-" + tenantId + "-worker-thread-group";
        String groupId = "CGTransportSender-tenant-" + tenantId + "-worker";
        this.workerPool = WorkerPoolFactory.getWorkerPool((int)CGUtils.getIntProperty("cg-t-core", 20), (int)CGUtils.getIntProperty("cg-t-max", 500), (int)CGUtils.getIntProperty("cg-t-alive-sec", 5), (int)CGUtils.getIntProperty("cg-t-qlen", -1), (String)groupName, (String)groupId);
        String timeUnitAsString = CGUtils.getStringProperty("cg-time-unit", "hour");
        long noOfSchedulerTimeUnits = CGUtils.getLongProperty("no-of-cg-scheduler-time-units", 24L);
        long noOfIdleMessageUnits = CGUtils.getLongProperty("no-of-idle-msg-time-units", 24L);
        CGTransportSender.checkSchedulePreConditions(timeUnitAsString, noOfIdleMessageUnits, noOfSchedulerTimeUnits);
        TimeUnit schedulerTimeUnit = CGTransportSender.getTimeUnit(timeUnitAsString);
        this.deadMsgCleanupScheduler = Executors.newSingleThreadScheduledExecutor();
        this.deadMsgCleanupScheduler.scheduleWithFixedDelay(new DeadMessageCleanupTask(CGThriftServerHandler.getRequestBuffers(), CGTransportSender.getDurationAsMillisecond(schedulerTimeUnit, noOfIdleMessageUnits)), noOfSchedulerTimeUnits, noOfSchedulerTimeUnits, schedulerTimeUnit);
        int noOfDispatchingTask = CGUtils.getIntProperty("cg-no-of-dispatch-worker", 2);
        for (int i = 0; i < noOfDispatchingTask; ++i) {
            this.workerPool.execute((Runnable)new ResponseMessageDispatchingTask());
        }
        log.info((Object)("CGTransportSender started for tenant [" + tenantId + "]..."));
    }

    public void cleanup(MessageContext msgContext) throws AxisFault {
        super.cleanup(msgContext);
        if (!this.deadMsgCleanupScheduler.isShutdown()) {
            this.deadMsgCleanupScheduler.shutdown();
        }
    }

    public void stop() {
        super.stop();
    }

    public void sendMessage(MessageContext msgContext, String targetEPR, OutTransportInfo outTransportInfo) throws AxisFault {
        block19: {
            try {
                boolean isOutIn;
                String requestMsgIdMsgId;
                Object headers;
                String endpointPrefix;
                String requestUri = (String)msgContext.getProperty("TransportInURL");
                if (requestUri == null) {
                    this.handleException("The request URI is null");
                }
                if ((endpointPrefix = (String)msgContext.getProperty("ENDPOINT_PREFIX")) == null) {
                    this.handleException("The ENDPOINT_PREFIX(EPR) is not found");
                }
                if ((headers = msgContext.getProperty("TRANSPORT_HEADERS")) == null) {
                    this.handleException("Transport headers are null");
                }
                if ((requestMsgIdMsgId = msgContext.getMessageID()) == null) {
                    requestMsgIdMsgId = UUID.randomUUID().toString();
                }
                Message thriftMsg = new Message();
                if (msgContext.isDoingMTOM()) {
                    thriftMsg.setIsDoingMTOM(msgContext.isDoingMTOM());
                    msgContext.setProperty("enableMTOM", (Object)"true");
                } else if (msgContext.isDoingSwA()) {
                    thriftMsg.setIsDoingSwA(msgContext.isDoingSwA());
                    msgContext.setProperty("enableSwA", (Object)"true");
                } else if (msgContext.isDoingREST()) {
                    thriftMsg.setIsDoingREST(msgContext.isDoingREST());
                }
                thriftMsg.setHttpMethod((String)msgContext.getProperty("HTTP_METHOD"));
                thriftMsg.setMessageId(requestMsgIdMsgId);
                thriftMsg.setEpoch(System.currentTimeMillis());
                thriftMsg.setRequestURI(requestUri);
                thriftMsg.setSoapAction(msgContext.getSoapAction());
                OMOutputFormat format = BaseUtils.getOMOutputFormat((MessageContext)msgContext);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                this.formatter.writeTo(msgContext, format, (OutputStream)out, false);
                thriftMsg.setMessage(out.toByteArray());
                String contentType = this.formatter.getContentType(msgContext, format, msgContext.getSoapAction());
                thriftMsg.setContentType(contentType);
                if (((Map)headers).containsKey("Content-Type")) {
                    ((Map)headers).put("Content-Type", contentType);
                }
                thriftMsg.setTransportHeaders((Map)headers);
                Semaphore available = null;
                String token = CGThriftServerHandler.getSecureUUID(endpointPrefix);
                if (token == null) {
                    this.handleException("No permission to access the server buffers");
                }
                if (isOutIn = this.waitForSynchronousResponse(msgContext)) {
                    available = new Semaphore(0, true);
                    CGThriftServerHandler.getSemaphoreMap().put(requestMsgIdMsgId, available);
                }
                CGThriftServerHandler.addRequestMessage(thriftMsg, token);
                try {
                    if (!isOutIn) break block19;
                    try {
                        available.tryAcquire(this.semaphoreTimeOut, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    CGThriftServerHandler.getSemaphoreMap().remove(requestMsgIdMsgId);
                    Message msg = CGThriftServerHandler.getMiddleBuffer().remove(requestMsgIdMsgId);
                    if (msg != null) {
                        this.handleSyncResponse(msgContext, msg, contentType);
                        break block19;
                    }
                    log.warn((Object)("The semaphore with id '" + requestMsgIdMsgId + "' was time out while waiting for a response, sending a fault to client.."));
                    this.sendFault(msgContext, new Exception("Times out occurs while waiting for a response"));
                }
                catch (Exception e) {
                    this.handleException("Could not process the response message", e);
                }
            }
            catch (Exception e) {
                this.handleException("Could not process the request message", e);
            }
        }
    }

    private void handleSyncResponse(MessageContext requestMsgCtx, Message message, String requestContentType) throws AxisFault {
        try {
            MessageContext responseMsgCtx = this.createResponseMessageContext(requestMsgCtx);
            responseMsgCtx.setProperty("messageType", requestMsgCtx.getProperty("messageType"));
            responseMsgCtx.setProperty("ContentType", requestMsgCtx.getProperty("ContentType"));
            if (message.isIsDoingMTOM()) {
                responseMsgCtx.setProperty("enableMTOM", (Object)"true");
            } else if (message.isIsDoingSwA()) {
                responseMsgCtx.setProperty("enableSwA", (Object)"true");
            }
            String contentType = message.getContentType();
            if (contentType == null) {
                contentType = this.inferContentType(requestContentType, responseMsgCtx);
            }
            ByteArrayInputStream inputStream = new ByteArrayInputStream(message.getMessage());
            SOAPEnvelope envelope = (SOAPEnvelope)this.builder.processDocument((InputStream)inputStream, contentType, responseMsgCtx);
            responseMsgCtx.setEnvelope(envelope);
            String charSetEnc = BuilderUtil.getCharSetEncoding((String)contentType);
            if (charSetEnc == null) {
                charSetEnc = "UTF-8";
            }
            responseMsgCtx.setProperty("CHARACTER_SET_ENCODING", (Object)(contentType.indexOf("; charset=") > 0 ? charSetEnc : "UTF-8"));
            responseMsgCtx.setProperty("TRANSPORT_HEADERS", message.getTransportHeaders());
            if (message.getSoapAction() != null) {
                responseMsgCtx.setSoapAction(message.getSoapAction());
            }
            AxisEngine.receive((MessageContext)responseMsgCtx);
        }
        catch (AxisFault axisFault) {
            this.handleException("Could not handle the response message ", (Exception)((Object)axisFault));
        }
    }

    private void sendFault(MessageContext msgContext, Exception e) {
        try {
            MessageContext faultContext = MessageContextBuilder.createFaultMessageContext((MessageContext)msgContext, (Throwable)e);
            faultContext.setProperty("ERROR_MESSAGE", (Object)e.getMessage());
            faultContext.setProperty("SENDING_FAULT", (Object)Boolean.TRUE);
            AxisEngine.sendFault((MessageContext)faultContext);
        }
        catch (AxisFault axisFault) {
            log.fatal((Object)"Could not create the fault message.", (Throwable)axisFault);
        }
    }

    private static TimeUnit getTimeUnit(String timeUnit) {
        if (timeUnit.equals("millisecond")) {
            return TimeUnit.MILLISECONDS;
        }
        if (timeUnit.equals("second")) {
            return TimeUnit.SECONDS;
        }
        if (timeUnit.equals("minute")) {
            return TimeUnit.MINUTES;
        }
        if (timeUnit.equals("hour")) {
            return TimeUnit.HOURS;
        }
        if (timeUnit.equals("day")) {
            return TimeUnit.DAYS;
        }
        return TimeUnit.DAYS;
    }

    private static void checkSchedulePreConditions(String timeUnits, long noOfIdleMsgTimeUnits, long noOfSchedulerTimeUnits) throws AxisFault {
        if (noOfIdleMsgTimeUnits > noOfSchedulerTimeUnits) {
            String msg = "A possible configuration error. The ScheduledExecutorService is configured to run once a every '" + noOfSchedulerTimeUnits + "' " + (noOfSchedulerTimeUnits == 1L ? timeUnits : timeUnits + "s") + " to sweep messages which are '" + noOfIdleMsgTimeUnits + "' " + (noOfIdleMsgTimeUnits == 1L ? timeUnits : timeUnits + "s") + "old. The scheduler may idle without doing any actual work!";
            log.error((Object)msg);
            throw new AxisFault(msg);
        }
    }

    private static long getDurationAsMillisecond(TimeUnit timeUnit, long duration) {
        if (timeUnit == TimeUnit.MILLISECONDS) {
            return TimeUnit.MILLISECONDS.toMillis(duration);
        }
        if (timeUnit == TimeUnit.SECONDS) {
            return TimeUnit.SECONDS.toMillis(duration);
        }
        if (timeUnit == TimeUnit.MINUTES) {
            return TimeUnit.MINUTES.toMillis(duration);
        }
        if (timeUnit == TimeUnit.HOURS) {
            return TimeUnit.HOURS.toMillis(duration);
        }
        if (timeUnit == TimeUnit.DAYS) {
            return TimeUnit.DAYS.toMillis(duration);
        }
        log.warn((Object)("TimeUnit type '" + (Object)((Object)timeUnit) + "' is not supported. Default TimeUnit will be assumed"));
        return TimeUnit.DAYS.toMillis(duration);
    }

    private String inferContentType(String requestContentType, MessageContext responseMsgCtx) {
        Object cTypeProperty = responseMsgCtx.getProperty("ContentType");
        if (cTypeProperty != null) {
            return cTypeProperty.toString();
        }
        Parameter cTypeParam = this.cfgCtx.getAxisConfiguration().getParameter("ContentType");
        if (cTypeParam != null) {
            return cTypeParam.getValue().toString();
        }
        if (requestContentType != null) {
            return requestContentType;
        }
        return "text/xml";
    }

    private static String calculateBufferKey(String fullEPR) {
        String[] split = fullEPR.substring(5).split("/");
        StringBuilder buf = new StringBuilder("cg://");
        buf.append(split[0]).append("/").append(split[1]);
        return buf.toString();
    }

    private class DeadMessageCleanupTask
    implements Runnable {
        private Map<String, BlockingQueue<Message>> requestMessageBuffers;
        private long idleMessageTime;

        private DeadMessageCleanupTask(Map<String, BlockingQueue<Message>> requestMessageBuffers, long idleMessageTime) {
            this.requestMessageBuffers = requestMessageBuffers;
            this.idleMessageTime = idleMessageTime;
        }

        @Override
        public void run() {
            long currentTime = System.currentTimeMillis();
            for (Map.Entry<String, BlockingQueue<Message>> entry : this.requestMessageBuffers.entrySet()) {
                BlockingQueue<Message> buffer = entry.getValue();
                Message msg = (Message)buffer.peek();
                while (msg != null && msg.getEpoch() + this.idleMessageTime > currentTime) {
                    String msgID = msg.getMessageId();
                    log.info((Object)("The cleaning up task is sweeping the message with id '" + msgID + "' and callback will be removed too."));
                    CGThriftServerHandler.getSemaphoreMap().remove(msgID);
                    buffer.remove();
                    msg = (Message)buffer.peek();
                }
            }
        }
    }

    private class ResponseMessageProcessingTask
    implements Runnable {
        private Message msg;

        private ResponseMessageProcessingTask(Message msg) {
            this.msg = msg;
        }

        @Override
        public void run() {
            String msgId = this.msg.getMessageId();
            Map<String, Semaphore> semaphoreMap = CGThriftServerHandler.getSemaphoreMap();
            Set<String> keySet = semaphoreMap.keySet();
            if (keySet.contains(msgId)) {
                CGThriftServerHandler.getMiddleBuffer().put(msgId, this.msg);
                Semaphore semaphore = semaphoreMap.get(msgId);
                semaphore.release();
            } else {
                log.warn((Object)("A response was received with id '" + msgId + "', but no registered call back found. Message will be ignored!"));
            }
        }
    }

    private class ResponseMessageDispatchingTask
    implements Runnable {
        private ResponseMessageDispatchingTask() {
        }

        @Override
        public void run() {
            while (true) {
                Message msg;
                if ((msg = CGThriftServerHandler.getResponseMessage()) == null) {
                    continue;
                }
                CGTransportSender.this.workerPool.execute((Runnable)new ResponseMessageProcessingTask(msg));
            }
        }
    }
}

