/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.cloud.gateway.transport.server;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TSSLTransportFactory;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportException;
import org.wso2.carbon.cloud.gateway.common.thrift.gen.CloudGatewayService;
import org.wso2.carbon.cloud.gateway.transport.server.CGThriftServerHandler;

public class CGThriftServer {
    private static Log log = LogFactory.getLog(CGThriftServer.class);
    private CGThriftServerHandler csgThriftServerHandler;
    private TServer server;

    public CGThriftServer(CGThriftServerHandler handler) {
        this.csgThriftServerHandler = handler;
    }

    public void start(String hostName, int port, int timeOut, String keyStorePath, String keyStorePassword, String trustStorePath, String trustStorePassword, String taskName) throws AxisFault {
        try {
            TSSLTransportFactory.TSSLTransportParameters params = new TSSLTransportFactory.TSSLTransportParameters();
            params.setKeyStore(keyStorePath, keyStorePassword);
            params.setTrustStore(trustStorePath, trustStorePassword);
            TServerSocket socket = TSSLTransportFactory.getServerSocket((int)port, (int)timeOut, (InetAddress)InetAddress.getByName(hostName), (TSSLTransportFactory.TSSLTransportParameters)params);
            CloudGatewayService.Processor<CGThriftServerHandler> processor = new CloudGatewayService.Processor<CGThriftServerHandler>(this.csgThriftServerHandler);
            TBinaryProtocol.Factory protocolFactory = new TBinaryProtocol.Factory();
            this.server = new TThreadPoolServer((TThreadPoolServer.Args)((TThreadPoolServer.Args)new TThreadPoolServer.Args((TServerTransport)socket).processor(processor)).inputProtocolFactory((TProtocolFactory)protocolFactory));
            log.info((Object)("Starting the Cloud Gateway Thrift server on host '" + hostName + "' on port '" + port + "'..."));
            new Thread((Runnable)new CGServerMainLoop(this.server), taskName).start();
        }
        catch (TTransportException e) {
            throw new AxisFault("TTransportException occurs", (Throwable)e);
        }
        catch (UnknownHostException e) {
            throw new AxisFault("Unknown host exception occurs", (Throwable)e);
        }
    }

    public void stop() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    public boolean isServerAlive() {
        return this.server != null && this.server.isServing();
    }

    private static class CGServerMainLoop
    implements Runnable {
        private TServer server;

        private CGServerMainLoop(TServer server) {
            this.server = server;
        }

        @Override
        public void run() {
            try {
                this.server.serve();
            }
            catch (Exception e) {
                throw new RuntimeException("Could not start the CGThrift server", e);
            }
        }
    }
}

