/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.cloud.gateway.transport.server;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import org.apache.axis2.AxisFault;
import org.apache.axis2.transport.base.threads.WorkerPool;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.thrift.TException;
import org.wso2.carbon.cloud.gateway.common.CGUtils;
import org.wso2.carbon.cloud.gateway.common.thrift.gen.CloudGatewayService;
import org.wso2.carbon.cloud.gateway.common.thrift.gen.Message;
import org.wso2.carbon.cloud.gateway.common.thrift.gen.NotAuthorizedException;
import org.wso2.carbon.core.common.AuthenticationException;
import org.wso2.carbon.core.services.authentication.AuthenticationAdmin;

public class CGThriftServerHandler
implements CloudGatewayService.Iface {
    private static Log log = LogFactory.getLog(CGThriftServerHandler.class);
    private WorkerPool workerPool;
    private static Map<String, Semaphore> semaphoreMap = new ConcurrentHashMap<String, Semaphore>();
    private static Map<String, Message> middleBuffer = new ConcurrentHashMap<String, Message>();
    private static Map<String, String> authorizedQueues = new ConcurrentHashMap<String, String>();
    private static Map<String, BlockingQueue<Message>> requestBuffers = new ConcurrentHashMap<String, BlockingQueue<Message>>();
    private static BlockingQueue<Message> responseBuffer = new LinkedBlockingQueue<Message>();

    public CGThriftServerHandler(WorkerPool workerPool) {
        this.workerPool = workerPool;
    }

    @Override
    public String login(String userName, String password, String queueName) throws NotAuthorizedException, TException {
        AuthenticationAdmin authAdmin = new AuthenticationAdmin();
        try {
            if (!authAdmin.login(userName, password, "localhost")) {
                throw new NotAuthorizedException("User '" + userName + "' not authorized to access buffers");
            }
        }
        catch (AuthenticationException e) {
            throw new NotAuthorizedException(e.getMessage());
        }
        SecureRandom rand = new SecureRandom();
        String token = Integer.toString(rand.nextInt());
        if (authorizedQueues.containsKey(queueName)) {
            String oldToken = authorizedQueues.get(queueName);
            authorizedQueues.remove(queueName);
            if (requestBuffers.containsKey(oldToken)) {
                BlockingQueue<Message> oldBuffer = requestBuffers.remove(oldToken);
                requestBuffers.put(token, new LinkedBlockingQueue<Message>(oldBuffer));
            }
        } else {
            requestBuffers.put(token, new LinkedBlockingQueue());
        }
        authorizedQueues.put(queueName, token);
        return token;
    }

    @Override
    public List<Message> exchange(List<Message> responseMessageList, int blockSize, String token) throws NotAuthorizedException, TException {
        BlockingQueue<Message> requestBuffer;
        if (!authorizedQueues.containsValue(token)) {
            throw new NotAuthorizedException("You don't have required permission to access the buffers");
        }
        if (responseMessageList.size() > 0) {
            this.workerPool.execute((Runnable)new MessageCopyTask(responseMessageList, responseBuffer));
        }
        ArrayList<Message> requestMsgList = new ArrayList<Message>();
        if (requestBuffers.size() > 0 && (requestBuffer = requestBuffers.get(token)) != null) {
            try {
                CGUtils.moveElements(requestBuffer, requestMsgList, blockSize);
            }
            catch (AxisFault axisFault) {
                log.error((Object)"Error while moving elements :", (Throwable)axisFault);
            }
        }
        return requestMsgList;
    }

    public static void addRequestMessage(Message msg, String token) throws AxisFault {
        try {
            BlockingQueue<Message> buffer = requestBuffers.get(token);
            if (buffer == null) {
                throw new AxisFault("The requested buffer is not found");
            }
            buffer.put(msg);
        }
        catch (Exception e) {
            throw new AxisFault(e.getMessage(), (Throwable)e);
        }
    }

    public static Message getResponseMessage() {
        try {
            return responseBuffer.take();
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    public BlockingQueue<Message> getRequestBuffer(String token) {
        return requestBuffers.get(token);
    }

    public static String getSecureUUID(String queueName) {
        return authorizedQueues.get(queueName);
    }

    public static Map<String, BlockingQueue<Message>> getRequestBuffers() {
        return requestBuffers;
    }

    public static void addNewRequestBuffer(String token) {
        requestBuffers.put(token, new LinkedBlockingQueue());
    }

    public static Map<String, Semaphore> getSemaphoreMap() {
        return semaphoreMap;
    }

    public static Map<String, Message> getMiddleBuffer() {
        return middleBuffer;
    }

    private class MessageCopyTask
    implements Runnable {
        private List<Message> src;
        private BlockingQueue<Message> dest;

        private MessageCopyTask(List<Message> src, BlockingQueue<Message> dest) {
            this.src = src;
            this.dest = dest;
        }

        @Override
        public void run() {
            this.copyElements(this.src, this.dest);
        }

        private void copyElements(List<Message> src, BlockingQueue<Message> dest) {
            dest.addAll(src);
        }
    }
}

