/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.cloud.gateway.common;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Socket;
import java.net.SocketException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSSLTransportFactory;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.cloud.gateway.common.CGConstant;
import org.wso2.carbon.cloud.gateway.common.thrift.gen.CloudGatewayService;
import org.wso2.carbon.cloud.gateway.common.thrift.gen.Message;
import org.wso2.carbon.core.util.CryptoException;
import org.wso2.carbon.core.util.CryptoUtil;
import org.wso2.carbon.utils.NetworkUtils;

public class CGUtils {
    private static final Log log = LogFactory.getLog(CGUtils.class);
    private static Properties prop = CGUtils.loadProperties("cg.properties");

    private CGUtils() {
    }

    public static CloudGatewayService.Client getCGThriftClient(String hostName, int port, int timeOut, String trustStorePath, String trustStorePassWord) {
        try {
            TSSLTransportFactory.TSSLTransportParameters params = new TSSLTransportFactory.TSSLTransportParameters();
            params.setTrustStore(trustStorePath, trustStorePassWord);
            TSocket transport = TSSLTransportFactory.getClientSocket((String)hostName, (int)port, (int)timeOut, (TSSLTransportFactory.TSSLTransportParameters)params);
            TBinaryProtocol protocol = new TBinaryProtocol((TTransport)transport);
            return new CloudGatewayService.Client((TProtocol)protocol);
        }
        catch (TTransportException e) {
            CGUtils.handleException("Could not initialize the Thrift client. " + e.getMessage(), e);
            return null;
        }
    }

    public static void moveElements(BlockingQueue<Message> src, List<Message> dest, int blockSize) throws AxisFault {
        try {
            src.drainTo(dest, blockSize);
        }
        catch (Exception e) {
            throw new AxisFault(e.getMessage(), (Throwable)e);
        }
    }

    public static String getKeyStoreFilePath() {
        return CGUtils.getStringProperty("cg-key-store-location", null) != null ? CGUtils.getStringProperty("cg-key-store-location", null) : CGUtils.getWSO2KeyStoreFilePath();
    }

    public static String getWSO2KeyStoreFilePath() {
        ServerConfiguration config = ServerConfiguration.getInstance();
        return config.getFirstProperty("Security.KeyStore.Location");
    }

    public static String getTrustStoreFilePath() {
        return CGUtils.getStringProperty("cg-trust-store-location", null) != null ? CGUtils.getStringProperty("cg-trust-store-location", null) : CGUtils.getWSO2TrustStoreFilePath();
    }

    public static String getWSO2TrustStoreFilePath() {
        ServerConfiguration config = ServerConfiguration.getInstance();
        return config.getFirstProperty("Security.TrustStore.Location");
    }

    public static String getKeyStorePassWord() {
        return CGUtils.getStringProperty("cg-key-store-password", null) != null ? CGUtils.getStringProperty("cg-key-store-password", null) : CGUtils.getWSO2KeyStorePassword();
    }

    public static String getWSO2KeyStorePassword() {
        ServerConfiguration config = ServerConfiguration.getInstance();
        String password = config.getFirstProperty("Security.KeyStore.KeyPassword");
        if (password == null) {
            password = "wso2carbon";
        }
        return password;
    }

    public static String getTrustStorePassWord() {
        return CGUtils.getStringProperty("cg-trust-store-password", null) != null ? CGUtils.getStringProperty("cg-trust-store-password", null) : CGUtils.getWSO2TrustStorePassword();
    }

    public static String getWSO2TrustStorePassword() {
        ServerConfiguration config = ServerConfiguration.getInstance();
        String password = config.getFirstProperty("Security.TrustStore.Password");
        if (password == null) {
            password = "wso2carbon";
        }
        return password;
    }

    public static void handleException(String msg, Throwable t) {
        log.error((Object)msg, t);
        throw new RuntimeException(msg, t);
    }

    public static String getStringProperty(String name, String def) {
        String val = System.getProperty(name);
        return val == null ? (prop.get(name) == null ? def : (String)prop.get(name)) : val;
    }

    public static int getIntProperty(String name, int def) {
        String val = System.getProperty(name);
        return val == null ? (prop.get(name) == null ? def : Integer.parseInt((String)prop.get(name))) : Integer.parseInt(val);
    }

    public static long getLongProperty(String name, long def) {
        String val = System.getProperty(name);
        return val == null ? (prop.get(name) == null ? def : Long.parseLong((String)prop.get(name))) : Long.parseLong(val);
    }

    public static double getDoubleProperty(String name, double def) {
        String val = System.getProperty(name);
        return val == null ? (prop.get(name) == null ? def : Double.parseDouble((String)prop.get(name))) : Double.parseDouble(val);
    }

    public static Boolean getBooleanProperty(String name, boolean def) {
        String val = System.getProperty(name);
        return val == null ? (prop.get(name) == null ? def : Boolean.parseBoolean((String)prop.get(name))) : Boolean.parseBoolean(val);
    }

    public static String getQueueNameFromEPR(String targetEPR) {
        return targetEPR.substring("cg://".length());
    }

    public static String getFullUserName(String userName, String domainName) {
        return domainName == null || "".equals(domainName) ? userName : userName + "@" + domainName;
    }

    public static String getCSGServiceName(String serviceName, String userName) {
        userName = CGUtils.getStringProperty("cg-proxy-prefix", userName);
        String delimiter = CGUtils.getStringProperty("cg-proxy-delimiter", "-");
        return userName + delimiter + serviceName;
    }

    public static String getCGEPR(String tenantName, String serverName, String serviceName) {
        return "cg://" + (tenantName != null ? tenantName + "/" : "") + serverName + "/" + serviceName;
    }

    public static String getCGThriftServerHostName() throws SocketException {
        String hostName = CGUtils.getStringProperty("cg-thrift-server-hostname", null);
        if (hostName == null) {
            hostName = NetworkUtils.getLocalHostname();
        }
        return hostName;
    }

    public static int getCGThriftServerPort() {
        int port = CGUtils.getIntProperty("cg-thrift-server-port", -1);
        if (port == -1) {
            ServerConfiguration config = ServerConfiguration.getInstance();
            String portStr = config.getFirstProperty("Ports.CG");
            if (!"".equals(portStr) && portStr != null) {
                try {
                    port = Integer.parseInt(portStr);
                }
                catch (NumberFormatException e) {
                    port = 15001;
                }
            } else {
                port = 15001;
            }
        }
        return port;
    }

    public static String getPortFromServerURL(String serverURL) {
        String socket = CGUtils.getSocketStringFromServerURL(serverURL);
        return socket.substring(socket.indexOf(58) + 1);
    }

    public static String getHostFromServerURL(String serverURL) {
        String socket = CGUtils.getSocketStringFromServerURL(serverURL);
        return socket.substring(0, socket.indexOf(58));
    }

    public static String getUserNameFromTenantUserName(String tenantUserName) {
        return tenantUserName.contains("@") ? tenantUserName.substring(0, tenantUserName.indexOf(64)) : tenantUserName;
    }

    public static String getDomainNameFromTenantUserName(String tenantUserName) {
        return tenantUserName.contains("@") ? tenantUserName.substring(tenantUserName.indexOf(64) + 1) : null;
    }

    public static String getTryItURLFromWSDLURL(String wsdlURL) {
        return wsdlURL.substring(0, wsdlURL.indexOf("?wsdl")) + "?tryit";
    }

    private static String getSocketStringFromServerURL(String serverURL) {
        String socket = serverURL.substring("https://".length());
        if (socket.contains("/")) {
            socket = socket.replace("/", "");
        }
        return socket;
    }

    private static Properties loadProperties(String filePath) {
        String msg;
        Properties properties = new Properties();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Loading a file '" + filePath + "' from classpath"));
        }
        InputStream in = null;
        String confPath = System.getProperty(CGConstant.CONF_LOCATION);
        if (confPath != null) {
            try {
                in = new FileInputStream(confPath + File.separator + filePath);
            }
            catch (FileNotFoundException e) {
                msg = "Error loading properties from file: " + filePath;
                log.warn((Object)msg);
            }
        }
        if (in == null) {
            in = cl.getResourceAsStream(filePath);
        }
        if (in == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Unable to load file  ' " + filePath + " '"));
            }
            filePath = "repository/conf" + File.separatorChar + filePath;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loading a file '" + filePath + "' from classpath"));
            }
            if ((in = cl.getResourceAsStream(filePath)) == null && log.isDebugEnabled()) {
                log.debug((Object)("Unable to load file  ' " + filePath + " '"));
            }
        }
        if (in != null) {
            try {
                properties.load(in);
            }
            catch (IOException e) {
                msg = "Error loading properties from a file at :" + filePath;
                log.error((Object)msg, (Throwable)e);
            }
        }
        return properties;
    }

    public static String getContentType(Map<String, String> trpHeaders) {
        return trpHeaders.get("Content-Type");
    }

    public static String getPlainToken(String encryptedToken) throws CryptoException {
        CryptoUtil cryptoUtil = CryptoUtil.getDefaultCryptoUtil();
        String token = "";
        if (encryptedToken != null) {
            token = new String(cryptoUtil.base64DecodeAndDecrypt(encryptedToken));
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isServerAlive(String host, int port) {
        Socket s = null;
        boolean isAlive = true;
        try {
            s = new Socket(host, port);
        }
        catch (IOException e) {
            isAlive = false;
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (IOException iOException) {}
            }
        }
        return isAlive;
    }

    public static String[] getPermissionsList() {
        String[] permissionList;
        String permissionString = CGUtils.getStringProperty("cg-user-permission-list", null);
        if (permissionString == null) {
            permissionList = CGConstant.CG_USER_DEFAULT_PERMISSION_LIST;
        } else {
            permissionList = new String[]{};
            int i = 0;
            for (String permission : permissionString.split(",")) {
                permissionList[++i] = permission.trim();
            }
        }
        return permissionList;
    }

    public static void dumpBytesAsString(ByteArrayOutputStream baos) {
        byte[] b;
        for (byte i : b = baos.toByteArray()) {
            System.out.print((char)i);
        }
        System.out.println();
    }

    public static void dumpInputStreamAsString(InputStream is) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        while ((line = br.readLine()) != null) {
            sb.append(line);
        }
        System.out.println(sb.toString());
    }

    public static void dumpStringMap(Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            System.out.println(entry.getKey() + "/" + entry.getValue());
        }
    }
}

