/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.cloud.gateway.internal;

import java.net.SocketException;
import java.util.HashMap;
import org.apache.axis2.AxisFault;
import org.apache.axis2.transport.base.threads.WorkerPool;
import org.apache.axis2.transport.base.threads.WorkerPoolFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.cloud.gateway.common.CGUtils;
import org.wso2.carbon.cloud.gateway.transport.server.CGThriftServer;
import org.wso2.carbon.cloud.gateway.transport.server.CGThriftServerHandler;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.AuthorizationManager;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.util.UserCoreUtil;

@Component(name="CGServiceComponent", immediate=true)
public class CGServiceComponent {
    private static Log log = LogFactory.getLog(CGServiceComponent.class);
    private ServerConfigurationService serverConfiguration;
    private RealmService realmService;

    @Activate
    protected void activate(ComponentContext ctxt) {
        String trustStorePassWord;
        String keyStorePassWord;
        String hostName;
        if (this.serverConfiguration == null || this.realmService == null) {
            log.error((Object)("Could not activated the CGServiceComponent. " + (this.serverConfiguration == null ? "ServerConfigurationService" : "RealmService") + "is null!"));
            return;
        }
        try {
            String csgRoleName = CGUtils.getStringProperty("cloud-gateway-role", "cloud-gateway");
            this.addCGUser(csgRoleName, CGUtils.getPermissionsList(), CGUtils.getStringProperty("cg-user-name", "cguser"), CGUtils.getStringProperty("cg-user-password", "wso2@123"));
        }
        catch (UserStoreException e) {
            log.error((Object)"Cloud not activated the CGServiceComponent.", (Throwable)e);
            return;
        }
        try {
            hostName = CGUtils.getCGThriftServerHostName();
        }
        catch (SocketException e) {
            log.error((Object)"Could not activated the CGServiceComponent.", (Throwable)e);
            return;
        }
        int port = CGUtils.getCGThriftServerPort();
        int timeOut = CGUtils.getIntProperty("cg-thrift-timeout", 900000);
        String keyStoreURL = CGUtils.getKeyStoreFilePath();
        if (keyStoreURL == null) {
            log.error((Object)"KeyStore is missing and required for mutual SSL");
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Loading key store from the location '" + keyStoreURL + "'"));
        }
        if ((keyStorePassWord = CGUtils.getKeyStorePassWord()) == null) {
            log.error((Object)"KeyStore password is missing");
            return;
        }
        String trustStoreURL = CGUtils.getTrustStoreFilePath();
        if (trustStoreURL == null) {
            log.error((Object)"TrustStore is missing and required for mutual SSL");
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Loading trust store from the location '" + trustStoreURL + "'"));
        }
        if ((trustStorePassWord = CGUtils.getTrustStorePassWord()) == null) {
            log.error((Object)"TrustStore password is missing");
            return;
        }
        WorkerPool workerPool = WorkerPoolFactory.getWorkerPool((int)CGUtils.getIntProperty("cg-t-core", 20), (int)CGUtils.getIntProperty("cg-t-max", 500), (int)CGUtils.getIntProperty("cg-t-alive-sec", 5), (int)CGUtils.getIntProperty("cg-t-qlen", -1), (String)"CGThriftServerHandler-worker-thread-group", (String)"CGThriftServerHandler-worker");
        CGThriftServerHandler csgThriftServerHandler = new CGThriftServerHandler(workerPool);
        CGThriftServer server = new CGThriftServer(csgThriftServerHandler);
        try {
            server.start(hostName, port, timeOut, keyStoreURL, keyStorePassWord, trustStoreURL, trustStorePassWord, "Cloud-Gateway-ThriftServer-main-thread");
        }
        catch (AxisFault axisFault) {
            log.error((Object)"Unable to start thrift server", (Throwable)axisFault);
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Activated the CGServiceComponent");
        }
    }

    @Reference(name="user.realmservice.default", service=RealmService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmService) {
        this.realmService = realmService;
    }

    protected void unsetRealmService(RealmService realmService) {
        if (this.realmService != null) {
            this.realmService = null;
        }
    }

    @Reference(name="server.configuration", service=ServerConfigurationService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetServerConfiguration")
    protected void setServerConfiguration(ServerConfigurationService configuration) {
        this.serverConfiguration = configuration;
    }

    protected void unsetServerConfiguration(ServerConfigurationService configuration) {
        this.serverConfiguration = null;
    }

    private void addCGUser(String roleName, String[] permissionList, String csgUserName, String passWord) throws UserStoreException {
        String[] optimizedList = UserCoreUtil.optimizePermissions((String[])permissionList);
        UserRealm realm = this.realmService.getBootstrapRealm();
        if (realm.getRealmConfiguration().getAdminRoleName().equals(roleName)) {
            throw new UserStoreException("UI permission of admin is not allowed to change!");
        }
        AuthorizationManager authorizationManager = realm.getAuthorizationManager();
        authorizationManager.clearRoleActionOnAllResources(roleName, "ui.execute");
        for (String permission : optimizedList) {
            authorizationManager.authorizeRole(roleName, permission, "ui.execute");
        }
        authorizationManager.authorizeRole(roleName, "/", "add");
        authorizationManager.authorizeRole(roleName, "/", "get");
        authorizationManager.authorizeRole(roleName, "/", "delete");
        UserStoreManager manager = realm.getUserStoreManager();
        if (!manager.isExistingUser(csgUserName)) {
            manager.addUser(csgUserName, (Object)passWord, new String[0], new HashMap(), null, false);
        }
        if (!manager.isExistingRole(roleName)) {
            manager.addRole(roleName, new String[]{csgUserName}, null);
        }
    }
}

