/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.connector.core.connection;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.connector.core.ConnectException;
import org.wso2.carbon.connector.core.connection.Connection;
import org.wso2.carbon.connector.core.pool.Configuration;
import org.wso2.carbon.connector.core.pool.ConnectionFactory;
import org.wso2.carbon.connector.core.pool.ConnectionPool;

public class ConnectionHandler {
    private static final Log log = LogFactory.getLog(ConnectionHandler.class);
    private static final ConnectionHandler handler = new ConnectionHandler();
    private final Map<String, Object> connectionMap = new ConcurrentHashMap<String, Object>();

    private ConnectionHandler() {
    }

    public static ConnectionHandler getConnectionHandler() {
        return handler;
    }

    public void createConnection(String connector, String connectionName, ConnectionFactory factory, Configuration configuration) {
        ConnectionPool pool = new ConnectionPool(factory, configuration);
        this.connectionMap.putIfAbsent(this.getCode(connector, connectionName), (Object)pool);
    }

    public void createConnection(String connector, String connectionName, Connection connection) {
        this.connectionMap.putIfAbsent(this.getCode(connector, connectionName), connection);
    }

    public Connection getConnection(String connector, String connectionName) throws ConnectException {
        Connection connection = null;
        String connectorCode = this.getCode(connector, connectionName);
        Object connectionObj = this.connectionMap.get(connectorCode);
        if (connectionObj != null) {
            if (connectionObj instanceof ConnectionPool) {
                connection = (Connection)((ConnectionPool)((Object)connectionObj)).borrowObject();
            } else if (connectionObj instanceof Connection) {
                connection = (Connection)connectionObj;
            }
        } else {
            throw new ConnectException(String.format("Error occurred during retrieving connection. Connection %s for %s connector does not exist.", connectionName, connector));
        }
        return connection;
    }

    public void returnConnection(String connector, String connectionName, Connection connection) {
        String connectorCode = this.getCode(connector, connectionName);
        Object connectionObj = this.connectionMap.get(connectorCode);
        if (connectionObj instanceof ConnectionPool) {
            ((ConnectionPool)((Object)connectionObj)).returnObject(connection);
        }
    }

    public void shutdownConnections() {
        for (Map.Entry<String, Object> connection : this.connectionMap.entrySet()) {
            Object connectionObj = connection.getValue();
            if (!(connectionObj instanceof ConnectionPool)) continue;
            try {
                ((ConnectionPool)((Object)connectionObj)).close();
            }
            catch (ConnectException e) {
                log.error((Object)"Failed to close connection pool. ", (Throwable)e);
            }
        }
    }

    public void shutdownConnections(String connector) {
        for (Map.Entry<String, Object> connection : this.connectionMap.entrySet()) {
            Object connectionObj;
            if (!connection.getKey().split(":")[0].equals(connector) || !((connectionObj = connection.getValue()) instanceof ConnectionPool)) continue;
            try {
                ((ConnectionPool)((Object)connectionObj)).close();
            }
            catch (ConnectException e) {
                log.error((Object)"Failed to close connection pool. ", (Throwable)e);
            }
        }
    }

    public boolean checkIfConnectionExists(String connector, String connectionName) {
        return this.connectionMap.containsKey(this.getCode(connector, connectionName));
    }

    private String getCode(String connector, String connectionName) {
        return String.format("%s:%s", connector, connectionName);
    }
}

