/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.connector.core.pool;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.wso2.carbon.connector.core.ConnectException;
import org.wso2.carbon.connector.core.pool.Configuration;
import org.wso2.carbon.connector.core.pool.ConnectionFactory;

public class ConnectionPool
extends GenericObjectPool {
    private static final Log log = LogFactory.getLog(ConnectionPool.class);

    public ConnectionPool(ConnectionFactory factory, Configuration configuration) {
        super((PoolableObjectFactory)factory);
        if (configuration.getMaxActiveConnections() != null) {
            this.setMaxActive(configuration.getMaxActiveConnections());
        }
        if (configuration.getMaxIdleConnections() != null) {
            this.setMaxIdle(configuration.getMaxIdleConnections());
        }
        if (configuration.getMinIdleConnections() != null) {
            this.setMinIdle(configuration.getMinIdleConnections());
        }
        if (configuration.getMaxWaitTime() != null) {
            this.setMaxWait(configuration.getMaxWaitTime());
        }
        if (configuration.getMinEvictionTime() != null) {
            this.setMinEvictableIdleTimeMillis(configuration.getMinEvictionTime());
        }
        if (configuration.getEvictionCheckInterval() != null) {
            this.setTimeBetweenEvictionRunsMillis(configuration.getEvictionCheckInterval());
        }
        if (configuration.getExhaustedAction() != null) {
            this.setWhenExhaustedAction(this.getExhaustedAction(configuration.getExhaustedAction()));
        }
        if (configuration.getTestOnBorrow() != null) {
            this.setTestOnBorrow(configuration.getTestOnBorrow());
        }
        if (configuration.getTestOnReturn() != null) {
            this.setTestOnBorrow(configuration.getTestOnReturn());
        }
        if (configuration.getTestWhileIdle() != null) {
            this.setTestWhileIdle(configuration.getTestWhileIdle());
        }
        if (configuration.getNumTestsPerEvictionRun() != null) {
            this.setNumTestsPerEvictionRun(configuration.getNumTestsPerEvictionRun());
        }
        if (configuration.getSoftMinEvictableIdleTimeMillis() != null) {
            this.setSoftMinEvictableIdleTimeMillis(configuration.getSoftMinEvictableIdleTimeMillis());
        }
    }

    private byte getExhaustedAction(String exhaustedAction) {
        byte action;
        switch (exhaustedAction) {
            case "WHEN_EXHAUSTED_FAIL": {
                action = 0;
                break;
            }
            case "WHEN_EXHAUSTED_BLOCK": {
                action = 1;
                break;
            }
            case "WHEN_EXHAUSTED_GROW": {
                action = 2;
                break;
            }
            default: {
                action = 1;
                log.warn((Object)String.format("Unable to find the configured exhausted action. Setting to default: %s.", action));
            }
        }
        return action;
    }

    public Object borrowObject() throws ConnectException {
        try {
            log.debug((Object)"Borrowing object from the connection pool...");
            return super.borrowObject();
        }
        catch (Exception e) {
            throw new ConnectException(e, "Error occurred while borrowing connection from the pool.");
        }
    }

    public void returnObject(Object obj) {
        try {
            log.debug((Object)"Returning object to the connection pool...");
            super.returnObject(obj);
        }
        catch (Exception e) {
            log.error((Object)"Error occurred while returning the connection to the pool.", (Throwable)e);
        }
    }

    public void close() throws ConnectException {
        try {
            super.close();
        }
        catch (Exception e) {
            throw new ConnectException(e, "Error occurred while closing the connections.");
        }
    }
}

