/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.connector.core.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Stack;
import org.apache.commons.lang.StringUtils;
import org.apache.synapse.MessageContext;
import org.apache.synapse.mediators.template.TemplateContext;
import org.wso2.carbon.connector.core.pool.Configuration;

public class ConnectorUtils {
    public static Object lookupTemplateParamater(MessageContext ctxt, String paramName) {
        Stack funcStack = (Stack)ctxt.getProperty("_SYNAPSE_FUNCTION_STACK");
        TemplateContext currentFuncHolder = (TemplateContext)funcStack.peek();
        Object paramValue = currentFuncHolder.getParameterValue(paramName);
        return paramValue;
    }

    public static Object lookupTemplateParamater(MessageContext ctxt, int index) {
        Stack funcStack = (Stack)ctxt.getProperty("_SYNAPSE_FUNCTION_STACK");
        TemplateContext currentFuncHolder = (TemplateContext)funcStack.peek();
        Collection paramList = currentFuncHolder.getParameters();
        Iterator it = paramList.iterator();
        int i = 0;
        while (it.hasNext()) {
            String param = (String)it.next();
            if (i == index) {
                return param;
            }
            ++i;
        }
        return null;
    }

    public static Configuration getPoolConfiguration(MessageContext messageContext) {
        Configuration configuration = new Configuration();
        String maxActiveConnections = (String)ConnectorUtils.lookupTemplateParamater(messageContext, "maxActiveConnections");
        String maxIdleConnections = (String)ConnectorUtils.lookupTemplateParamater(messageContext, "maxIdleConnections");
        String maxWaitTime = (String)ConnectorUtils.lookupTemplateParamater(messageContext, "maxWaitTime");
        String minEvictionTime = (String)ConnectorUtils.lookupTemplateParamater(messageContext, "minEvictionTime");
        String evictionCheckInterval = (String)ConnectorUtils.lookupTemplateParamater(messageContext, "evictionCheckInterval");
        String exhaustedAction = (String)ConnectorUtils.lookupTemplateParamater(messageContext, "exhaustedAction");
        if (!StringUtils.isEmpty((String)maxActiveConnections)) {
            configuration.setMaxActiveConnections(Integer.parseInt(maxActiveConnections));
        }
        if (!StringUtils.isEmpty((String)maxWaitTime)) {
            configuration.setMaxWaitTime(Long.parseLong(maxWaitTime));
        }
        if (!StringUtils.isEmpty((String)maxIdleConnections)) {
            configuration.setMaxIdleConnections(Integer.parseInt(maxIdleConnections));
        }
        if (!StringUtils.isEmpty((String)minEvictionTime)) {
            configuration.setMinEvictionTime(Long.parseLong(minEvictionTime));
        }
        if (!StringUtils.isEmpty((String)evictionCheckInterval)) {
            configuration.setEvictionCheckInterval(Long.parseLong(evictionCheckInterval));
        }
        if (!StringUtils.isEmpty((String)exhaustedAction)) {
            configuration.setExhaustedAction(exhaustedAction);
        }
        return configuration;
    }
}

