/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.connector.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.TransportUtils;
import org.apache.commons.io.IOUtils;
import org.apache.synapse.commons.json.JsonUtil;
import org.apache.synapse.transport.passthru.util.RelayConstants;
import org.apache.synapse.transport.passthru.util.StreamingOnRequestDataSource;
import org.wso2.carbon.connector.core.exception.ContentBuilderException;

public final class PayloadUtils {
    private static final String APPLICATION_XML = "application/xml";
    private static final String APPLICATION_JSON = "application/json";
    private static final String TEXT_XML = "text/xml";
    private static final String TEXT_CSV = "text/csv";
    private static final String TEXT_PLAIN = "text/plain";
    private static final QName TEXT_ELEMENT = new QName("http://ws.apache.org/commons/ns/payload", "text");

    private PayloadUtils() {
    }

    public static void setContent(MessageContext messageContext, InputStream inputStream, String contentType) throws ContentBuilderException {
        try {
            if (TEXT_XML.equalsIgnoreCase(contentType) || APPLICATION_XML.equalsIgnoreCase(contentType)) {
                PayloadUtils.setXMLContent(inputStream, messageContext);
                PayloadUtils.handleSpecialProperties(APPLICATION_XML, messageContext);
            } else if (APPLICATION_JSON.equalsIgnoreCase(contentType)) {
                PayloadUtils.setJSONPayload(inputStream, messageContext);
                PayloadUtils.handleSpecialProperties(APPLICATION_JSON, messageContext);
            } else if (TEXT_PLAIN.equalsIgnoreCase(contentType) || TEXT_CSV.equalsIgnoreCase(contentType)) {
                PayloadUtils.setTextContent(inputStream, messageContext);
                PayloadUtils.handleSpecialProperties(TEXT_PLAIN, messageContext);
            } else {
                PayloadUtils.setBinaryContent(inputStream, messageContext);
            }
        }
        catch (AxisFault e) {
            throw new ContentBuilderException("Failed to build content.", e);
        }
    }

    public static void handleSpecialProperties(String contentType, MessageContext axis2MessageCtx) {
        axis2MessageCtx.setProperty("messageType", (Object)contentType);
        axis2MessageCtx.setProperty("ContentType", (Object)contentType);
        Map headers = (Map)axis2MessageCtx.getProperty("TRANSPORT_HEADERS");
        if (headers != null) {
            headers.put("Content-Type", contentType);
        }
    }

    public static void preparePayload(MessageContext messageContext, String xmlString) throws ContentBuilderException {
        String error = "Failed to set response in payload.";
        try {
            OMElement element = AXIOMUtil.stringToOM((String)xmlString);
            PayloadUtils.setPayloadInEnvelope(messageContext, element);
        }
        catch (XMLStreamException e) {
            throw new ContentBuilderException(error, e);
        }
    }

    public static void setPayloadInEnvelope(MessageContext axis2MsgCtx, OMElement payload) throws ContentBuilderException {
        JsonUtil.removeJsonPayload((MessageContext)axis2MsgCtx);
        try {
            axis2MsgCtx.setEnvelope(TransportUtils.createSOAPEnvelope((OMElement)payload));
        }
        catch (AxisFault e) {
            throw new ContentBuilderException("Failed to set XML content.", e);
        }
    }

    private static void setBinaryContent(InputStream inputStream, MessageContext axis2MessageContext) throws AxisFault {
        SOAPFactory factory = OMAbstractFactory.getSOAP12Factory();
        OMNamespace ns = factory.createOMNamespace(RelayConstants.BINARY_CONTENT_QNAME.getNamespaceURI(), "ns");
        OMElement element = factory.createOMElement(RelayConstants.BINARY_CONTENT_QNAME.getLocalPart(), ns);
        StreamingOnRequestDataSource ds = new StreamingOnRequestDataSource(inputStream);
        DataHandler dataHandler = new DataHandler((DataSource)ds);
        OMText textData = factory.createOMText((Object)dataHandler, true);
        element.addChild((OMNode)textData);
        axis2MessageContext.setEnvelope(TransportUtils.createSOAPEnvelope((OMElement)element));
    }

    private static void setTextContent(InputStream inputStream, MessageContext axis2MessageContext) throws ContentBuilderException {
        try {
            String text = IOUtils.toString((InputStream)inputStream, (String)StandardCharsets.UTF_8.name());
            PayloadUtils.setPayloadInEnvelope(axis2MessageContext, PayloadUtils.getTextElement(text));
        }
        catch (IOException e) {
            throw new ContentBuilderException("Failed to set text content.", e);
        }
    }

    private static void setJSONPayload(InputStream inputStream, MessageContext axis2MessageContext) throws ContentBuilderException {
        try {
            String text = IOUtils.toString((InputStream)inputStream, (String)StandardCharsets.UTF_8.name());
            JsonUtil.getNewJsonPayload((MessageContext)axis2MessageContext, (String)text, (boolean)true, (boolean)true);
        }
        catch (IOException e) {
            throw new ContentBuilderException("Failed to set JSON content.", e);
        }
    }

    private static void setXMLContent(InputStream inputStream, MessageContext axis2MessageContext) throws ContentBuilderException {
        try {
            String text = IOUtils.toString((InputStream)inputStream, (String)StandardCharsets.UTF_8.name());
            OMElement omXML = AXIOMUtil.stringToOM((String)text);
            PayloadUtils.setPayloadInEnvelope(axis2MessageContext, omXML);
        }
        catch (IOException | XMLStreamException e) {
            throw new ContentBuilderException("Failed to set XML content.", e);
        }
    }

    private static OMElement getTextElement(String content) {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMElement textElement = factory.createOMElement(TEXT_ELEMENT);
        if (content == null) {
            content = "";
        }
        textElement.setText(content);
        return textElement;
    }
}

