/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.connector.core;

import java.io.IOException;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.axiom.om.OMText;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.config.Entry;
import org.apache.synapse.registry.Registry;
import org.json.JSONObject;
import org.wso2.carbon.connector.core.AbstractConnector;
import org.wso2.carbon.connector.core.ConnectException;

public class RefreshAccessToken
extends AbstractConnector {
    private CloseableHttpClient httpClient = HttpClients.createDefault();
    protected static final String PROPERTY_PREFIX = "uri.var.";

    @Override
    public void connect(MessageContext messageContext) throws ConnectException {
        Registry registry = messageContext.getConfiguration().getRegistry();
        String accessTokenRegistryPath = (String)messageContext.getProperty("uri.var.accessTokenRegistryPath");
        if (StringUtils.isEmpty((String)accessTokenRegistryPath)) {
            throw new ConnectException("Access token registry path not provided for access token storage and reuse.");
        }
        this.handleRefresh(messageContext, registry, accessTokenRegistryPath);
    }

    protected boolean reuseSavedAccessToken(MessageContext messageContext, Registry registry, String accessTokenRegistryPath) {
        String savedAccessToken = null;
        Entry propEntry = messageContext.getConfiguration().getEntryDefinition(accessTokenRegistryPath);
        if (propEntry == null) {
            propEntry = new Entry();
            propEntry.setType(3);
            propEntry.setKey(accessTokenRegistryPath);
        }
        registry.getResource(propEntry, new Properties());
        if (propEntry.getValue() != null) {
            savedAccessToken = propEntry.getValue() instanceof OMText ? ((OMText)propEntry.getValue()).getText() : propEntry.getValue().toString();
            messageContext.setProperty("uri.var.accessToken", (Object)savedAccessToken);
            return false;
        }
        return true;
    }

    protected void handleRefresh(MessageContext messageContext, Registry registry, String accessTokenRegistryPath) throws ConnectException {
        SynapseLog synLog = this.getLog(messageContext);
        Set propertyKeySet = messageContext.getPropertyKeySet();
        propertyKeySet.remove("Accept-Encoding");
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug((Object)"Start : Salesforce Refresh Access Token mediator.");
            if (synLog.isTraceTraceEnabled()) {
                synLog.traceTrace((Object)("Message : " + messageContext.getEnvelope()));
            }
        }
        String refreshUrl = this.getRefreshUrl(messageContext);
        HttpGet httpget = new HttpGet(refreshUrl);
        CloseableHttpResponse httpResponse = null;
        try {
            httpResponse = this.httpClient.execute((HttpUriRequest)httpget);
            if (Pattern.matches("4[0-9][0-9]", String.valueOf(httpResponse.getStatusLine().getStatusCode()))) {
                throw new ConnectException("Refresh call returned HTTP Status code " + httpResponse.getStatusLine().getStatusCode() + ". " + httpResponse.getStatusLine().getReasonPhrase());
            }
            if (httpResponse.getEntity() == null) {
                throw new ConnectException("Empty response received for refresh access token call");
            }
            synLog.auditLog((Object)("Refresh call response : " + httpResponse.toString()));
            this.extractAndSetPropertyAndRegistryResource(messageContext, httpResponse, registry, accessTokenRegistryPath);
        }
        catch (IOException e) {
            synLog.error((Object)e);
            throw new ConnectException(e, "Error while executing GET request to refresh the access token");
        }
        finally {
            propertyKeySet.remove("Cache-Control");
            propertyKeySet.remove("Pragma");
            httpget.releaseConnection();
            if (httpResponse != null) {
                try {
                    httpResponse.close();
                }
                catch (IOException e) {
                    synLog.error((Object)e);
                }
            }
        }
    }

    protected String getRefreshUrl(MessageContext messageContext) {
        String clientSecret;
        String customRefreshUrl = (String)messageContext.getProperty("uri.var.customRefreshUrl");
        if (StringUtils.isNotEmpty((String)customRefreshUrl)) {
            return customRefreshUrl;
        }
        StringBuilder urlStringBuilder = new StringBuilder();
        urlStringBuilder.append(messageContext.getProperty("uri.var.tokenEndpointUrl"));
        urlStringBuilder.append("?grant_type=refresh_token");
        String clientId = (String)messageContext.getProperty("uri.var.clientId");
        if (StringUtils.isNotEmpty((String)clientId)) {
            urlStringBuilder.append("&client_id=").append(clientId);
        }
        if (StringUtils.isNotEmpty((String)(clientSecret = (String)messageContext.getProperty("uri.var.clientSecret")))) {
            urlStringBuilder.append("&client_secret=").append(clientSecret);
        }
        urlStringBuilder.append("&refresh_token=").append(messageContext.getProperty("uri.var.refreshToken"));
        urlStringBuilder.append("&format=json");
        return urlStringBuilder.toString();
    }

    protected void extractAndSetPropertyAndRegistryResource(MessageContext messageContext, CloseableHttpResponse httpResponse, Registry registry, String accessTokenRegistryPath) throws IOException {
        Scanner scanner = new Scanner(httpResponse.getEntity().getContent());
        String jsonResponse = scanner.nextLine();
        JSONObject jsonObject = new JSONObject(jsonResponse);
        String accessToken = jsonObject.getString("access_token");
        messageContext.setProperty("uri.var.accessToken", (Object)accessToken);
        String instanceUrl = jsonObject.getString("instance_url");
        messageContext.setProperty("uri.var.apiUrl", (Object)instanceUrl);
        String systemTime = Long.toString(System.currentTimeMillis());
        if (StringUtils.isNotEmpty((String)accessToken)) {
            registry.newNonEmptyResource(accessTokenRegistryPath, false, "text/plain", systemTime, "timestamp");
            registry.updateResource(accessTokenRegistryPath, (Object)accessToken);
        }
    }
}

