/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.connector.core;

import org.apache.commons.lang.StringUtils;
import org.apache.synapse.MessageContext;
import org.apache.synapse.registry.Registry;
import org.wso2.carbon.connector.core.ConnectException;
import org.wso2.carbon.connector.core.RefreshAccessToken;

public class RefreshAccessTokenWithExpiry
extends RefreshAccessToken {
    @Override
    public void connect(MessageContext messageContext) throws ConnectException {
        Registry registry = messageContext.getConfiguration().getRegistry();
        boolean isRefreshNeeded = false;
        String accessTokenRegistryPath = (String)messageContext.getProperty("uri.var.accessTokenRegistryPath");
        String lastRefreshedTimeString = registry.getResourceProperties(accessTokenRegistryPath).getProperty("timestamp");
        if (StringUtils.isEmpty((String)lastRefreshedTimeString)) {
            isRefreshNeeded = true;
        } else {
            String intervalTimeString = (String)messageContext.getProperty("uri.var.intervalTime");
            if (StringUtils.isEmpty((String)intervalTimeString)) {
                intervalTimeString = "300000";
            }
            long expiryTimeInterval = Long.parseLong(intervalTimeString);
            long lastRefreshedTime = Long.parseLong(lastRefreshedTimeString);
            if (System.currentTimeMillis() - lastRefreshedTime > expiryTimeInterval) {
                isRefreshNeeded = true;
            }
        }
        if (!isRefreshNeeded) {
            isRefreshNeeded = this.reuseSavedAccessToken(messageContext, registry, accessTokenRegistryPath);
        }
        if (isRefreshNeeded) {
            this.handleRefresh(messageContext, registry, accessTokenRegistryPath);
        }
    }
}

