/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.connector.core;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.Set;
import org.apache.axiom.om.OMText;
import org.apache.commons.lang.StringUtils;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.config.Entry;
import org.apache.synapse.registry.Registry;
import org.json.JSONException;
import org.json.JSONObject;
import org.wso2.carbon.connector.core.AbstractConnector;
import org.wso2.carbon.connector.core.ConnectException;
import org.wso2.carbon.connector.core.util.ConnectorUtils;

public class RefreshAccessToken
extends AbstractConnector {
    protected static final String PROPERTY_PREFIX = "uri.var.";
    protected static final String ACCEPT_ENCODING = "Accept-Encoding";
    protected static final String CACHE_CONTROL = "Cache-Control";
    protected static final String PRAGMA = "Pragma";

    @Override
    public void connect(MessageContext messageContext) throws ConnectException {
        Registry registry = messageContext.getConfiguration().getRegistry();
        String accessTokenRegistryPath = (String)messageContext.getProperty("uri.var.accessTokenRegistryPath");
        if (StringUtils.isEmpty((String)accessTokenRegistryPath)) {
            throw new ConnectException("Access token registry path not provided for access token storage and reuse.");
        }
        this.handleRefresh(messageContext, registry, accessTokenRegistryPath);
    }

    protected boolean reuseSavedAccessToken(MessageContext messageContext, Registry registry, String accessTokenRegistryPath) {
        String savedAccessToken = null;
        Entry propEntry = messageContext.getConfiguration().getEntryDefinition(accessTokenRegistryPath);
        if (propEntry == null) {
            propEntry = new Entry();
            propEntry.setType(3);
            propEntry.setKey(accessTokenRegistryPath);
        }
        registry.getResource(propEntry, new Properties());
        if (propEntry.getValue() != null) {
            savedAccessToken = propEntry.getValue() instanceof OMText ? ((OMText)propEntry.getValue()).getText() : propEntry.getValue().toString();
            messageContext.setProperty("uri.var.accessToken", (Object)savedAccessToken);
            return false;
        }
        return true;
    }

    protected void handleRefresh(MessageContext messageContext, Registry registry, String accessTokenRegistryPath) throws ConnectException {
        SynapseLog synLog = this.getLog(messageContext);
        Set propertyKeySet = messageContext.getPropertyKeySet();
        propertyKeySet.remove(ACCEPT_ENCODING);
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug((Object)"Start : Refresh Access Token mediator.");
            if (synLog.isTraceTraceEnabled()) {
                synLog.traceTrace((Object)("Message : " + messageContext.getEnvelope()));
            }
        }
        try {
            String jsonResponse = ConnectorUtils.sendPost(this.getPostData(messageContext), StandardCharsets.UTF_8, messageContext);
            this.extractAndSetPropertyAndRegistryResource(messageContext, jsonResponse, registry, accessTokenRegistryPath);
        }
        catch (IOException e) {
            synLog.error((Object)e);
            throw new ConnectException(e, "Error while executing POST request to refresh the access token");
        }
        catch (JSONException e) {
            synLog.error((Object)e);
            throw new ConnectException(e, "Error while processing the response message");
        }
        finally {
            propertyKeySet.remove(CACHE_CONTROL);
            propertyKeySet.remove(PRAGMA);
        }
    }

    protected String getPostData(MessageContext messageContext) {
        String clientSecret;
        String customRefreshUrl = (String)messageContext.getProperty("uri.var.customRefreshUrl");
        if (StringUtils.isNotEmpty((String)customRefreshUrl)) {
            return customRefreshUrl;
        }
        StringBuilder urlStringBuilder = new StringBuilder();
        urlStringBuilder.append("grant_type=refresh_token");
        String clientId = (String)messageContext.getProperty("uri.var.clientId");
        if (StringUtils.isNotEmpty((String)clientId)) {
            urlStringBuilder.append("&client_id=").append(clientId);
        }
        if (StringUtils.isNotEmpty((String)(clientSecret = (String)messageContext.getProperty("uri.var.clientSecret")))) {
            urlStringBuilder.append("&client_secret=").append(clientSecret);
        }
        urlStringBuilder.append("&refresh_token=").append(messageContext.getProperty("uri.var.refreshToken"));
        urlStringBuilder.append("&format=json");
        return urlStringBuilder.toString();
    }

    protected void extractAndSetPropertyAndRegistryResource(MessageContext messageContext, String jsonResponse, Registry registry, String accessTokenRegistryPath) throws IOException, ConnectException, JSONException {
        JSONObject jsonObject = new JSONObject(jsonResponse);
        String accessToken = jsonObject.getString("access_token");
        messageContext.setProperty("uri.var.accessToken", (Object)accessToken);
        if (!jsonObject.isNull("instance_url")) {
            String instanceUrl = jsonObject.getString("instance_url");
            messageContext.setProperty("uri.var.apiUrl", (Object)instanceUrl);
        }
        String systemTime = Long.toString(System.currentTimeMillis());
        if (StringUtils.isNotEmpty((String)accessToken)) {
            registry.newNonEmptyResource(accessTokenRegistryPath, false, "text/plain", systemTime, "timestamp");
            registry.updateResource(accessTokenRegistryPath, (Object)accessToken);
        }
    }
}

