/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.das.data.publisher.util;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.context.PrivilegedCarbonContext;

public class PublisherUtil {
    private static Log log = LogFactory.getLog(PublisherUtil.class);
    private static String hostAddress = null;
    public static final String HOST_NAME = "HostName";

    public static String getHostAddress() {
        if (hostAddress != null) {
            return hostAddress;
        }
        String hostAddress = ServerConfiguration.getInstance().getFirstProperty("MediationFlowStatisticConfig.NodeHostName");
        if (hostAddress == null) {
            hostAddress = ServerConfiguration.getInstance().getFirstProperty(HOST_NAME);
        }
        if (null == hostAddress) {
            InetAddress localAddress = PublisherUtil.getLocalAddress();
            if (localAddress != null) {
                hostAddress = localAddress.getHostAddress();
            } else {
                hostAddress = "localhost";
                log.warn((Object)"Unable to get the ip address, hence using hostname as localhost");
            }
            PublisherUtil.hostAddress = hostAddress;
            return PublisherUtil.hostAddress;
        }
        return hostAddress.trim();
    }

    private static InetAddress getLocalAddress() {
        Enumeration<NetworkInterface> ifaces = null;
        try {
            ifaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            log.error((Object)"Failed to get host address", (Throwable)e);
        }
        if (ifaces != null) {
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                Enumeration<InetAddress> addresses = iface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress addr = addresses.nextElement();
                    if (!(addr instanceof Inet4Address) || addr.isLoopbackAddress()) continue;
                    return addr;
                }
            }
        }
        return null;
    }

    public static int getTenantId(MessageContext msgContext) {
        return PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
    }

    public static ArrayList<String> getReceiverGroups(String urls) {
        ArrayList<String> matchList = new ArrayList<String>();
        Pattern regex = Pattern.compile("\\{.*?\\}");
        Matcher regexMatcher = regex.matcher(urls);
        while (regexMatcher.find()) {
            matchList.add(regexMatcher.group().replace("{", "").replace("}", ""));
        }
        if (matchList.size() == 0) {
            matchList.add(urls.replace("{", "").replace("}", ""));
        }
        return matchList;
    }
}

