/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth.mediator.config.xml;

import java.util.List;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorFactory;
import org.wso2.carbon.identity.oauth.mediator.OAuthMediator;
import org.wso2.carbon.mediator.service.MediatorException;

public class OAuthMediatorFactory
extends AbstractMediatorFactory {
    private static final QName ELEMENT_OAUTH = new QName("http://ws.apache.org/ns/synapse", "oauthService");
    private static final QName ATTR_NAME_SERVICE_EPR = new QName("remoteServiceUrl");
    private static final QName ATTR_NAME_USERNAME = new QName("username");
    private static final QName ATTR_NAME_PASSWORD = new QName("password");

    public Mediator createSpecificMediator(OMElement element, Properties properties) {
        if (!ELEMENT_OAUTH.equals(element.getQName())) {
            this.handleException("Unable to create the OAuth mediator. Unexpected element as the OAuth mediator configuration");
        }
        OAuthMediator mediator = null;
        OMAttribute remoteServiceUrl = null;
        OMAttribute username = null;
        OMAttribute password = null;
        mediator = new OAuthMediator();
        remoteServiceUrl = element.getAttribute(ATTR_NAME_SERVICE_EPR);
        if (remoteServiceUrl == null || remoteServiceUrl.getAttributeValue() == null) {
            throw new MediatorException("The 'remoteServiceUrl' attribute is required for the OAuth mediator");
        }
        mediator.setRemoteServiceUrl(remoteServiceUrl.getAttributeValue());
        username = element.getAttribute(ATTR_NAME_USERNAME);
        if (username == null || username.getAttributeValue() == null) {
            throw new MediatorException("The 'username' attribute is required for the OAuth mediator");
        }
        mediator.setUsername(username.getAttributeValue());
        password = element.getAttribute(ATTR_NAME_PASSWORD);
        if (password == null || password.getAttributeValue() == null) {
            throw new MediatorException("The 'password' attribute is required for the OAuth mediator");
        }
        mediator.setPassword(password.getAttributeValue());
        OAuthMediatorFactory.addAllCommentChildrenToList((OMElement)element, (List)mediator.getCommentsList());
        return mediator;
    }

    public QName getTagQName() {
        return ELEMENT_OAUTH;
    }
}

