/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth.mediator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.mediators.AbstractMediator;
import org.wso2.carbon.identity.oauth.mediator.OAuth2TokenValidationServiceClient;
import org.wso2.carbon.identity.oauth.mediator.OAuthServiceClient;
import org.wso2.carbon.identity.oauth.stub.dto.OAuthConsumerDTO;
import org.wso2.carbon.identity.oauth.stub.types.Parameters;
import org.wso2.carbon.identity.oauth2.stub.dto.OAuth2TokenValidationRequestDTO_TokenValidationContextParam;
import org.wso2.carbon.identity.oauth2.stub.dto.OAuth2TokenValidationResponseDTO;

public class OAuthMediator
extends AbstractMediator {
    private static final Log log = LogFactory.getLog(OAuthMediator.class);
    private String remoteServiceUrl;
    private String username;
    private String password;
    ConfigurationContext cfgCtx = null;
    private String clientRepository = null;
    private String axis2xml = null;
    public static final String DEFAULT_CLIENT_REPO = "./samples/axis2Client/client_repo";
    public static final String DEFAULT_AXIS2_XML = "./samples/axis2Client/client_repo/conf/axis2.xml";

    public void init(SynapseEnvironment synEnv) {
        try {
            this.cfgCtx = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)(this.clientRepository != null ? this.clientRepository : DEFAULT_CLIENT_REPO), (String)(this.axis2xml != null ? this.axis2xml : DEFAULT_AXIS2_XML));
        }
        catch (AxisFault e) {
            String msg = "Error initializing OAuth mediator : " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new SynapseException(msg, (Throwable)e);
        }
    }

    public boolean mediate(org.apache.synapse.MessageContext synCtx) {
        if (synCtx.getEnvironment().isDebuggerEnabled() && super.divertMediationRoute(synCtx)) {
            return true;
        }
        boolean isOauth2 = this.validateRequest(synCtx);
        if (isOauth2) {
            return this.handleOAuth2(synCtx);
        }
        return this.handleOAuth1a(synCtx);
    }

    private boolean validateRequest(org.apache.synapse.MessageContext synCtx) {
        boolean isOauth2 = false;
        String accessToken = null;
        MessageContext msgContext = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
        Map headersMap = (Map)msgContext.getProperty("TRANSPORT_HEADERS");
        String authHeader = (String)headersMap.get("Authorization");
        if (authHeader == null) {
            throw new SynapseException("Not a valid OAuth Request");
        }
        if (authHeader != null && authHeader.startsWith("Bearer ")) {
            isOauth2 = true;
            if (authHeader.length() > "Bearer ".length()) {
                accessToken = authHeader.substring("Bearer ".length()).trim();
            }
        }
        if (isOauth2 && accessToken == null) {
            throw new SynapseException("Invalid or empty OAuth 2.0 token");
        }
        return isOauth2;
    }

    private boolean handleOAuth2(org.apache.synapse.MessageContext synCtx) {
        OAuth2TokenValidationResponseDTO respDTO;
        Map headersMap;
        log.debug((Object)"Validating the OAuth 2.0 Request");
        try {
            OAuth2TokenValidationServiceClient oauth2Client = new OAuth2TokenValidationServiceClient(this.getRemoteServiceUrl(), this.getUsername(), this.getPassword(), this.cfgCtx);
            MessageContext msgContext = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
            headersMap = (Map)msgContext.getProperty("TRANSPORT_HEADERS");
            String authHeader = (String)headersMap.get("Authorization");
            String accessToken = authHeader.substring(7).trim();
            ArrayList<OAuth2TokenValidationRequestDTO_TokenValidationContextParam> contextParams = new ArrayList<OAuth2TokenValidationRequestDTO_TokenValidationContextParam>();
            int i = 0;
            while (synCtx.getProperty("oauth_context_param_key_" + i) != null && synCtx.getProperty("oauth_context_param_key_" + i) instanceof String && !synCtx.getProperty("oauth_context_param_key_" + i).equals("") && synCtx.getProperty("oauth_context_param_value_" + i) != null && synCtx.getProperty("oauth_context_param_value_" + i) instanceof String && !synCtx.getProperty("oauth_context_param_value_" + i).equals("")) {
                String paramKey = (String)synCtx.getProperty("oauth_context_param_key_" + i);
                String paramValue = (String)synCtx.getProperty("oauth_context_param_value_" + i);
                OAuth2TokenValidationRequestDTO_TokenValidationContextParam param = new OAuth2TokenValidationRequestDTO_TokenValidationContextParam();
                param.setKey(paramKey);
                param.setValue(paramValue);
                contextParams.add(param);
                ++i;
            }
            respDTO = oauth2Client.validateAuthenticationRequest(accessToken, contextParams);
        }
        catch (Exception e) {
            log.error((Object)"Error occured while validating oauth access token", (Throwable)e);
            throw new SynapseException("Error occured while validating oauth 2.0 access token");
        }
        if (!respDTO.getValid()) {
            throw new SynapseException("OAuth 2.0 authentication failed");
        }
        if (respDTO.getAuthorizationContextToken() != null) {
            headersMap.put("X-JWT-Assertion", respDTO.getAuthorizationContextToken().getTokenString());
        }
        if (synCtx.getProperty("oauth2_scope_validation_enabled") != null && Boolean.parseBoolean((String)synCtx.getProperty("oauth2_scope_validation_enabled"))) {
            String[] scopes = respDTO.getScope();
            if (scopes != null) {
                ArrayList<String> values;
                String apiScope = (String)synCtx.getProperty("scope");
                if (apiScope == null) {
                    apiScope = (String)synCtx.getProperty("SYNAPSE_REST_API");
                }
                if (apiScope == null) {
                    apiScope = ((Axis2MessageContext)synCtx).getAxis2MessageContext().getAxisService().getName();
                }
                if (!(values = new ArrayList<String>(Arrays.asList(scopes))).contains(apiScope)) {
                    log.debug((Object)"Valid Scope is not match for given access token. OAuth2 scope validation is failed.");
                    throw new SynapseException("OAuth 2.0 authentication failed");
                }
            } else {
                log.debug((Object)"Scope is null for given access token.  OAuth2 scope validation is failed.");
                throw new SynapseException("OAuth 2.0 authentication failed");
            }
        }
        return true;
    }

    private boolean handleOAuth1a(org.apache.synapse.MessageContext synCtx) {
        log.debug((Object)"Validating the OAuth 1.0a Request");
        OAuthServiceClient client = null;
        ConfigurationContext configContext = null;
        OAuthConsumerDTO consumer = null;
        boolean isValidConsumer = false;
        try {
            Parameters params = this.populateOauthConsumerData(synCtx);
            client = new OAuthServiceClient(this.getRemoteServiceUrl(), configContext);
            if (params != null && params.getOauthToken() == null) {
                consumer = new OAuthConsumerDTO();
                consumer.setBaseString(params.getBaseString());
                consumer.setHttpMethod(params.getHttpMethod());
                consumer.setOauthConsumerKey(params.getOauthConsumerKey());
                consumer.setOauthNonce(params.getOauthNonce());
                consumer.setOauthSignature(params.getOauthSignature());
                consumer.setOauthSignatureMethod(params.getOauthSignatureMethod());
                consumer.setOauthTimeStamp(params.getOauthTimeStamp());
                isValidConsumer = client.isOAuthConsumerValid(consumer);
            } else {
                isValidConsumer = client.validateAuthenticationRequest(params);
            }
            if (!isValidConsumer) {
                throw new SynapseException("OAuth authentication failed");
            }
            return true;
        }
        catch (Exception e) {
            log.error((Object)"Error occured while validating oauth consumer", (Throwable)e);
            throw new SynapseException("Error occured while validating oauth consumer");
        }
    }

    private Parameters populateOauthConsumerData(org.apache.synapse.MessageContext synCtx) {
        String scope;
        MessageContext msgContext = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
        Map headersMap = (Map)msgContext.getProperty("TRANSPORT_HEADERS");
        String authHeader = (String)headersMap.get("Authorization");
        String queryString = (String)msgContext.getProperty("REST_URL_POSTFIX");
        Parameters params = null;
        String splitChar = ",";
        boolean noAuthorizationHeader = false;
        params = new Parameters();
        String operation = null;
        if (queryString.indexOf("?") > -1) {
            String temp = queryString;
            queryString = queryString.substring(queryString.indexOf("?") + 1);
            operation = temp.substring(0, temp.indexOf("?") + 1);
        }
        if (authHeader == null) {
            noAuthorizationHeader = true;
            authHeader = queryString;
            splitChar = "&";
        }
        StringBuffer nonAuthParams = new StringBuffer();
        if (authHeader != null) {
            String[] headers;
            if (authHeader.startsWith("OAuth ")) {
                authHeader = authHeader.substring(authHeader.indexOf("o"));
            }
            if ((headers = authHeader.split(splitChar)) != null && headers.length > 0) {
                for (String header : headers) {
                    String[] elements = header.split("=");
                    if (elements == null || elements.length <= 0) continue;
                    if ("oauth_consumer_key".equals(elements[0].trim())) {
                        params.setOauthConsumerKey(this.removeLeadingAndTrailingQuatation(elements[1].trim()));
                        continue;
                    }
                    if ("oauth_nonce".equals(elements[0].trim())) {
                        params.setOauthNonce(this.removeLeadingAndTrailingQuatation(elements[1].trim()));
                        continue;
                    }
                    if ("oauth_signature".equals(elements[0].trim())) {
                        params.setOauthSignature(this.removeLeadingAndTrailingQuatation(elements[1].trim()));
                        continue;
                    }
                    if ("oauth_signature_method".equals(elements[0].trim())) {
                        params.setOauthSignatureMethod(this.removeLeadingAndTrailingQuatation(elements[1].trim()));
                        continue;
                    }
                    if ("oauth_timestamp".equals(elements[0].trim())) {
                        params.setOauthTimeStamp(this.removeLeadingAndTrailingQuatation(elements[1].trim()));
                        continue;
                    }
                    if ("oauth_callback".equals(elements[0].trim())) {
                        params.setOauthCallback(this.removeLeadingAndTrailingQuatation(elements[1].trim()));
                        continue;
                    }
                    if ("scope".equals(elements[0].trim())) {
                        params.setScope(this.removeLeadingAndTrailingQuatation(elements[1].trim()));
                        continue;
                    }
                    if ("xoauth_displayname".equals(elements[0].trim())) {
                        params.setDisplayName(this.removeLeadingAndTrailingQuatation(elements[1].trim()));
                        continue;
                    }
                    if ("oauth_token".equals(elements[0].trim())) {
                        params.setOauthToken(this.removeLeadingAndTrailingQuatation(elements[1].trim()));
                        continue;
                    }
                    if ("oauth_verifier".equals(elements[0].trim())) {
                        params.setOauthTokenVerifier(this.removeLeadingAndTrailingQuatation(elements[1].trim()));
                        continue;
                    }
                    if ("oauth_token_secret".equals(elements[0].trim())) {
                        params.setOauthTokenSecret(this.removeLeadingAndTrailingQuatation(elements[1].trim()));
                        continue;
                    }
                    if ("oauth_version".equals(elements[0].trim())) {
                        params.setVersion(this.removeLeadingAndTrailingQuatation(elements[1].trim()));
                        continue;
                    }
                    nonAuthParams.append(elements[0].trim() + "=" + this.removeLeadingAndTrailingQuatation(elements[1].trim()) + "&");
                }
            }
        }
        String nonOauthParamStr = nonAuthParams.toString();
        if (!noAuthorizationHeader) {
            nonOauthParamStr = queryString + "&";
        }
        if ((scope = (String)synCtx.getProperty("scope")) == null) {
            throw new SynapseException("Unable to find SCOPE value in Synapse Message Context");
        }
        params.setScope(scope);
        params.setHttpMethod((String)msgContext.getProperty("HTTP_METHOD"));
        String prefix = (String)msgContext.getProperty("SERVICE_PREFIX");
        if (nonOauthParamStr.length() > 1) {
            params.setBaseString(prefix + operation + nonOauthParamStr.substring(0, nonOauthParamStr.length() - 1));
        } else {
            params.setBaseString(prefix);
        }
        return params;
    }

    private String removeLeadingAndTrailingQuatation(String base) {
        String result = base;
        if (base.startsWith("\"") || base.endsWith("\"")) {
            result = base.replace("\"", "");
        }
        return result.trim();
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getRemoteServiceUrl() {
        if (this.remoteServiceUrl != null && !this.remoteServiceUrl.endsWith("/")) {
            this.remoteServiceUrl = this.remoteServiceUrl + "/";
        }
        return this.remoteServiceUrl;
    }

    public void setRemoteServiceUrl(String remoteServiceUrl) {
        this.remoteServiceUrl = remoteServiceUrl;
    }

    public boolean isContentAware() {
        return false;
    }
}

