/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.jms;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.Reference;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.core.axis2.Axis2MessageContext;

public class JMSUtils {
    private static final Log log = LogFactory.getLog(JMSUtils.class);

    public static String inferJMSMessageType(Message msg) {
        if (JMSUtils.isTextMessage(msg)) {
            return TextMessage.class.getName();
        }
        if (JMSUtils.isBytesMessage(msg)) {
            return BytesMessage.class.getName();
        }
        if (JMSUtils.isObjectMessage(msg)) {
            return ObjectMessage.class.getName();
        }
        if (JMSUtils.isStreamMessage(msg)) {
            return StreamMessage.class.getName();
        }
        if (JMSUtils.isMapMessage(msg)) {
            return MapMessage.class.getName();
        }
        return null;
    }

    public static void convertXMLtoJMSMap(OMElement element, MapMessage message) throws JMSException {
        Iterator itr = element.getChildElements();
        while (itr.hasNext()) {
            OMElement elem = (OMElement)itr.next();
            message.setString(elem.getLocalName(), elem.getText());
        }
    }

    static boolean checkIfBooleanPropertyIsSet(String propertyName, org.apache.synapse.MessageContext msgContext) {
        boolean isPropertySet = false;
        Object booleanProperty = msgContext.getProperty(propertyName);
        if (booleanProperty != null) {
            if (booleanProperty instanceof Boolean && ((Boolean)booleanProperty).booleanValue() || booleanProperty instanceof String && Boolean.valueOf((String)booleanProperty).booleanValue()) {
                isPropertySet = true;
            }
        } else {
            booleanProperty = ((Axis2MessageContext)msgContext).getAxis2MessageContext().getProperty(propertyName);
            if (booleanProperty instanceof Boolean && ((Boolean)booleanProperty).booleanValue() || booleanProperty instanceof String && Boolean.valueOf((String)booleanProperty).booleanValue()) {
                isPropertySet = true;
            }
        }
        return isPropertySet;
    }

    public static void setTransportHeaders(MessageContext msgContext, Message message) throws JMSException {
        Map headerMap = (Map)msgContext.getProperty("TRANSPORT_HEADERS");
        if (headerMap == null) {
            return;
        }
        for (Object headerName : headerMap.keySet()) {
            Number value;
            Object header;
            String name = (String)headerName;
            if (name.startsWith("JMSX") && !name.equals("JMSXGroupID") && !name.equals("JMSXGroupSeq")) continue;
            if ("JMS_COORELATION_ID".equals(name)) {
                message.setJMSCorrelationID((String)headerMap.get("JMS_COORELATION_ID"));
                continue;
            }
            if ("JMS_DELIVERY_MODE".equals(name)) {
                header = headerMap.get("JMS_DELIVERY_MODE");
                value = JMSUtils.parseHeaderToInt(header);
                if (value == null) continue;
                message.setJMSDeliveryMode(((Integer)value).intValue());
                continue;
            }
            if ("JMS_EXPIRATION".equals(name)) {
                header = headerMap.get("JMS_EXPIRATION");
                value = JMSUtils.parseHeaderToLong(header);
                if (value == null) continue;
                message.setJMSExpiration(((Long)value).longValue());
                continue;
            }
            if ("JMS_MESSAGE_ID".equals(name)) {
                message.setJMSMessageID((String)headerMap.get("JMS_MESSAGE_ID"));
                continue;
            }
            if ("JMS_PRIORITY".equals(name)) {
                header = headerMap.get("JMS_PRIORITY");
                value = JMSUtils.parseHeaderToInt(header);
                if (value == null) continue;
                message.setJMSPriority(((Integer)value).intValue());
                continue;
            }
            if ("JMS_TIMESTAMP".equals(name)) {
                header = headerMap.get("JMS_TIMESTAMP");
                value = JMSUtils.parseHeaderToLong(header);
                if (value == null) continue;
                message.setJMSTimestamp(((Long)value).longValue());
                continue;
            }
            if ("JMS_MESSAGE_TYPE".equals(name)) {
                message.setJMSType((String)headerMap.get("JMS_MESSAGE_TYPE"));
                continue;
            }
            Object value2 = headerMap.get(name);
            if (value2 instanceof String) {
                if (name.contains("-")) {
                    if (JMSUtils.isHyphenReplaceMode(msgContext)) {
                        message.setStringProperty(JMSUtils.transformHyphenatedString(name), (String)value2);
                        continue;
                    }
                    if (JMSUtils.isHyphenDeleteMode(msgContext)) continue;
                    message.setStringProperty(name, (String)value2);
                    continue;
                }
                message.setStringProperty(name, (String)value2);
                continue;
            }
            if (value2 instanceof Boolean) {
                message.setBooleanProperty(name, ((Boolean)value2).booleanValue());
                continue;
            }
            if (value2 instanceof Integer) {
                message.setIntProperty(name, ((Integer)value2).intValue());
                continue;
            }
            if (value2 instanceof Long) {
                message.setLongProperty(name, ((Long)value2).longValue());
                continue;
            }
            if (value2 instanceof Double) {
                message.setDoubleProperty(name, ((Double)value2).doubleValue());
                continue;
            }
            if (!(value2 instanceof Float)) continue;
            message.setFloatProperty(name, ((Float)value2).floatValue());
        }
    }

    private static Long parseHeaderToLong(Object header) {
        if (header instanceof Long) {
            return (Long)header;
        }
        if (header instanceof String) {
            try {
                return Long.parseLong((String)header);
            }
            catch (NumberFormatException nfe) {
                log.warn((Object)("Invalid header ignored : " + header), (Throwable)nfe);
            }
        } else {
            log.warn((Object)("Invalid header ignored : " + header));
        }
        return null;
    }

    private static Integer parseHeaderToInt(Object header) {
        if (header instanceof Integer) {
            return (Integer)header;
        }
        if (header instanceof String) {
            try {
                return Integer.parseInt((String)header);
            }
            catch (NumberFormatException nfe) {
                log.warn((Object)("Invalid header ignored : " + header), (Throwable)nfe);
            }
        } else {
            log.warn((Object)("Invalid header ignored : " + header));
        }
        return null;
    }

    public static Destination lookupDestination(Context context, String destinationName, String destinationType) throws NamingException {
        if (destinationName == null) {
            return null;
        }
        try {
            return JMSUtils.lookup(context, Destination.class, destinationName);
        }
        catch (NameNotFoundException e) {
            try {
                Properties initialContextProperties = new Properties();
                if (context.getEnvironment() != null) {
                    if (context.getEnvironment().get("java.naming.factory.initial") != null) {
                        initialContextProperties.put("java.naming.factory.initial", context.getEnvironment().get("java.naming.factory.initial"));
                    }
                    if (context.getEnvironment().get("connectionfactory.QueueConnectionFactory") != null) {
                        initialContextProperties.put("connectionfactory.QueueConnectionFactory", context.getEnvironment().get("connectionfactory.QueueConnectionFactory"));
                    }
                    if (context.getEnvironment().get("java.naming.provider.url") != null) {
                        initialContextProperties.put("java.naming.provider.url", context.getEnvironment().get("java.naming.provider.url"));
                    }
                }
                if ("topic".equalsIgnoreCase(destinationType)) {
                    initialContextProperties.put("topic." + destinationName, destinationName);
                } else if ("queue".equalsIgnoreCase(destinationType) || "generic".equalsIgnoreCase(destinationType)) {
                    initialContextProperties.put("queue." + destinationName, destinationName);
                }
                InitialContext initialContext = new InitialContext(initialContextProperties);
                try {
                    return JMSUtils.lookup(initialContext, Destination.class, destinationName);
                }
                catch (NamingException e1) {
                    return JMSUtils.lookup(context, Destination.class, ("topic".equalsIgnoreCase(destinationType) ? "dynamicTopics/" : "dynamicQueues/") + destinationName);
                }
            }
            catch (NamingException x) {
                log.warn((Object)("Cannot locate destination : " + destinationName));
                throw x;
            }
        }
        catch (NamingException e) {
            log.warn((Object)("Cannot locate destination : " + destinationName), (Throwable)e);
            throw e;
        }
    }

    private static <T> T lookup(Context context, Class<T> clazz, String name) throws NamingException {
        Object object = context.lookup(name);
        try {
            return clazz.cast(object);
        }
        catch (ClassCastException ex) {
            if (object instanceof Reference) {
                Reference ref = (Reference)object;
                JMSUtils.handleException("JNDI failed to de-reference Reference with name " + name + "; is the factory " + ref.getFactoryClassName() + " in your classpath?");
                return null;
            }
            JMSUtils.handleException("JNDI lookup of name " + name + " returned a " + object.getClass().getName() + " while a " + clazz + " was expected");
            return null;
        }
    }

    protected static void handleException(String s) throws NamingException {
        log.error((Object)s);
        throw new NamingException(s);
    }

    public static Map<String, Object> getTransportHeaders(Message message, MessageContext msgContext) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            Enumeration propertyNamesEnm = message.getPropertyNames();
            while (propertyNamesEnm.hasMoreElements()) {
                String headerName = (String)propertyNamesEnm.nextElement();
                Object headerValue = message.getObjectProperty(headerName);
                if (headerValue instanceof String) {
                    if (JMSUtils.isHyphenReplaceMode(msgContext)) {
                        map.put(JMSUtils.inverseTransformHyphenatedString(headerName), message.getStringProperty(headerName));
                        continue;
                    }
                    map.put(headerName, message.getStringProperty(headerName));
                    continue;
                }
                if (headerValue instanceof Integer) {
                    map.put(headerName, message.getIntProperty(headerName));
                    continue;
                }
                if (headerValue instanceof Boolean) {
                    map.put(headerName, message.getBooleanProperty(headerName));
                    continue;
                }
                if (headerValue instanceof Long) {
                    map.put(headerName, message.getLongProperty(headerName));
                    continue;
                }
                if (headerValue instanceof Double) {
                    map.put(headerName, message.getDoubleProperty(headerName));
                    continue;
                }
                if (headerValue instanceof Float) {
                    map.put(headerName, Float.valueOf(message.getFloatProperty(headerName)));
                    continue;
                }
                map.put(headerName, headerValue);
            }
        }
        catch (JMSException e) {
            log.error((Object)"Error while reading the Transport Headers from JMS Message", (Throwable)e);
        }
        return map;
    }

    private static boolean isHyphenReplaceMode(MessageContext msgContext) {
        if (msgContext == null) {
            return false;
        }
        String hyphenSupport = (String)msgContext.getProperty("transport.jms.MessagePropertyHyphens");
        return hyphenSupport != null && hyphenSupport.equals("replace");
    }

    private static String transformHyphenatedString(String name) {
        return name.replaceAll("-", "_DASHED_");
    }

    private static boolean isHyphenDeleteMode(MessageContext msgContext) {
        if (msgContext == null) {
            return false;
        }
        String hyphenSupport = (String)msgContext.getProperty("transport.jms.MessagePropertyHyphens");
        return hyphenSupport != null && hyphenSupport.equals("delete");
    }

    private static boolean isTextMessage(Message msg) {
        return msg instanceof TextMessage;
    }

    private static boolean isMapMessage(Message msg) {
        return msg instanceof MapMessage;
    }

    private static boolean isStreamMessage(Message msg) {
        return msg instanceof StreamMessage;
    }

    private static boolean isObjectMessage(Message msg) {
        return msg instanceof ObjectMessage;
    }

    private static boolean isBytesMessage(Message msg) {
        return msg instanceof BytesMessage;
    }

    private static String inverseTransformHyphenatedString(String name) {
        return name.replaceAll("_DASHED_", "-");
    }
}

