/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.rabbitmq;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.Builder;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.builder.SOAPBuilder;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.TransportUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.inbound.endpoint.protocol.rabbitmq.RabbitMQAckStates;
import org.wso2.carbon.inbound.endpoint.protocol.rabbitmq.RabbitMQMessage;
import org.wso2.carbon.inbound.endpoint.protocol.rabbitmq.RabbitMQUtils;
import org.wso2.carbon.inbound.endpoint.protocol.rabbitmq.States;

public class RabbitMQInjectHandler {
    private static final Log log = LogFactory.getLog(RabbitMQInjectHandler.class);
    private String injectingSeq;
    private String onErrorSeq;
    private boolean sequential;
    private SynapseEnvironment synapseEnvironment;
    private SequenceMediator seq;

    public RabbitMQInjectHandler(String injectingSeq, String onErrorSeq, boolean sequential, SynapseEnvironment synapseEnvironment) throws SynapseException {
        this.injectingSeq = injectingSeq;
        if (injectingSeq == null || injectingSeq.equals("")) {
            String msg = "Injecting Sequence name is not specified.";
            log.error((Object)msg);
            throw new SynapseException(msg);
        }
        this.seq = (SequenceMediator)synapseEnvironment.getSynapseConfiguration().getSequence(injectingSeq);
        if (this.seq == null) {
            throw new SynapseException("Specified injecting sequence: " + injectingSeq + "is invalid.");
        }
        if (!this.seq.isInitialized()) {
            this.seq.init(synapseEnvironment);
        }
        this.onErrorSeq = onErrorSeq;
        this.sequential = sequential;
        this.synapseEnvironment = synapseEnvironment;
    }

    public States invokeAndReturnAckState(RabbitMQMessage message, String inboundName) {
        org.apache.synapse.MessageContext msgCtx = null;
        try {
            int index;
            msgCtx = this.createMessageContext();
            log.debug((Object)"Processed RabbitMQ Message ");
            MessageContext axis2MsgCtx = ((Axis2MessageContext)msgCtx).getAxis2MessageContext();
            String amqpCorrelationID = message.getCorrelationId();
            if (amqpCorrelationID != null && amqpCorrelationID.length() > 0) {
                msgCtx.setProperty("rabbitmq.message.correlation.id", (Object)amqpCorrelationID);
            } else {
                msgCtx.setProperty("rabbitmq.message.correlation.id", (Object)message.getMessageId());
            }
            axis2MsgCtx.setProperty("TRANSPORT_HEADERS", (Object)RabbitMQUtils.getTransportHeaders(message));
            String contentType = message.getContentType();
            Builder builder = null;
            if (contentType == null) {
                log.warn((Object)("Unable to determine content type for message " + msgCtx.getMessageID() + " setting to text/plain"));
                contentType = "text/plain";
                message.setContentType(contentType);
            }
            String type = (index = contentType.indexOf(59)) > 0 ? contentType.substring(0, index) : contentType;
            try {
                builder = BuilderUtil.getBuilderFromSelector((String)type, (MessageContext)axis2MsgCtx);
            }
            catch (AxisFault axisFault) {
                log.error((Object)("Error while creating message builder :: " + axisFault.getMessage()));
            }
            if (builder == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("No message builder found for type '" + type + "'. Falling back to SOAP."));
                }
                builder = new SOAPBuilder();
            }
            OMElement documentElement = null;
            ByteArrayInputStream in = new ByteArrayInputStream(message.getBody());
            try {
                documentElement = builder.processDocument((InputStream)in, contentType, axis2MsgCtx);
            }
            catch (AxisFault axisFault) {
                log.error((Object)("Error while processing message :: " + axisFault.getMessage()));
            }
            try {
                msgCtx.setEnvelope(TransportUtils.createSOAPEnvelope((OMElement)documentElement));
            }
            catch (AxisFault axisFault) {
                log.error((Object)("Error while setting message payload to the message context :: " + axisFault.getMessage()));
            }
            if (this.seq != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("injecting message to sequence : " + this.injectingSeq));
                }
                this.seq.setErrorHandler(this.onErrorSeq);
                msgCtx.setProperty("isInbound", (Object)true);
                msgCtx.setProperty("inbound.endpoint.name", (Object)inboundName);
                msgCtx.setProperty("ARTIFACT_NAME", (Object)("inboundendpoint" + inboundName));
                this.synapseEnvironment.injectInbound(msgCtx, this.seq, this.sequential);
            } else {
                log.error((Object)("Sequence: " + this.injectingSeq + " not found"));
            }
            if (this.readMessageCtxProperty(msgCtx, "SET_ROLLBACK_ONLY", false)) {
                if (this.readMessageCtxProperty(msgCtx, "SET_REQUEUE_ON_ROLLBACK", true)) {
                    return new States(RabbitMQAckStates.REJECT_AND_REQUEUE, false);
                }
                return new States(RabbitMQAckStates.REJECT, false);
            }
            return new States(RabbitMQAckStates.ACK, false);
        }
        catch (Exception e) {
            if (this.readMessageCtxProperty(msgCtx, "SET_REQUEUE_ON_ROLLBACK", false)) {
                log.error((Object)"Error while mediating message. Message is requeued as SET_REQUEUE_ON_ROLLBACK property is set to true.", (Throwable)e);
                return new States(RabbitMQAckStates.REJECT_AND_REQUEUE, true);
            }
            log.error((Object)"Error while mediating message. Message is rejected.", (Throwable)e);
            return new States(RabbitMQAckStates.REJECT, true);
        }
    }

    private boolean readMessageCtxProperty(org.apache.synapse.MessageContext msgCtx, String propertyName, boolean defaultValue) {
        Object propertyObj = msgCtx.getProperty(propertyName);
        if (propertyObj != null) {
            if (propertyObj instanceof Boolean && ((Boolean)propertyObj).booleanValue() || propertyObj instanceof String && "true".equals(propertyObj)) {
                return true;
            }
            if (propertyObj instanceof Boolean || propertyObj instanceof String && "false".equals(propertyObj)) {
                return false;
            }
        }
        return defaultValue;
    }

    private org.apache.synapse.MessageContext createMessageContext() {
        org.apache.synapse.MessageContext msgCtx = this.synapseEnvironment.createMessageContext();
        MessageContext axis2MsgCtx = ((Axis2MessageContext)msgCtx).getAxis2MessageContext();
        axis2MsgCtx.setServerSide(true);
        axis2MsgCtx.setMessageID(UUIDGenerator.getUUID());
        msgCtx.setProperty("ClientApiNonBlocking", (Object)true);
        PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        axis2MsgCtx.setProperty("tenantDomain", (Object)carbonContext.getTenantDomain());
        return msgCtx;
    }
}

