/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.rabbitmq;

import com.rabbitmq.client.Address;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.inbound.endpoint.protocol.rabbitmq.RabbitMQException;
import org.wso2.carbon.inbound.endpoint.protocol.rabbitmq.RabbitMQMessage;

public class RabbitMQUtils {
    private static final Log log = LogFactory.getLog(RabbitMQUtils.class);

    public static Connection createConnection(ConnectionFactory factory, Address[] addresses) throws IOException {
        Connection connection = null;
        try {
            connection = factory.newConnection(addresses);
        }
        catch (TimeoutException e) {
            log.error((Object)"Error while creating new connection", (Throwable)e);
        }
        return connection;
    }

    public static String getProperty(MessageContext mc, String key) {
        return (String)mc.getProperty(key);
    }

    public static Map getTransportHeaders(RabbitMQMessage message) {
        Map<String, Object> headers;
        HashMap<String, String> map = new HashMap<String, String>();
        if (message.getCorrelationId() != null) {
            map.put("rabbitmq.message.correlation.id", message.getCorrelationId());
        }
        if (message.getMessageId() != null) {
            map.put("rabbitmq.message.id", message.getMessageId());
        }
        if (message.getReplyTo() != null) {
            String dest = message.getReplyTo();
            map.put("RABBITMQ_REPLY_TO", dest);
        }
        if (message.getExpiration() != null) {
            String expiration = message.getExpiration();
            map.put("rabbitmq.message.expiration", expiration);
        }
        if ((headers = message.getHeaders()) != null && !headers.isEmpty()) {
            for (String headerName : headers.keySet()) {
                String value = headers.get(headerName).toString();
                map.put(headerName, value);
            }
        }
        return map;
    }

    public static boolean isDurableQueue(Hashtable<String, String> properties) {
        String durable = properties.get("rabbitmq.queue.durable");
        return durable != null && Boolean.parseBoolean(durable);
    }

    public static boolean isExclusiveQueue(Hashtable<String, String> properties) {
        String exclusive = properties.get("rabbitmq.queue.exclusive");
        return exclusive != null && Boolean.parseBoolean(exclusive);
    }

    public static boolean isAutoDeleteQueue(Hashtable<String, String> properties) {
        String autoDelete = properties.get("rabbitmq.queue.auto.delete");
        return autoDelete != null && Boolean.parseBoolean(autoDelete);
    }

    public static boolean isQueueAvailable(Connection connection, String queueName) throws IOException {
        Channel channel = connection.createChannel();
        try {
            channel.queueDeclarePassive(queueName);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static void declareQueue(Connection connection, String queueName, boolean isDurable, boolean isExclusive, boolean isAutoDelete) throws IOException {
        boolean queueAvailable = RabbitMQUtils.isQueueAvailable(connection, queueName);
        Channel channel = connection.createChannel();
        if (!queueAvailable) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Queue :" + queueName + " not found or already declared exclusive. Declaring the queue."));
            }
            if (!channel.isOpen()) {
                channel = connection.createChannel();
                log.debug((Object)"Channel is not open. Creating a new channel.");
            }
            try {
                channel.queueDeclare(queueName, isDurable, isExclusive, isAutoDelete, null);
            }
            catch (IOException e) {
                RabbitMQUtils.handleException("Error while creating queue: " + queueName, e);
            }
        }
    }

    public static void declareQueue(Connection connection, String queueName, Hashtable<String, String> properties) throws IOException {
        Boolean queueAvailable = RabbitMQUtils.isQueueAvailable(connection, queueName);
        Channel channel = connection.createChannel();
        if (!queueAvailable.booleanValue()) {
            if (!channel.isOpen()) {
                channel = connection.createChannel();
                log.debug((Object)"Channel is not open. Creating a new channel.");
            }
            try {
                channel.queueDeclare(queueName, RabbitMQUtils.isDurableQueue(properties), RabbitMQUtils.isExclusiveQueue(properties), RabbitMQUtils.isAutoDeleteQueue(properties), null);
            }
            catch (IOException e) {
                RabbitMQUtils.handleException("Error while creating queue: " + queueName, e);
            }
        }
    }

    public static void declareExchange(Connection connection, String exchangeName, Hashtable<String, String> properties) throws IOException {
        Boolean exchangeAvailable = false;
        Channel channel = connection.createChannel();
        String exchangeType = properties.getOrDefault("rabbitmq.exchange.type", "direct");
        String durable = properties.getOrDefault("rabbitmq.exchange.durable", "true");
        String autoDelete = properties.getOrDefault("rabbitmq.exchange.auto.delete", "false");
        if (exchangeType.isEmpty()) {
            exchangeType = "direct";
        }
        if (durable.isEmpty()) {
            durable = "true";
        }
        if (autoDelete.isEmpty()) {
            autoDelete = "false";
        }
        try {
            channel.exchangeDeclarePassive(exchangeName);
            exchangeAvailable = true;
        }
        catch (IOException e) {
            log.info((Object)("Exchange :" + exchangeName + " not found.Declaring exchange."));
        }
        if (!exchangeAvailable.booleanValue()) {
            if (!channel.isOpen()) {
                channel = connection.createChannel();
                log.debug((Object)"Channel is not open. Creating a new channel.");
            }
            try {
                channel.exchangeDeclare(exchangeName, exchangeType, Boolean.parseBoolean(durable), Boolean.parseBoolean(autoDelete), null);
            }
            catch (IOException e) {
                RabbitMQUtils.handleException("Error occurred while declaring exchange.", e);
            }
        }
        try {
            channel.close();
        }
        catch (TimeoutException e) {
            log.error((Object)"Error occurred while closing connection.", (Throwable)e);
        }
    }

    public static void handleException(String message, Exception e) {
        log.error((Object)message, (Throwable)e);
        throw new RabbitMQException(message, e);
    }
}

