/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.hl7.context;

import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.parser.Parser;
import java.nio.charset.CharsetDecoder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.nio.reactor.IOSession;
import org.apache.synapse.transport.passthru.util.BufferFactory;
import org.wso2.carbon.inbound.endpoint.protocol.hl7.codec.HL7Codec;

public class MLLPContext {
    private static final Log log = LogFactory.getLog(MLLPContext.class);
    private IOSession session;
    private StringBuffer requestBuffer;
    private StringBuffer responseBuffer;
    private Message hl7Message;
    private volatile HL7Codec codec;
    private long requestTime;
    private int expiry;
    private boolean validateMessage;
    private volatile boolean autoAck = true;
    private volatile boolean nackMode = false;
    private volatile boolean markForClose = false;
    private boolean preProcess = true;
    private boolean applicationAck = false;
    private volatile String messageId;
    private Parser preProcessorParser = null;
    private BufferFactory bufferFactory;

    public MLLPContext(IOSession session, CharsetDecoder decoder, boolean autoAck, boolean validateMessage, Parser preProcessorParser, BufferFactory bufferFactory) {
        this.session = session;
        this.codec = new HL7Codec(decoder);
        this.autoAck = autoAck;
        this.validateMessage = validateMessage;
        this.preProcessorParser = preProcessorParser;
        this.bufferFactory = bufferFactory;
        this.expiry = 10000;
        this.requestBuffer = new StringBuffer();
        this.responseBuffer = new StringBuffer();
        if (preProcessorParser == null) {
            this.preProcess = false;
        }
    }

    public HL7Codec getCodec() {
        return this.codec;
    }

    public StringBuffer getRequestBuffer() {
        return this.requestBuffer;
    }

    public StringBuffer getResponseBuffer() {
        return this.responseBuffer;
    }

    public Message getHl7Message() {
        return this.hl7Message;
    }

    public void setHl7Message(Message hl7Message) {
        this.hl7Message = hl7Message;
    }

    public void requestOutput() {
        this.session.clearEvent(1);
        this.session.setEvent(4);
    }

    public void requestInput() {
        this.session.clearEvent(4);
        this.session.setEvent(1);
    }

    public void setRequestTime(long timeStamp) {
        this.requestTime = timeStamp;
    }

    public long getRequestTime() {
        return this.requestTime;
    }

    public void setExpiry(int milliseconds) {
        if (milliseconds < 1000) {
            milliseconds = 1000;
        }
        this.expiry = milliseconds;
    }

    public boolean isExpired() {
        return System.currentTimeMillis() > this.requestTime + (long)this.expiry;
    }

    public boolean isAutoAck() {
        return this.autoAck;
    }

    public void setAutoAck(boolean autoAck) {
        this.autoAck = autoAck;
    }

    public boolean isApplicationAck() {
        return this.applicationAck;
    }

    public void setApplicationAck(boolean applicationAck) {
        this.applicationAck = applicationAck;
    }

    public boolean isPreProcess() {
        return this.preProcess;
    }

    public boolean isNackMode() {
        return this.nackMode;
    }

    public void setNackMode(boolean nackMode) {
        this.nackMode = nackMode;
    }

    public Parser getPreProcessParser() {
        return this.preProcessorParser;
    }

    public BufferFactory getBufferFactory() {
        return this.bufferFactory;
    }

    public boolean isValidateMessage() {
        return this.validateMessage;
    }

    public void setValidateMessage(boolean validateMessage) {
        this.validateMessage = validateMessage;
    }

    public boolean isMarkForClose() {
        return this.markForClose;
    }

    public void setMarkForClose(boolean markForClose) {
        this.markForClose = markForClose;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public void reset() {
        this.responseBuffer.setLength(0);
        this.requestBuffer.setLength(0);
        this.getCodec().setState(0);
        this.setNackMode(false);
    }
}

