/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.hl7.core;

import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.nio.reactor.IOSession;
import org.wso2.carbon.inbound.endpoint.protocol.hl7.core.HL7Processor;
import org.wso2.carbon.inbound.endpoint.protocol.hl7.core.MLLPSourceHandler;

public class MultiIOHandler
extends MLLPSourceHandler {
    private static final Log log = LogFactory.getLog(MultiIOHandler.class);
    public ConcurrentHashMap<Integer, MLLPSourceHandler> handlers = new ConcurrentHashMap();
    private ConcurrentHashMap<Integer, HL7Processor> processorMap;
    private ConcurrentHashMap<String, IOSession> endpointSessions = new ConcurrentHashMap();

    public MultiIOHandler(ConcurrentHashMap<Integer, HL7Processor> processorMap) {
        this.processorMap = processorMap;
    }

    @Override
    public void connected(IOSession session) {
        InetSocketAddress remoteIsa = (InetSocketAddress)session.getRemoteAddress();
        InetSocketAddress localIsa = (InetSocketAddress)session.getLocalAddress();
        MLLPSourceHandler handler = new MLLPSourceHandler(this.processorMap.get(localIsa.getPort()));
        this.handlers.put(remoteIsa.getPort(), handler);
        this.endpointSessions.put(localIsa.getPort() + "-" + remoteIsa.getPort(), session);
        handler.connected(session);
    }

    @Override
    public void inputReady(IOSession session) {
        InetSocketAddress isa = (InetSocketAddress)session.getRemoteAddress();
        MLLPSourceHandler handler = this.handlers.get(isa.getPort());
        handler.inputReady(session);
    }

    @Override
    public void outputReady(IOSession session) {
        InetSocketAddress isa = (InetSocketAddress)session.getRemoteAddress();
        MLLPSourceHandler handler = this.handlers.get(isa.getPort());
        handler.outputReady(session);
    }

    @Override
    public void timeout(IOSession session) {
        InetSocketAddress isa = (InetSocketAddress)session.getRemoteAddress();
        InetSocketAddress localIsa = (InetSocketAddress)session.getLocalAddress();
        MLLPSourceHandler handler = this.handlers.get(isa.getPort());
        handler.timeout(session);
        this.handlers.remove(handler);
        this.endpointSessions.remove(localIsa.getPort() + "-" + isa.getPort());
    }

    @Override
    public void disconnected(IOSession session) {
        InetSocketAddress isa = (InetSocketAddress)session.getRemoteAddress();
        InetSocketAddress localIsa = (InetSocketAddress)session.getLocalAddress();
        if (isa == null) {
            return;
        }
        MLLPSourceHandler handler = this.handlers.get(isa.getPort());
        handler.disconnected(session);
        this.handlers.remove(handler);
        this.endpointSessions.remove(localIsa.getPort() + "-" + isa.getPort());
    }

    public void disconnectSessions(int localPort) {
        for (Map.Entry<String, IOSession> entry : this.endpointSessions.entrySet()) {
            if (!entry.getKey().startsWith(String.valueOf(localPort))) continue;
            IOSession session = entry.getValue();
            this.disconnected(session);
        }
    }
}

