/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.jms.factory;

import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.inbound.endpoint.protocol.jms.JMSConstants;
import org.wso2.carbon.inbound.endpoint.protocol.jms.JMSUtils;

public class JMSConnectionFactory
implements ConnectionFactory,
QueueConnectionFactory,
TopicConnectionFactory {
    private static final Log logger = LogFactory.getLog((String)JMSConnectionFactory.class.getName());
    protected Context ctx;
    protected ConnectionFactory connectionFactory;
    protected String connectionFactoryString;
    protected JMSConstants.JMSDestinationType destinationType;
    private Destination destination;
    protected String destinationName;
    protected boolean transactedSession = false;
    protected int sessionAckMode = 0;
    protected String jmsSpec;
    protected boolean isDurable;
    protected boolean noPubSubLocal;
    protected String clientId;
    protected String subscriptionName;
    protected String messageSelector;
    protected boolean isSharedSubscription;

    public JMSConnectionFactory(Properties properties) {
        String strTransactedSession;
        String msgSelector;
        String subDurable;
        try {
            this.ctx = new InitialContext(properties);
        }
        catch (NamingException e) {
            logger.error((Object)("NamingException while obtaining initial context. " + e.getMessage()), (Throwable)e);
        }
        String connectionFactoryType = properties.getProperty(JMSConstants.CONNECTION_FACTORY_TYPE);
        this.destinationType = "topic".equals(connectionFactoryType) ? JMSConstants.JMSDestinationType.TOPIC : JMSConstants.JMSDestinationType.QUEUE;
        this.jmsSpec = properties.getProperty("transport.jms.JMSSpecVersion") == null || "1.1".equals(properties.getProperty("transport.jms.JMSSpecVersion")) ? "1.1" : ("2.0".equals(properties.getProperty("transport.jms.JMSSpecVersion")) ? "2.0" : "1.0");
        this.isSharedSubscription = "true".equalsIgnoreCase(properties.getProperty("transport.jms.SharedSubscription"));
        this.noPubSubLocal = Boolean.valueOf(properties.getProperty("transport.jms.PubSubNoLocal"));
        this.clientId = properties.getProperty("transport.jms.DurableSubscriberClientID");
        this.subscriptionName = properties.getProperty("transport.jms.DurableSubscriberName");
        if (this.isSharedSubscription && this.subscriptionName == null) {
            logger.info((Object)"Subscription name is not given. Therefor declaring a non-shared subscription");
            this.isSharedSubscription = false;
        }
        if ((subDurable = properties.getProperty("transport.jms.SubscriptionDurable")) != null) {
            this.isDurable = Boolean.parseBoolean(subDurable);
        }
        if ((msgSelector = properties.getProperty("transport.jms.MessageSelector")) != null) {
            this.messageSelector = msgSelector;
        }
        this.connectionFactoryString = properties.getProperty(JMSConstants.CONNECTION_FACTORY_JNDI_NAME);
        if (this.connectionFactoryString == null || "".equals(this.connectionFactoryString)) {
            this.connectionFactoryString = "QueueConnectionFactory";
        }
        this.destinationName = properties.getProperty(JMSConstants.DESTINATION_NAME);
        if (this.destinationName == null || "".equals(this.destinationName)) {
            this.destinationName = "QUEUE_" + System.currentTimeMillis();
        }
        if ((strTransactedSession = properties.getProperty(JMSConstants.SESSION_TRANSACTED)) == null || "".equals(strTransactedSession) || !strTransactedSession.equals("true")) {
            this.transactedSession = false;
        } else if ("true".equals(strTransactedSession)) {
            this.transactedSession = true;
            logger.warn((Object)"Usage of transport.jms.SessionTransacted property is deprecated. Please use SESSION_TRANSACTED acknowledge mode to create a transacted session");
        }
        String strSessionAck = properties.getProperty(JMSConstants.SESSION_ACK);
        if (null == strSessionAck) {
            this.sessionAckMode = 1;
        } else if (strSessionAck.equals("AUTO_ACKNOWLEDGE")) {
            this.sessionAckMode = 1;
        } else if (strSessionAck.equals("CLIENT_ACKNOWLEDGE")) {
            this.sessionAckMode = 2;
        } else if (strSessionAck.equals("DUPS_OK_ACKNOWLEDGE")) {
            this.sessionAckMode = 3;
        } else if (strSessionAck.equals("SESSION_TRANSACTED")) {
            this.sessionAckMode = 0;
            this.transactedSession = true;
        } else {
            this.sessionAckMode = 1;
        }
        this.createConnectionFactory();
    }

    public ConnectionFactory getConnectionFactory() {
        if (this.connectionFactory != null) {
            return this.connectionFactory;
        }
        return this.createConnectionFactory();
    }

    private ConnectionFactory createConnectionFactory() {
        if (this.connectionFactory != null) {
            return this.connectionFactory;
        }
        if (this.ctx == null) {
            return null;
        }
        try {
            if (this.destinationType.equals((Object)JMSConstants.JMSDestinationType.QUEUE)) {
                this.connectionFactory = (QueueConnectionFactory)this.ctx.lookup(this.connectionFactoryString);
            } else if (this.destinationType.equals((Object)JMSConstants.JMSDestinationType.TOPIC)) {
                this.connectionFactory = (TopicConnectionFactory)this.ctx.lookup(this.connectionFactoryString);
            }
        }
        catch (NamingException e) {
            logger.error((Object)("Naming exception while obtaining connection factory for '" + this.connectionFactoryString + "'"), (Throwable)e);
        }
        return this.connectionFactory;
    }

    public Connection getConnection() {
        return this.createConnection();
    }

    public Connection createConnection() {
        if (this.connectionFactory == null) {
            logger.error((Object)"Connection cannot be establish to the broker. Please check the broker libs provided.");
            return null;
        }
        QueueConnection connection = null;
        try {
            if ("1.1".equals(this.jmsSpec)) {
                if (this.destinationType.equals((Object)JMSConstants.JMSDestinationType.QUEUE)) {
                    connection = ((QueueConnectionFactory)this.connectionFactory).createQueueConnection();
                } else if (this.destinationType.equals((Object)JMSConstants.JMSDestinationType.TOPIC)) {
                    connection = ((TopicConnectionFactory)this.connectionFactory).createTopicConnection();
                }
                if (this.isDurable) {
                    connection.setClientID(this.clientId);
                }
                return connection;
            }
            QueueConnectionFactory qConFac = null;
            TopicConnectionFactory tConFac = null;
            if (this.destinationType.equals((Object)JMSConstants.JMSDestinationType.QUEUE)) {
                qConFac = (QueueConnectionFactory)this.connectionFactory;
            } else {
                tConFac = (TopicConnectionFactory)this.connectionFactory;
            }
            if (qConFac != null) {
                connection = qConFac.createQueueConnection();
            } else if (tConFac != null) {
                connection = tConFac.createTopicConnection();
            }
            if (this.isDurable && !this.isSharedSubscription) {
                connection.setClientID(this.clientId);
            }
            return connection;
        }
        catch (JMSException e) {
            logger.error((Object)("JMS Exception while creating connection through factory '" + this.connectionFactoryString + "' " + e.getMessage()), (Throwable)e);
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    public Connection createConnection(String userName, String password) {
        if (this.connectionFactory == null) {
            logger.error((Object)"Connection cannot be establish to the broker. Please check the broker libs provided.");
            return null;
        }
        QueueConnection connection = null;
        try {
            if ("1.1".equals(this.jmsSpec)) {
                if (this.destinationType.equals((Object)JMSConstants.JMSDestinationType.QUEUE)) {
                    connection = ((QueueConnectionFactory)this.connectionFactory).createQueueConnection(userName, password);
                } else if (this.destinationType.equals((Object)JMSConstants.JMSDestinationType.TOPIC)) {
                    connection = ((TopicConnectionFactory)this.connectionFactory).createTopicConnection(userName, password);
                }
                if (this.isDurable) {
                    connection.setClientID(this.clientId);
                }
                return connection;
            }
            QueueConnectionFactory qConFac = null;
            TopicConnectionFactory tConFac = null;
            if (this.destinationType.equals((Object)JMSConstants.JMSDestinationType.QUEUE)) {
                qConFac = (QueueConnectionFactory)this.connectionFactory;
            } else {
                tConFac = (TopicConnectionFactory)this.connectionFactory;
            }
            if (qConFac != null) {
                connection = qConFac.createQueueConnection(userName, password);
            } else if (tConFac != null) {
                connection = tConFac.createTopicConnection(userName, password);
            }
            if (this.isDurable && !this.isSharedSubscription) {
                connection.setClientID(this.clientId);
            }
            return connection;
        }
        catch (JMSException e) {
            logger.error((Object)("JMS Exception while creating connection through factory '" + this.connectionFactoryString + "' " + e.getMessage()));
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    public QueueConnection createQueueConnection() throws JMSException {
        try {
            return ((QueueConnectionFactory)this.connectionFactory).createQueueConnection();
        }
        catch (JMSException e) {
            logger.error((Object)("JMS Exception while creating queue connection through factory '" + this.connectionFactoryString + "' " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public QueueConnection createQueueConnection(String userName, String password) throws JMSException {
        try {
            return ((QueueConnectionFactory)this.connectionFactory).createQueueConnection(userName, password);
        }
        catch (JMSException e) {
            logger.error((Object)("JMS Exception while creating queue connection through factory '" + this.connectionFactoryString + "' " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public TopicConnection createTopicConnection() throws JMSException {
        try {
            return ((TopicConnectionFactory)this.connectionFactory).createTopicConnection();
        }
        catch (JMSException e) {
            logger.error((Object)("JMS Exception while creating topic connection through factory '" + this.connectionFactoryString + "' " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public TopicConnection createTopicConnection(String userName, String password) throws JMSException {
        try {
            return ((TopicConnectionFactory)this.connectionFactory).createTopicConnection(userName, password);
        }
        catch (JMSException e) {
            logger.error((Object)("JMS Exception while creating topic connection through factory '" + this.connectionFactoryString + "' " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public Destination getDestination(Session session) {
        if (this.destination != null) {
            return this.destination;
        }
        return this.createDestination(session);
    }

    public MessageConsumer createMessageConsumer(Session session, Destination destination) {
        try {
            if ("2.0".equals(this.jmsSpec) && this.isSharedSubscription) {
                if (this.isDurable) {
                    return session.createSharedDurableConsumer((Topic)destination, this.subscriptionName, this.messageSelector);
                }
                return session.createSharedConsumer((Topic)destination, this.subscriptionName, this.messageSelector);
            }
            if ("1.1".equals(this.jmsSpec) || "2.0".equals(this.jmsSpec) && !this.isSharedSubscription) {
                if (this.isDurable) {
                    return session.createDurableSubscriber((Topic)destination, this.subscriptionName, this.messageSelector, this.noPubSubLocal);
                }
                return session.createConsumer(destination, this.messageSelector);
            }
            if (this.destinationType.equals((Object)JMSConstants.JMSDestinationType.QUEUE)) {
                return ((QueueSession)session).createReceiver((Queue)destination, this.messageSelector);
            }
            if (this.isDurable) {
                return ((TopicSession)session).createDurableSubscriber((Topic)destination, this.subscriptionName, this.messageSelector, this.noPubSubLocal);
            }
            return ((TopicSession)session).createSubscriber((Topic)destination, this.messageSelector, false);
        }
        catch (JMSException e) {
            logger.error((Object)("JMS Exception while creating consumer. " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public MessageProducer createProducer(Session session, Destination destination, Boolean isQueue) throws JMSException {
        if ("2.0".equals(this.jmsSpec) || "1.1".equals(this.jmsSpec) || isQueue == null) {
            return session.createProducer(destination);
        }
        if (isQueue.booleanValue()) {
            return ((QueueSession)session).createSender((Queue)destination);
        }
        return ((TopicSession)session).createPublisher((Topic)destination);
    }

    private Destination createDestination(Session session) {
        this.destination = this.createDestination(session, this.destinationName);
        return this.destination;
    }

    public Destination createDestination(Session session, String destinationName) {
        Destination destination = null;
        try {
            if (this.destinationType.equals((Object)JMSConstants.JMSDestinationType.QUEUE)) {
                destination = JMSUtils.lookupDestination(this.ctx, destinationName, "queue");
            } else if (this.destinationType.equals((Object)JMSConstants.JMSDestinationType.TOPIC)) {
                destination = JMSUtils.lookupDestination(this.ctx, destinationName, "topic");
            }
        }
        catch (NameNotFoundException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Could not find destination '" + destinationName + "' on connection factory for '" + this.connectionFactoryString + "'. " + e.getMessage()));
                logger.debug((Object)("Creating destination '" + destinationName + "' on connection factory for '" + this.connectionFactoryString + "."));
            }
            try {
                if (this.destinationType.equals((Object)JMSConstants.JMSDestinationType.QUEUE)) {
                    destination = session.createQueue(destinationName);
                } else if (this.destinationType.equals((Object)JMSConstants.JMSDestinationType.TOPIC)) {
                    destination = session.createTopic(destinationName);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Created '" + destinationName + "' on connection factory for '" + this.connectionFactoryString + "'."));
                }
            }
            catch (JMSException e1) {
                logger.error((Object)("Could not find nor create '" + destinationName + "' on connection factory for '" + this.connectionFactoryString + "'. " + e1.getMessage()), (Throwable)e1);
            }
        }
        catch (NamingException e) {
            logger.error((Object)("Naming exception while obtaining connection factory for '" + this.connectionFactoryString + "' " + e.getMessage()), (Throwable)e);
        }
        return destination;
    }

    public Session getSession(Connection connection) {
        return this.createSession(connection);
    }

    protected Session createSession(Connection connection) {
        try {
            if ("1.1".equals(this.jmsSpec) || "2.0".equals(this.jmsSpec)) {
                return connection.createSession(this.transactedSession, this.sessionAckMode);
            }
            if (this.destinationType.equals((Object)JMSConstants.JMSDestinationType.QUEUE)) {
                return ((QueueConnection)connection).createQueueSession(this.transactedSession, this.sessionAckMode);
            }
            if (this.destinationType.equals((Object)JMSConstants.JMSDestinationType.TOPIC)) {
                return ((TopicConnection)connection).createTopicSession(this.transactedSession, this.sessionAckMode);
            }
        }
        catch (JMSException e) {
            logger.error((Object)("JMS Exception while obtaining session for factory '" + this.connectionFactoryString + "' " + e.getMessage()), (Throwable)e);
        }
        return null;
    }

    public void start(Connection connection) {
        try {
            connection.start();
        }
        catch (JMSException e) {
            logger.error((Object)("JMS Exception while starting connection for factory '" + this.connectionFactoryString + "' " + e.getMessage()), (Throwable)e);
        }
    }

    public void stop(Connection connection) {
        try {
            connection.stop();
        }
        catch (JMSException e) {
            logger.error((Object)("JMS Exception while stopping connection for factory '" + this.connectionFactoryString + "' " + e.getMessage()), (Throwable)e);
        }
    }

    public boolean closeConnection(Connection connection) {
        try {
            connection.close();
            return true;
        }
        catch (JMSException e) {
            logger.error((Object)"JMS Exception while closing the connection.");
            return false;
        }
    }

    public Context getContext() {
        return this.ctx;
    }

    public JMSConstants.JMSDestinationType getDestinationType() {
        return this.destinationType;
    }

    public String getConnectionFactoryString() {
        return this.connectionFactoryString;
    }

    public boolean isTransactedSession() {
        return this.transactedSession;
    }

    public int getSessionAckMode() {
        return this.sessionAckMode;
    }

    public JMSContext createContext() {
        return this.connectionFactory.createContext();
    }

    public JMSContext createContext(int sessionMode) {
        return this.connectionFactory.createContext(sessionMode);
    }

    public JMSContext createContext(String userName, String password) {
        return this.connectionFactory.createContext(userName, password);
    }

    public JMSContext createContext(String userName, String password, int sessionMode) {
        return this.connectionFactory.createContext(userName, password, sessionMode);
    }
}

