/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.hl7.management;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.parser.PipeParser;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.nio.util.HeapByteBufferAllocator;
import org.apache.synapse.SynapseException;
import org.apache.synapse.inbound.InboundProcessorParams;
import org.apache.synapse.transport.passthru.util.BufferFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.inbound.endpoint.common.AbstractInboundEndpointManager;
import org.wso2.carbon.inbound.endpoint.inboundfactory.InboundRequestProcessorFactoryImpl;
import org.wso2.carbon.inbound.endpoint.protocol.hl7.HL7MessagePreprocessor;
import org.wso2.carbon.inbound.endpoint.protocol.hl7.core.HL7Processor;
import org.wso2.carbon.inbound.endpoint.protocol.hl7.core.InboundHL7IOReactor;
import org.wso2.carbon.inbound.endpoint.protocol.hl7.core.MLLPConstants;

public class HL7EndpointManager
extends AbstractInboundEndpointManager {
    private static final Log log = LogFactory.getLog(HL7EndpointManager.class);
    private static HL7EndpointManager instance = new HL7EndpointManager();

    private HL7EndpointManager() {
    }

    public static HL7EndpointManager getInstance() {
        return instance;
    }

    @Override
    public boolean startListener(int port, String name, InboundProcessorParams params) {
        log.info((Object)("Starting HL7 Inbound Endpoint on port " + port));
        PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        String tenantDomain = carbonContext.getTenantDomain();
        if (params.getProperties().getProperty("HL7_INBOUND_TENANT_DOMAIN") == null) {
            params.getProperties().put("HL7_INBOUND_TENANT_DOMAIN", tenantDomain);
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("HL7_INBOUND_PARAMS", params);
        parameters.put("INBOUND_HL7_BUFFER_FACTORY", new BufferFactory(8192, (ByteBufferAllocator)new HeapByteBufferAllocator(), 1024));
        this.validateParameters(params, parameters);
        HL7Processor hl7Processor = new HL7Processor(parameters);
        parameters.put("HL7_REQ_PROCESSOR", hl7Processor);
        return InboundHL7IOReactor.bind(port, hl7Processor);
    }

    @Override
    public boolean startEndpoint(int port, String name, InboundProcessorParams params) {
        PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        String tenantDomain = carbonContext.getTenantDomain();
        params.getProperties().setProperty("HL7_INBOUND_TENANT_DOMAIN", tenantDomain);
        String epName = this.dataStore.getListeningEndpointName(port, tenantDomain);
        if (epName != null) {
            if (!epName.equalsIgnoreCase(name)) {
                String msg = "Another endpoint named : " + epName + " is currently using this port: " + port;
                log.warn((Object)msg);
                throw new SynapseException(msg);
            }
        } else {
            this.dataStore.registerListeningEndpoint(port, tenantDomain, InboundRequestProcessorFactoryImpl.Protocols.hl7.toString(), name, params);
            return this.startListener(port, name, params);
        }
        log.info((Object)(epName + " Endpoint is already started in port : " + port));
        return false;
    }

    @Override
    public void closeEndpoint(int port) {
        PrivilegedCarbonContext cc = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        String tenantDomain = cc.getTenantDomain();
        this.dataStore.unregisterListeningEndpoint(port, tenantDomain);
        if (!InboundHL7IOReactor.isEndpointRunning(port)) {
            log.info((Object)"Listener Endpoint is not started");
            return;
        }
        if (this.dataStore.isEndpointRegistryEmpty(port)) {
            InboundHL7IOReactor.unbind(port);
        }
    }

    private void validateParameters(InboundProcessorParams params, Map<String, Object> parameters) {
        if (!params.getProperties().getProperty("inbound.hl7.AutoAck").equalsIgnoreCase("true") && !params.getProperties().getProperty("inbound.hl7.AutoAck").equalsIgnoreCase("false")) {
            log.warn((Object)("Parameter inbound.hl7.AutoAck in HL7 inbound " + params.getName() + " is not valid. Default value of true will be used."));
            params.getProperties().setProperty("inbound.hl7.AutoAck", "true");
        }
        try {
            Integer.valueOf(params.getProperties().getProperty("inbound.hl7.TimeOut"));
        }
        catch (NumberFormatException e) {
            log.warn((Object)("Parameter inbound.hl7.TimeOut in HL7 inbound " + params.getName() + " is not valid. Default timeout of " + 10000 + " milliseconds will be used."));
            params.getProperties().setProperty("inbound.hl7.TimeOut", String.valueOf(10000));
        }
        try {
            if (params.getProperties().getProperty("inbound.hl7.MessagePreProcessor") != null) {
                final HL7MessagePreprocessor preProcessor = (HL7MessagePreprocessor)Class.forName(params.getProperties().getProperty("inbound.hl7.MessagePreProcessor")).newInstance();
                PipeParser preProcParser = new PipeParser(){

                    public Message parse(String message) throws HL7Exception {
                        message = preProcessor.process(message, "V2X", "ER7");
                        return super.parse(message);
                    }
                };
                parameters.put("HL7_PRE_PROC_PARSER_CLASS", preProcParser);
            }
        }
        catch (Exception e) {
            log.error((Object)("Error creating message preprocessor for HL7 inbound " + params.getName() + ": "), (Throwable)e);
        }
        try {
            if (params.getProperties().getProperty("inbound.hl7.CharSet") == null) {
                params.getProperties().setProperty("inbound.hl7.CharSet", MLLPConstants.UTF8_CHARSET.displayName());
                parameters.put("HL7_CHARSET_DECODER", MLLPConstants.UTF8_CHARSET.newDecoder());
            } else {
                parameters.put("HL7_CHARSET_DECODER", Charset.forName(params.getProperties().getProperty("inbound.hl7.CharSet")).newDecoder());
            }
        }
        catch (UnsupportedCharsetException e) {
            parameters.put("HL7_CHARSET_DECODER", MLLPConstants.UTF8_CHARSET.newDecoder());
            log.error((Object)("Unsupported charset '" + params.getProperties().getProperty("inbound.hl7.CharSet") + "' specified in HL7 inbound " + params.getName() + ". Default UTF-8 will be used instead."));
        }
        if (params.getProperties().getProperty("inbound.hl7.ValidateMessage") == null) {
            params.getProperties().setProperty("inbound.hl7.ValidateMessage", "true");
        }
        if (params.getProperties().getProperty("inbound.hl7.BuildInvalidMessages") == null) {
            params.getProperties().setProperty("inbound.hl7.BuildInvalidMessages", "false");
        } else if (!params.getProperties().getProperty("inbound.hl7.BuildInvalidMessages").equalsIgnoreCase("true") && !params.getProperties().getProperty("inbound.hl7.BuildInvalidMessages").equalsIgnoreCase("false")) {
            params.getProperties().setProperty("inbound.hl7.BuildInvalidMessages", "false");
        }
        if (params.getProperties().getProperty("inbound.hl7.PassThroughInvalidMessages") == null) {
            params.getProperties().setProperty("inbound.hl7.PassThroughInvalidMessages", "false");
        } else if (!params.getProperties().getProperty("inbound.hl7.PassThroughInvalidMessages").equalsIgnoreCase("true") && !params.getProperties().getProperty("inbound.hl7.PassThroughInvalidMessages").equalsIgnoreCase("false")) {
            params.getProperties().setProperty("inbound.hl7.PassThroughInvalidMessages", "false");
        }
    }
}

