/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.websocket;

import io.netty.buffer.ByteBufInputStream;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.util.UIDGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.Builder;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.builder.SOAPBuilder;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.InOutAxisOperation;
import org.apache.axis2.transport.TransportUtils;
import org.apache.commons.io.input.AutoCloseInputStream;
import org.apache.log4j.Logger;
import org.apache.synapse.FaultHandler;
import org.apache.synapse.Mediator;
import org.apache.synapse.SynapseException;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.core.axis2.MessageContextCreatorForAxis2;
import org.apache.synapse.inbound.InboundEndpoint;
import org.apache.synapse.mediators.MediatorFaultHandler;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.transport.customlogsetter.CustomLogSetter;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.inbound.endpoint.osgi.service.ServiceReferenceHolder;
import org.wso2.carbon.inbound.endpoint.protocol.websocket.AbstractSubprotocolHandler;
import org.wso2.carbon.inbound.endpoint.protocol.websocket.InboundWebsocketChannelContext;
import org.wso2.carbon.inbound.endpoint.protocol.websocket.InboundWebsocketResponseSender;
import org.wso2.carbon.inbound.endpoint.protocol.websocket.SubprotocolBuilderUtil;
import org.wso2.carbon.inbound.endpoint.protocol.websocket.WebsocketLogUtil;
import org.wso2.carbon.inbound.endpoint.protocol.websocket.management.WebsocketEndpointManager;
import org.wso2.carbon.inbound.endpoint.protocol.websocket.management.WebsocketSubscriberPathManager;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class InboundWebsocketSourceHandler
extends ChannelInboundHandlerAdapter {
    private static Logger log = Logger.getLogger(InboundWebsocketSourceHandler.class);
    private InboundWebsocketChannelContext wrappedContext;
    private WebSocketServerHandshaker handshaker;
    private boolean isSSLEnabled;
    private URI subscriberPath;
    private String tenantDomain;
    private int port;
    private boolean dispatchToCustomSequence;
    private InboundWebsocketResponseSender responseSender;
    private static ArrayList<String> contentTypes = new ArrayList();
    private static ArrayList<String> otherSubprotocols = new ArrayList();
    private int clientBroadcastLevel;
    private String outflowDispatchSequence;
    private String outflowErrorSequence;
    private ChannelPromise handshakeFuture;
    private ArrayList<AbstractSubprotocolHandler> subprotocolHandlers;
    private String defaultContentType;
    private int portOffset;

    public void setSubprotocolHandlers(ArrayList<AbstractSubprotocolHandler> subprotocolHandlers) {
        this.subprotocolHandlers = subprotocolHandlers;
        for (AbstractSubprotocolHandler handler : subprotocolHandlers) {
            otherSubprotocols.add(handler.getSubprotocolIdentifier());
        }
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.isSSLEnabled = ctx.channel().pipeline().get("ssl") != null;
        this.wrappedContext = new InboundWebsocketChannelContext(ctx);
        this.port = ((InetSocketAddress)ctx.channel().localAddress()).getPort() - this.portOffset;
        this.responseSender = new InboundWebsocketResponseSender(this);
        WebsocketEndpointManager.getInstance().setSourceHandler(this);
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.handshakeFuture = ctx.newPromise();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof FullHttpRequest) {
            this.handleHandshake(ctx, (FullHttpRequest)msg);
        } else if (msg instanceof WebSocketFrame) {
            this.handleWebSocketFrame(ctx, (WebSocketFrame)msg);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        String endpointName = WebsocketEndpointManager.getInstance().getEndpointName(this.port, this.tenantDomain);
        if (endpointName == null) {
            this.handleException("Endpoint not found for port : " + this.port + " tenant domain : " + this.tenantDomain);
        }
        WebsocketSubscriberPathManager.getInstance().addChannelContext(endpointName, this.subscriberPath.getPath(), this.wrappedContext);
        org.apache.synapse.MessageContext synCtx = this.getSynapseMessageContext(this.tenantDomain);
        InboundEndpoint endpoint = synCtx.getConfiguration().getInboundEndpoint(endpointName);
        synCtx.setProperty("connection.terminate", (Object)new Boolean(true));
        ((Axis2MessageContext)synCtx).getAxis2MessageContext().setProperty("connection.terminate", (Object)new Boolean(true));
        ((Axis2MessageContext)synCtx).getAxis2MessageContext().setProperty("clientId", (Object)ctx.channel().hashCode());
        this.injectToSequence(synCtx, endpoint);
    }

    private void handleHandshake(ChannelHandlerContext ctx, FullHttpRequest req) throws URISyntaxException, AxisFault {
        String endpointName;
        if (log.isDebugEnabled()) {
            WebsocketLogUtil.printHeaders(log, req, ctx);
        }
        WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(this.getWebSocketLocation(req), SubprotocolBuilderUtil.buildSubprotocolString(contentTypes, otherSubprotocols), true);
        this.handshaker = wsFactory.newHandshaker((HttpRequest)req);
        if (this.handshaker == null) {
            WebSocketServerHandshakerFactory.sendUnsupportedWebSocketVersionResponse((Channel)ctx.channel());
            if (log.isDebugEnabled()) {
                WebsocketLogUtil.printSpecificLog(log, ctx, "Unsupported websocket version.");
            }
        } else {
            ChannelFuture future = this.handshaker.handshake(ctx.channel(), req);
            future.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (future.isSuccess()) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Websocket Handshake is completed successfully");
                        }
                        InboundWebsocketSourceHandler.this.handshakeFuture.setSuccess();
                    }
                }
            });
        }
        List httpHeaders = req.headers().entries();
        this.tenantDomain = MultitenantUtils.getTenantDomainFromUrl((String)req.getUri());
        if (this.tenantDomain.equals(req.getUri())) {
            this.tenantDomain = "carbon.super";
        }
        if ((endpointName = WebsocketEndpointManager.getInstance().getEndpointName(this.port, this.tenantDomain)) == null) {
            this.handleException("Endpoint not found for port : " + this.port + " tenant domain : " + this.tenantDomain);
        }
        WebsocketSubscriberPathManager.getInstance().addChannelContext(endpointName, this.subscriberPath.getPath(), this.wrappedContext);
        org.apache.synapse.MessageContext synCtx = this.getSynapseMessageContext(this.tenantDomain);
        InboundEndpoint endpoint = synCtx.getConfiguration().getInboundEndpoint(endpointName);
        this.defaultContentType = (String)endpoint.getParametersMap().get("ws.default.content.type");
        if (endpoint == null) {
            log.error((Object)("Cannot find deployed inbound endpoint " + endpointName + "for process request"));
            return;
        }
        for (Map.Entry entry : httpHeaders) {
            synCtx.setProperty((String)entry.getKey(), entry.getValue());
            ((Axis2MessageContext)synCtx).getAxis2MessageContext().setProperty((String)entry.getKey(), entry.getValue());
        }
        synCtx.setProperty("source.handshake.present", (Object)new Boolean(true));
        ((Axis2MessageContext)synCtx).getAxis2MessageContext().setProperty("source.handshake.present", (Object)new Boolean(true));
        synCtx.setProperty("websocket.source.handshake.present", (Object)new Boolean(true));
        ((Axis2MessageContext)synCtx).getAxis2MessageContext().setProperty("websocket.source.handshake.present", (Object)new Boolean(true));
        ((Axis2MessageContext)synCtx).getAxis2MessageContext().setProperty("clientId", (Object)ctx.channel().hashCode());
        this.injectToSequence(synCtx, endpoint);
    }

    private String getWebSocketLocation(FullHttpRequest req) throws URISyntaxException {
        String location = req.headers().get("Host") + req.getUri();
        this.subscriberPath = new URI(req.getUri());
        if (this.isSSLEnabled) {
            return "wss://" + location;
        }
        return "ws://" + location;
    }

    private boolean interceptWebsocketMessageFlow(ChannelHandlerContext ctx, WebSocketFrame frame) {
        if (this.handshaker.selectedSubprotocol() == null || this.subprotocolHandlers == null || this.subprotocolHandlers != null && this.subprotocolHandlers.isEmpty()) {
            return false;
        }
        boolean continueFlow = false;
        for (AbstractSubprotocolHandler handler : this.subprotocolHandlers) {
            if (this.handshaker.selectedSubprotocol() == null || !this.handshaker.selectedSubprotocol().contains(handler.getSubprotocolIdentifier())) continue;
            continueFlow = handler.handle(ctx, frame, this.subscriberPath.toString());
            break;
        }
        return !continueFlow;
    }

    private void handleWebSocketFrame(ChannelHandlerContext ctx, WebSocketFrame frame) {
        block27: {
            try {
                if (log.isDebugEnabled()) {
                    WebsocketLogUtil.printWebSocketFrame(log, frame, ctx, true);
                }
                if (this.handshakeFuture.isSuccess()) {
                    String endpointName = WebsocketEndpointManager.getInstance().getEndpointName(this.port, this.tenantDomain);
                    org.apache.synapse.MessageContext synCtx = this.getSynapseMessageContext(this.tenantDomain);
                    InboundEndpoint endpoint = synCtx.getConfiguration().getInboundEndpoint(endpointName);
                    ((Axis2MessageContext)synCtx).getAxis2MessageContext().setProperty("clientId", (Object)ctx.channel().hashCode());
                    if (endpoint == null) {
                        log.error((Object)("Cannot find deployed inbound endpoint " + endpointName + "for process request"));
                        return;
                    }
                    if (this.interceptWebsocketMessageFlow(ctx, frame)) {
                        return;
                    }
                    if (frame instanceof CloseWebSocketFrame) {
                        this.handleClientWebsocketChannelTermination(frame);
                        if (log.isDebugEnabled()) {
                            WebsocketLogUtil.printSpecificLog(log, ctx, "Websocket channel is terminated successfully.");
                        }
                        return;
                    }
                    if (frame instanceof BinaryWebSocketFrame && (this.handshaker.selectedSubprotocol() == null || this.handshaker.selectedSubprotocol() != null && !this.handshaker.selectedSubprotocol().contains("synapse"))) {
                        String contentType = this.handshaker.selectedSubprotocol();
                        if (contentType == null && this.defaultContentType != null) {
                            contentType = this.defaultContentType;
                        }
                        this.handleWebsocketBinaryFrame(frame, synCtx);
                        MessageContext axis2MsgCtx = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
                        Builder builder = BuilderUtil.getBuilderFromSelector((String)contentType, (MessageContext)axis2MsgCtx);
                        if (builder != null) {
                            if ("org.wso2.carbon.relay.BinaryRelayBuilder".equals(builder.getClass().getName())) {
                                synCtx.setProperty("websocket.binary.frame.present", (Object)true);
                            } else {
                                synCtx.setProperty("websocket.binary.frame.present", (Object)false);
                            }
                            AutoCloseInputStream in = new AutoCloseInputStream((InputStream)new ByteBufInputStream(frame.duplicate().content()));
                            OMElement documentElement = builder.processDocument((InputStream)in, contentType, axis2MsgCtx);
                            synCtx.setEnvelope(TransportUtils.createSOAPEnvelope((OMElement)documentElement));
                        }
                        this.injectToSequence(synCtx, endpoint);
                        return;
                    }
                    if (frame instanceof TextWebSocketFrame && (this.handshaker.selectedSubprotocol() == null || this.handshaker.selectedSubprotocol() != null && !this.handshaker.selectedSubprotocol().contains("synapse"))) {
                        String contentType = this.handshaker.selectedSubprotocol();
                        if (contentType == null && this.defaultContentType != null) {
                            contentType = this.defaultContentType;
                        }
                        this.handleWebsocketPassthroughTextFrame(frame, synCtx);
                        MessageContext axis2MsgCtx = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
                        Builder builder = BuilderUtil.getBuilderFromSelector((String)contentType, (MessageContext)axis2MsgCtx);
                        if (builder != null) {
                            if (builder != null && "org.apache.axis2.format.PlainTextBuilder".equals(builder.getClass().getName())) {
                                synCtx.setProperty("websocket.text.frame.present", (Object)true);
                            } else {
                                synCtx.setProperty("websocket.text.frame.present", (Object)false);
                            }
                            AutoCloseInputStream in = new AutoCloseInputStream((InputStream)new ByteArrayInputStream(((TextWebSocketFrame)frame).duplicate().text().getBytes()));
                            OMElement documentElement = builder.processDocument((InputStream)in, contentType, axis2MsgCtx);
                            synCtx.setEnvelope(TransportUtils.createSOAPEnvelope((OMElement)documentElement));
                        }
                        this.injectToSequence(synCtx, endpoint);
                        return;
                    }
                    if (frame instanceof TextWebSocketFrame && this.handshaker.selectedSubprotocol() != null && this.handshaker.selectedSubprotocol().contains("synapse")) {
                        CustomLogSetter.getInstance().setLogAppender(endpoint.getArtifactContainerName());
                        String message = ((TextWebSocketFrame)frame).text();
                        String contentType = SubprotocolBuilderUtil.syanapeSubprotocolToContentType(SubprotocolBuilderUtil.extractSynapseSubprotocol(this.handshaker.selectedSubprotocol()));
                        MessageContext axis2MsgCtx = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
                        SOAPBuilder builder = null;
                        if (contentType == null) {
                            log.debug((Object)"No content type specified. Using SOAP builder.");
                            builder = new SOAPBuilder();
                        } else {
                            int index = contentType.indexOf(59);
                            String type = index > 0 ? contentType.substring(0, index) : contentType;
                            try {
                                builder = BuilderUtil.getBuilderFromSelector((String)type, (MessageContext)axis2MsgCtx);
                            }
                            catch (AxisFault axisFault) {
                                log.error((Object)("Error while creating message builder :: " + axisFault.getMessage()));
                            }
                            if (builder == null) {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("No message builder found for type '" + type + "'. Falling back to SOAP."));
                                }
                                builder = new SOAPBuilder();
                            }
                        }
                        OMElement documentElement = null;
                        AutoCloseInputStream in = new AutoCloseInputStream((InputStream)new ByteArrayInputStream(message.getBytes()));
                        documentElement = builder.processDocument((InputStream)in, contentType, axis2MsgCtx);
                        synCtx.setEnvelope(TransportUtils.createSOAPEnvelope((OMElement)documentElement));
                        this.injectToSequence(synCtx, endpoint);
                        break block27;
                    }
                    if (frame instanceof PingWebSocketFrame) {
                        ctx.channel().writeAndFlush((Object)new PongWebSocketFrame(frame.content().retain()));
                        PongWebSocketFrame pongWebSocketFrame = new PongWebSocketFrame(frame.content().retain());
                        ctx.channel().writeAndFlush((Object)pongWebSocketFrame);
                        if (log.isDebugEnabled()) {
                            WebsocketLogUtil.printWebSocketFrame(log, (WebSocketFrame)pongWebSocketFrame, ctx, false);
                        }
                        return;
                    }
                    break block27;
                }
                log.error((Object)"Handshake incomplete at source handler. Failed to inject websocket frames to Synapse engine");
            }
            catch (Exception e) {
                log.error((Object)"Exception occured while injecting websocket frames to the Synapse engine", (Throwable)e);
            }
        }
    }

    public void handleClientWebsocketChannelTermination(WebSocketFrame frame) throws AxisFault {
        this.handshaker.close(this.wrappedContext.getChannelHandlerContext().channel(), (CloseWebSocketFrame)frame.retain());
        String endpointName = WebsocketEndpointManager.getInstance().getEndpointName(this.port, this.tenantDomain);
        WebsocketSubscriberPathManager.getInstance().removeChannelContext(endpointName, this.subscriberPath.getPath(), this.wrappedContext);
    }

    protected void handleWebsocketBinaryFrame(WebSocketFrame frame, org.apache.synapse.MessageContext synCtx) throws AxisFault {
        String endpointName = WebsocketEndpointManager.getInstance().getEndpointName(this.port, this.tenantDomain);
        InboundEndpoint endpoint = synCtx.getConfiguration().getInboundEndpoint(endpointName);
        if (endpoint == null) {
            log.error((Object)("Cannot find deployed inbound endpoint " + endpointName + "for process request"));
            return;
        }
        synCtx.setProperty("websocket.binary.frame.present", (Object)new Boolean(true));
        ((Axis2MessageContext)synCtx).getAxis2MessageContext().setProperty("websocket.binary.frame.present", (Object)new Boolean(true));
        synCtx.setProperty("websocket.binary.frame", (Object)frame);
        ((Axis2MessageContext)synCtx).getAxis2MessageContext().setProperty("websocket.binary.frame", (Object)frame);
    }

    protected void handleWebsocketPassthroughTextFrame(WebSocketFrame frame, org.apache.synapse.MessageContext synCtx) throws AxisFault {
        String endpointName = WebsocketEndpointManager.getInstance().getEndpointName(this.port, this.tenantDomain);
        InboundEndpoint endpoint = synCtx.getConfiguration().getInboundEndpoint(endpointName);
        if (endpoint == null) {
            log.error((Object)("Cannot find deployed inbound endpoint " + endpointName + "for process request"));
            return;
        }
        synCtx.setProperty("websocket.text.frame.present", (Object)new Boolean(true));
        ((Axis2MessageContext)synCtx).getAxis2MessageContext().setProperty("websocket.text.frame.present", (Object)new Boolean(true));
        synCtx.setProperty("websocket.text.frame", (Object)frame);
        ((Axis2MessageContext)synCtx).getAxis2MessageContext().setProperty("websocket.text.frame", (Object)frame);
    }

    public InboundWebsocketChannelContext getChannelHandlerContext() {
        return this.wrappedContext;
    }

    public String getSubscriberPath() {
        return this.subscriberPath.getPath();
    }

    public int getClientBroadcastLevel() {
        return this.clientBroadcastLevel;
    }

    public String getDefaultContentType() {
        return this.defaultContentType;
    }

    public void setOutflowDispatchSequence(String outflowDispatchSequence) {
        this.outflowDispatchSequence = outflowDispatchSequence;
    }

    public void setOutflowErrorSequence(String outflowErrorSequence) {
        this.outflowErrorSequence = outflowErrorSequence;
    }

    public void setClientBroadcastLevel(int clientBroadcastLevel) {
        this.clientBroadcastLevel = clientBroadcastLevel;
    }

    protected void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }

    public int getPort() {
        return this.port;
    }

    public String getTenantDomain() {
        return this.tenantDomain;
    }

    public org.apache.synapse.MessageContext getSynapseMessageContext(String tenantDomain) throws AxisFault {
        org.apache.synapse.MessageContext synCtx = InboundWebsocketSourceHandler.createSynapseMessageContext(tenantDomain);
        synCtx.setProperty("isInbound", (Object)true);
        ((Axis2MessageContext)synCtx).getAxis2MessageContext().setProperty("isInbound", (Object)true);
        synCtx.setProperty("inbound-response-worker", (Object)this.responseSender);
        ((Axis2MessageContext)synCtx).getAxis2MessageContext().setProperty("inbound-response-worker", (Object)this.responseSender);
        synCtx.setProperty("websocket.source.handler.context", (Object)this.wrappedContext.getChannelHandlerContext());
        ((Axis2MessageContext)synCtx).getAxis2MessageContext().setProperty("websocket.source.handler.context", (Object)this.wrappedContext.getChannelHandlerContext());
        if (this.outflowDispatchSequence != null) {
            synCtx.setProperty("ws.outflow.dispatch.sequence", (Object)this.outflowDispatchSequence);
            ((Axis2MessageContext)synCtx).getAxis2MessageContext().setProperty("ws.outflow.dispatch.sequence", (Object)this.outflowDispatchSequence);
        }
        if (this.outflowErrorSequence != null) {
            synCtx.setProperty("ws.outflow.dispatch.fault.sequence", (Object)this.outflowErrorSequence);
            ((Axis2MessageContext)synCtx).getAxis2MessageContext().setProperty("ws.outflow.dispatch.fault.sequence", (Object)this.outflowErrorSequence);
        }
        synCtx.setProperty("websocket.subscriber.path", (Object)this.subscriberPath.toString());
        return synCtx;
    }

    private static org.apache.synapse.MessageContext createSynapseMessageContext(String tenantDomain) throws AxisFault {
        MessageContext axis2MsgCtx = InboundWebsocketSourceHandler.createAxis2MessageContext();
        ServiceContext svcCtx = new ServiceContext();
        OperationContext opCtx = new OperationContext((AxisOperation)new InOutAxisOperation(), svcCtx);
        axis2MsgCtx.setServiceContext(svcCtx);
        axis2MsgCtx.setOperationContext(opCtx);
        if (!tenantDomain.equals("carbon.super")) {
            ConfigurationContext tenantConfigCtx = TenantAxisUtils.getTenantConfigurationContext((String)tenantDomain, (ConfigurationContext)axis2MsgCtx.getConfigurationContext());
            axis2MsgCtx.setConfigurationContext(tenantConfigCtx);
            axis2MsgCtx.setProperty("tenantDomain", (Object)tenantDomain);
        } else {
            axis2MsgCtx.setProperty("tenantDomain", (Object)"carbon.super");
        }
        SOAPFactory fac = OMAbstractFactory.getSOAP11Factory();
        SOAPEnvelope envelope = fac.getDefaultEnvelope();
        axis2MsgCtx.setEnvelope(envelope);
        return MessageContextCreatorForAxis2.getSynapseMessageContext((MessageContext)axis2MsgCtx);
    }

    private static MessageContext createAxis2MessageContext() {
        MessageContext axis2MsgCtx = new MessageContext();
        axis2MsgCtx.setMessageID(UIDGenerator.generateURNString());
        axis2MsgCtx.setConfigurationContext(ServiceReferenceHolder.getInstance().getConfigurationContextService().getServerConfigContext());
        axis2MsgCtx.setProperty("ClientApiNonBlocking", (Object)Boolean.TRUE);
        axis2MsgCtx.setServerSide(true);
        return axis2MsgCtx;
    }

    private void injectToSequence(org.apache.synapse.MessageContext synCtx, InboundEndpoint endpoint) {
        SequenceMediator injectingSequence = null;
        if (endpoint.getInjectingSeq() != null) {
            injectingSequence = (SequenceMediator)synCtx.getSequence(endpoint.getInjectingSeq());
        }
        if (injectingSequence == null) {
            injectingSequence = (SequenceMediator)synCtx.getMainSequence();
        }
        SequenceMediator faultSequence = this.getFaultSequence(synCtx, endpoint);
        MediatorFaultHandler mediatorFaultHandler = new MediatorFaultHandler((Mediator)faultSequence);
        synCtx.pushFaultHandler((FaultHandler)mediatorFaultHandler);
        if (log.isDebugEnabled()) {
            log.debug((Object)("injecting message to sequence : " + endpoint.getInjectingSeq()));
        }
        synCtx.setProperty("inbound.endpoint.name", (Object)endpoint.getName());
        if (this.dispatchToCustomSequence) {
            String context = this.subscriberPath.getPath().substring(1);
            context = context.replace('/', '-');
            if (synCtx.getConfiguration().getDefinedSequences().containsKey(context)) {
                injectingSequence = (SequenceMediator)synCtx.getSequence(context);
            }
        }
        synCtx.getEnvironment().injectMessage(synCtx, injectingSequence);
    }

    private SequenceMediator getFaultSequence(org.apache.synapse.MessageContext synCtx, InboundEndpoint endpoint) {
        SequenceMediator faultSequence = null;
        if (endpoint.getOnErrorSeq() != null) {
            faultSequence = (SequenceMediator)synCtx.getSequence(endpoint.getOnErrorSeq());
        }
        if (faultSequence == null) {
            faultSequence = (SequenceMediator)synCtx.getFaultSequence();
        }
        return faultSequence;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (!this.handshakeFuture.isDone()) {
            this.handshakeFuture.setFailure(cause);
        }
        ctx.close();
    }

    public void setDispatchToCustomSequence(boolean dispatchToCustomSequence) {
        this.dispatchToCustomSequence = dispatchToCustomSequence;
    }

    public void setPortOffset(int portOffset) {
        this.portOffset = portOffset;
    }

    static {
        contentTypes.add("application/xml");
        contentTypes.add("application/json");
        contentTypes.add("text/xml");
    }
}

