/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.http;

import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.axis2.transport.base.threads.WorkerPool;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpException;
import org.apache.http.nio.NHttpConnection;
import org.apache.http.nio.NHttpServerConnection;
import org.apache.synapse.transport.passthru.ProtocolState;
import org.apache.synapse.transport.passthru.SourceContext;
import org.apache.synapse.transport.passthru.SourceHandler;
import org.apache.synapse.transport.passthru.SourceRequest;
import org.apache.synapse.transport.passthru.config.SourceConfiguration;
import org.wso2.carbon.inbound.endpoint.protocol.http.InboundHttpServerWorker;
import org.wso2.carbon.inbound.endpoint.protocol.http.config.WorkerPoolConfiguration;
import org.wso2.carbon.inbound.endpoint.protocol.http.management.HTTPEndpointManager;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class InboundHttpSourceHandler
extends SourceHandler {
    private static final Log log = LogFactory.getLog(InboundHttpSourceHandler.class);
    private final SourceConfiguration sourceConfiguration;
    private int port;
    private WorkerPool workerPool;
    private Lock lock = new ReentrantLock();

    public InboundHttpSourceHandler(int port, SourceConfiguration sourceConfiguration) {
        super(sourceConfiguration);
        this.sourceConfiguration = sourceConfiguration;
        this.port = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestReceived(NHttpServerConnection conn) {
        try {
            SourceRequest request = this.getSourceRequest(conn);
            if (request == null) {
                return;
            }
            String method = request.getRequest() != null ? request.getRequest().getRequestLine().getMethod().toUpperCase() : "";
            OutputStream os = this.getOutputStream(method, request);
            Object dispatchPattern = null;
            String tenantDomain = this.getTenantDomain(request);
            if (tenantDomain != null && this.workerPool == null) {
                this.lock.lock();
                try {
                    WorkerPoolConfiguration workerPoolConfiguration;
                    if (this.workerPool == null && (workerPoolConfiguration = HTTPEndpointManager.getInstance().getWorkerPoolConfiguration(tenantDomain, this.port)) != null) {
                        this.workerPool = this.sourceConfiguration.getWorkerPool(workerPoolConfiguration.getWorkerPoolCoreSize(), workerPoolConfiguration.getWorkerPoolSizeMax(), workerPoolConfiguration.getWorkerPoolThreadKeepAliveSec(), workerPoolConfiguration.getWorkerPoolQueuLength(), workerPoolConfiguration.getThreadGroupID(), workerPoolConfiguration.getThreadID());
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
            if (this.workerPool == null) {
                this.workerPool = this.sourceConfiguration.getWorkerPool();
            }
            this.workerPool.execute((Runnable)((Object)new InboundHttpServerWorker(this.port, tenantDomain, request, this.sourceConfiguration, os)));
            this.sourceConfiguration.getMetrics().requestReceived();
        }
        catch (HttpException e) {
            log.error((Object)"HttpException occurred when creating Source Request", (Throwable)e);
            this.informReaderError(conn);
            SourceContext.updateState((NHttpConnection)conn, (ProtocolState)ProtocolState.CLOSED);
            this.sourceConfiguration.getSourceConnections().shutDownConnection(conn, true);
        }
        catch (IOException e) {
            this.logIOException(conn, e);
            this.informReaderError(conn);
            SourceContext.updateState((NHttpConnection)conn, (ProtocolState)ProtocolState.CLOSED);
            this.sourceConfiguration.getSourceConnections().shutDownConnection(conn, true);
        }
    }

    private String getTenantDomain(SourceRequest request) {
        String tenant = MultitenantUtils.getTenantDomainFromUrl((String)request.getUri());
        if (tenant.equals(request.getUri())) {
            return "carbon.super";
        }
        return tenant;
    }
}

