/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.websocket;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.wso2.carbon.inbound.endpoint.protocol.websocket.AbstractSubprotocolHandler;

public class SubprotocolBuilderUtil {
    private static String SYNAPSE_SUBPROTOCOL_PREFIX = "synapse(";
    private static String SYNAPSE_SUBPROTOCOL_SUFFIX = ")";
    private static String SYNAPSE_CONTENT_TYPE = "contentType=";
    private static String SUBPROTOCOL_SEPERATOR = ",";
    private static final Log log = LogFactory.getLog(SubprotocolBuilderUtil.class);

    public static String buildSubprotocolString(ArrayList<String> contentType, ArrayList<String> otherSubprotocols) {
        String array = "";
        if (contentType != null && !contentType.isEmpty()) {
            for (String content : contentType) {
                String temp = SYNAPSE_SUBPROTOCOL_PREFIX + SYNAPSE_CONTENT_TYPE + "'" + content + "'" + SYNAPSE_SUBPROTOCOL_SUFFIX;
                array = array.concat(temp).concat(",");
            }
        }
        if (otherSubprotocols != null && !otherSubprotocols.isEmpty()) {
            for (String protocol : otherSubprotocols) {
                array = array.concat(protocol).concat(",");
            }
        }
        return array;
    }

    public static String syanapeSubprotocolToContentType(String subprotocol) {
        Pattern pattern = Pattern.compile(SYNAPSE_SUBPROTOCOL_PREFIX + ".*" + SYNAPSE_SUBPROTOCOL_SUFFIX);
        if (pattern.matcher(subprotocol).matches()) {
            subprotocol = subprotocol.replace(SYNAPSE_SUBPROTOCOL_PREFIX + SYNAPSE_CONTENT_TYPE + "'", "").replace("'" + SYNAPSE_SUBPROTOCOL_SUFFIX, "");
            subprotocol = subprotocol.trim();
            return subprotocol;
        }
        return null;
    }

    public static String extractSynapseSubprotocol(String combinedSubprotocol) {
        String[] subprotocolArray;
        for (String subprotocol : subprotocolArray = combinedSubprotocol.split(SUBPROTOCOL_SEPERATOR)) {
            if (!subprotocol.contains("synapse")) continue;
            return subprotocol;
        }
        return null;
    }

    public static String contentTypeToSyanapeSubprotocol(String contentType) {
        return SYNAPSE_SUBPROTOCOL_PREFIX + SYNAPSE_CONTENT_TYPE + "'" + contentType + "'" + SYNAPSE_SUBPROTOCOL_SUFFIX;
    }

    public static ArrayList<AbstractSubprotocolHandler> stringToSubprotocolHandlers(String handlerClasses) {
        ArrayList<AbstractSubprotocolHandler> handlerInstances = new ArrayList<AbstractSubprotocolHandler>();
        if (handlerClasses != null) {
            String[] arrayClassesImpl;
            for (String classImpl : arrayClassesImpl = handlerClasses.split(";")) {
                String msg;
                try {
                    Class<?> c = Class.forName(classImpl);
                    Constructor<?> cons = c.getConstructor(new Class[0]);
                    AbstractSubprotocolHandler handlerInstance = (AbstractSubprotocolHandler)cons.newInstance(new Object[0]);
                    handlerInstances.add(handlerInstance);
                }
                catch (ClassNotFoundException e) {
                    msg = "Class " + classImpl + " not found. Please check the required class is added to the classpath.";
                    log.error((Object)msg, (Throwable)e);
                    throw new SynapseException((Throwable)e);
                }
                catch (NoSuchMethodException e) {
                    msg = "Required constructor is not implemented.";
                    log.error((Object)msg, (Throwable)e);
                    throw new SynapseException((Throwable)e);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    msg = "Couldn't create the class instance.";
                    log.error((Object)msg, (Throwable)e);
                    throw new SynapseException((Throwable)e);
                }
            }
        }
        return handlerInstances;
    }
}

