/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.common;

import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.inbound.endpoint.persistence.service.InboundEndpointPersistenceServiceDSComponent;
import org.wso2.carbon.utils.ConfigurationContextService;

public abstract class OneTimeTriggerAbstractCallback {
    private volatile Semaphore callbackSuspensionSemaphore = new Semaphore(0);
    private AtomicBoolean isCallbackSuspended = new AtomicBoolean(false);
    private AtomicBoolean isShutdownFlagSet = new AtomicBoolean(false);
    protected String tenantDomain;
    private boolean isInboundRunnerMode = false;
    private static final Log log = LogFactory.getLog(OneTimeTriggerAbstractCallback.class);

    protected void handleReconnection() throws InterruptedException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Started handling reconnection due to connection lost callback");
        }
        if (!this.isInboundRunnerMode) {
            this.isCallbackSuspended.set(true);
            this.callbackSuspensionSemaphore.acquire();
            if (!this.isShutdownFlagSet.get()) {
                this.reConnect();
            }
            this.isCallbackSuspended.set(false);
        } else {
            this.reConnect();
        }
    }

    protected void shutdown() {
        this.isShutdownFlagSet.set(true);
        if (this.isCallbackSuspended.get()) {
            this.callbackSuspensionSemaphore.release();
        }
    }

    protected abstract void reConnect();

    public void releaseCallbackSuspension() {
        if (this.callbackSuspensionSemaphore.availablePermits() < 1) {
            this.callbackSuspensionSemaphore.release();
        }
    }

    public boolean isCallbackSuspended() {
        return this.isCallbackSuspended.get();
    }

    public void setTenantDomain(String tenantDomain) {
        this.tenantDomain = tenantDomain;
    }

    public void startInboundTenantLoading(String inboundIdentifier) {
        ConfigurationContextService configurationContext;
        if (this.isInboundRunnerMode && this.tenantDomain != null && (configurationContext = InboundEndpointPersistenceServiceDSComponent.getConfigContextService()) != null) {
            ConfigurationContext mainConfigCtx = configurationContext.getServerConfigContext();
            TenantAxisUtils.getTenantConfigurationContext((String)this.tenantDomain, (ConfigurationContext)mainConfigCtx);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Manually loaded tenant: " + this.tenantDomain));
            }
        }
    }

    public void setInboundRunnerMode(boolean isInboundRunnerMode) {
        this.isInboundRunnerMode = isInboundRunnerMode;
    }

    public boolean isInboundRunnerMode() {
        return this.isInboundRunnerMode;
    }
}

